/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.shaded.io.opentelemetry.api.internal.Utils;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentSelector;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.View;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.export.MetricReader;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.ViewRegistryBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

public final class SdkMeterProviderBuilder {
    private static final ExemplarFilter DEFAULT_EXEMPLAR_FILTER = ExemplarFilter.sampleWithTraces();
    private static final long DEFAULT_MIN_COLLECTION_INTERVAL_NANOS = 0L;
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final ViewRegistryBuilder viewRegistryBuilder = ViewRegistry.builder();
    private final List<MetricReader> metricReaders = new ArrayList<MetricReader>();
    private ExemplarFilter exemplarFilter = DEFAULT_EXEMPLAR_FILTER;
    private long minimumCollectionIntervalNanos = 0L;

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.viewRegistryBuilder.addView(selector, view, view.getAttributesProcessor(), SourceInfo.fromCurrentStack());
        return this;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReader reader) {
        this.metricReaders.add(reader);
        return this;
    }

    SdkMeterProviderBuilder setMinimumCollectionInterval(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        Utils.checkArgument(!duration.isNegative(), "duration must not be negative");
        this.minimumCollectionIntervalNanos = duration.toNanos();
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.metricReaders, this.clock, this.resource, this.viewRegistryBuilder.build(), this.exemplarFilter, this.minimumCollectionIntervalNanos);
    }
}

