/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common.channel;

import io.netty.channel.Channel;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcClientChannel;
import org.apache.rocketmq.proxy.processor.channel.ChannelProtocolType;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannel;
import org.apache.rocketmq.proxy.remoting.channel.RemotingChannel;

public class ChannelHelper {
    public static boolean isRemote(Channel channel) {
        return channel instanceof RemoteChannel;
    }

    public static ChannelProtocolType getChannelProtocolType(Channel channel) {
        if (channel instanceof GrpcClientChannel) {
            return ChannelProtocolType.GRPC_V2;
        }
        if (channel instanceof RemotingChannel) {
            return ChannelProtocolType.REMOTING;
        }
        if (channel instanceof RemoteChannel) {
            RemoteChannel remoteChannel = (RemoteChannel)channel;
            return remoteChannel.getType();
        }
        return ChannelProtocolType.UNKNOWN;
    }
}

