/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.resourcematcher.AbstractStringResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveEndsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStartsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveEndsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveStartsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.QuotedCaseSensitiveEndsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.QuotedCaseSensitiveStartsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.QuotedCaseSensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.QuotedCaseSensitiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcherWrapper;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerAbstractResourceMatcher
implements RangerResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAbstractResourceMatcher.class);
    public static final String WILDCARD_ASTERISK = "*";
    public static final String WILDCARD_QUESTION_MARK = "?";
    public static final String OPTION_IGNORE_CASE = "ignoreCase";
    public static final String OPTION_QUOTED_CASE_SENSITIVE = "quotedCaseSensitive";
    public static final String OPTION_QUOTE_CHARS = "quoteChars";
    public static final String OPTION_WILD_CARD = "wildCard";
    public static final String OPTION_REPLACE_TOKENS = "replaceTokens";
    public static final String OPTION_TOKEN_DELIMITER_START = "tokenDelimiterStart";
    public static final String OPTION_TOKEN_DELIMITER_END = "tokenDelimiterEnd";
    public static final String OPTION_TOKEN_DELIMITER_ESCAPE = "tokenDelimiterEscape";
    public static final String OPTION_TOKEN_DELIMITER_PREFIX = "tokenDelimiterPrefix";
    public static final String OPTION_REPLACE_REQ_EXPRESSIONS = "replaceReqExpressions";
    protected RangerServiceDef.RangerResourceDef resourceDef;
    protected RangerPolicy.RangerPolicyResource policyResource;
    protected boolean optIgnoreCase;
    protected boolean optQuotedCaseSensitive;
    protected String optQuoteChars = "\"";
    protected boolean optWildCard;
    protected List<String> policyValues;
    protected boolean policyIsExcludes;
    protected boolean isMatchAny;
    protected ResourceMatcherWrapper resourceMatchers;
    protected boolean optReplaceTokens;
    protected char startDelimiterChar = (char)123;
    protected char endDelimiterChar = (char)125;
    protected char escapeChar = (char)92;
    protected String tokenPrefix = "";

    @Override
    public void setResourceDef(RangerServiceDef.RangerResourceDef resourceDef) {
        this.resourceDef = resourceDef;
    }

    @Override
    public void setPolicyResource(RangerPolicy.RangerPolicyResource policyResource) {
        this.policyResource = policyResource;
    }

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractResourceMatcher.init()");
        }
        Map<String, String> options = this.resourceDef != null ? this.resourceDef.getMatcherOptions() : null;
        this.optIgnoreCase = RangerAbstractResourceMatcher.getOptionIgnoreCase(options);
        this.optQuotedCaseSensitive = RangerAbstractResourceMatcher.getOptionQuotedCaseSensitive(options);
        this.optQuoteChars = RangerAbstractResourceMatcher.getOptionQuoteChars(options);
        this.optWildCard = RangerAbstractResourceMatcher.getOptionWildCard(options);
        this.policyValues = new ArrayList<String>();
        boolean bl = this.policyIsExcludes = this.policyResource != null && this.policyResource.getIsExcludes() != false;
        if (this.policyResource != null && this.policyResource.getValues() != null) {
            for (String policyValue : this.policyResource.getValues()) {
                if (StringUtils.isEmpty((String)policyValue)) continue;
                this.policyValues.add(policyValue);
            }
        }
        this.optReplaceTokens = RangerAbstractResourceMatcher.getOptionReplaceTokens(options);
        if (this.optReplaceTokens) {
            this.startDelimiterChar = RangerAbstractResourceMatcher.getOptionDelimiterStart(options);
            this.endDelimiterChar = RangerAbstractResourceMatcher.getOptionDelimiterEnd(options);
            this.escapeChar = RangerAbstractResourceMatcher.getOptionDelimiterEscape(options);
            this.tokenPrefix = RangerAbstractResourceMatcher.getOptionDelimiterPrefix(options);
            if (this.escapeChar == this.startDelimiterChar || this.escapeChar == this.endDelimiterChar || this.tokenPrefix.indexOf(this.escapeChar) != -1 || this.tokenPrefix.indexOf(this.startDelimiterChar) != -1 || this.tokenPrefix.indexOf(this.endDelimiterChar) != -1) {
                String resouceName = this.resourceDef == null ? "" : this.resourceDef.getName();
                String msg = "Invalid token-replacement parameters for resource '" + resouceName + "': { ";
                msg = msg + "tokenDelimiterStart='" + this.startDelimiterChar + "'; ";
                msg = msg + "tokenDelimiterEnd='" + this.endDelimiterChar + "'; ";
                msg = msg + "tokenDelimiterEscape='" + this.escapeChar + "'; ";
                msg = msg + "tokenDelimiterPrefix='" + this.tokenPrefix + "' }. ";
                msg = msg + "Token replacement disabled";
                LOG.error(msg);
                this.optReplaceTokens = false;
            }
        }
        this.resourceMatchers = this.buildResourceMatchers();
        boolean bl2 = this.isMatchAny = this.resourceMatchers == null || CollectionUtils.isEmpty(this.resourceMatchers.getResourceMatchers());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractResourceMatcher.init()");
        }
    }

    @Override
    public boolean isMatchAny() {
        return this.isMatchAny;
    }

    @Override
    public boolean getNeedsDynamicEval() {
        return this.resourceMatchers != null && this.resourceMatchers.getNeedsDynamicEval();
    }

    public static boolean getOptionIgnoreCase(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_IGNORE_CASE, true);
    }

    public static boolean getOptionQuotedCaseSensitive(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_QUOTED_CASE_SENSITIVE, false);
    }

    public static String getOptionQuoteChars(Map<String, String> options) {
        return ServiceDefUtil.getOption(options, OPTION_QUOTE_CHARS, "\"");
    }

    public static boolean getOptionWildCard(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_WILD_CARD, true);
    }

    public static boolean getOptionReplaceTokens(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_REPLACE_TOKENS, true);
    }

    public static char getOptionDelimiterStart(Map<String, String> options) {
        return ServiceDefUtil.getCharOption(options, OPTION_TOKEN_DELIMITER_START, '{');
    }

    public static char getOptionDelimiterEnd(Map<String, String> options) {
        return ServiceDefUtil.getCharOption(options, OPTION_TOKEN_DELIMITER_END, '}');
    }

    public static char getOptionDelimiterEscape(Map<String, String> options) {
        return ServiceDefUtil.getCharOption(options, OPTION_TOKEN_DELIMITER_ESCAPE, '\\');
    }

    public static String getOptionDelimiterPrefix(Map<String, String> options) {
        return ServiceDefUtil.getOption(options, OPTION_TOKEN_DELIMITER_PREFIX, "");
    }

    public static boolean getOptionReplaceReqExpressions(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_REPLACE_REQ_EXPRESSIONS, true);
    }

    protected Map<String, String> getOptions() {
        return this.resourceDef != null ? this.resourceDef.getMatcherOptions() : null;
    }

    protected ResourceMatcherWrapper buildResourceMatchers() {
        ArrayList<ResourceMatcher> resourceMatchers = new ArrayList<ResourceMatcher>();
        boolean needsDynamicEval = false;
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher = this.getMatcher(policyValue);
            if (matcher == null) continue;
            if (matcher.isMatchAny()) {
                resourceMatchers.clear();
                break;
            }
            if (!needsDynamicEval && matcher.getNeedsDynamicEval()) {
                needsDynamicEval = true;
            }
            resourceMatchers.add(matcher);
        }
        Collections.sort(resourceMatchers, new ResourceMatcher.PriorityComparator());
        return CollectionUtils.isNotEmpty(resourceMatchers) ? new ResourceMatcherWrapper(needsDynamicEval, resourceMatchers) : null;
    }

    @Override
    public boolean isCompleteMatch(String resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractResourceMatcher.isCompleteMatch(" + resource + ", " + evalContext + ")");
        }
        boolean ret = false;
        if (CollectionUtils.isEmpty(this.policyValues)) {
            ret = StringUtils.isEmpty((String)resource);
        } else if (this.policyValues.size() == 1) {
            String policyValue = this.policyValues.get(0);
            if (this.isMatchAny) {
                ret = StringUtils.isEmpty((String)resource) || StringUtils.containsOnly((String)resource, (String)WILDCARD_ASTERISK);
            } else {
                boolean bl = ret = this.optIgnoreCase && (!this.optQuotedCaseSensitive || !ResourceMatcher.startsWithAnyChar(resource, this.optQuoteChars)) ? StringUtils.equalsIgnoreCase((String)resource, (String)policyValue) : StringUtils.equals((String)resource, (String)policyValue);
            }
            if (this.policyIsExcludes) {
                boolean bl = ret = !ret;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractResourceMatcher.isCompleteMatch(" + resource + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractResourceMatcher={");
        sb.append("resourceDef={");
        if (this.resourceDef != null) {
            this.resourceDef.toString(sb);
        }
        sb.append("} ");
        sb.append("policyResource={");
        if (this.policyResource != null) {
            this.policyResource.toString(sb);
        }
        sb.append("} ");
        sb.append("optIgnoreCase={").append(this.optIgnoreCase).append("} ");
        sb.append("optQuotedCaseSensitive={").append(this.optQuotedCaseSensitive).append("} ");
        sb.append("optQuoteChars={").append(this.optQuoteChars).append("} ");
        sb.append("optWildCard={").append(this.optWildCard).append("} ");
        sb.append("policyValues={");
        if (this.policyValues != null) {
            for (String string : this.policyValues) {
                sb.append(string).append(",");
            }
        }
        sb.append("} ");
        sb.append("policyIsExcludes={").append(this.policyIsExcludes).append("} ");
        sb.append("isMatchAny={").append(this.isMatchAny).append("} ");
        sb.append("options={");
        if (this.resourceDef != null && this.resourceDef.getMatcherOptions() != null) {
            for (Map.Entry entry : this.resourceDef.getMatcherOptions().entrySet()) {
                sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(';');
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    boolean isAllValuesRequested(Object resource) {
        boolean result = resource == null ? true : (resource instanceof String ? StringUtils.isEmpty((String)((String)resource)) || WILDCARD_ASTERISK.equals(resource) : false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isAllValuesRequested(" + resource + "): " + result);
        }
        return result;
    }

    public boolean applyExcludes(boolean allValuesRequested, boolean resultWithoutExcludes) {
        if (!this.policyIsExcludes) {
            return resultWithoutExcludes;
        }
        if (allValuesRequested && !this.isMatchAny) {
            return resultWithoutExcludes;
        }
        return !resultWithoutExcludes;
    }

    public RangerAccessRequest.ResourceElementMatchType applyExcludes(boolean allValuesRequested, RangerAccessRequest.ResourceElementMatchType resultWithoutExcludes) {
        if (!this.policyIsExcludes) {
            return resultWithoutExcludes;
        }
        if (allValuesRequested && !this.isMatchAny) {
            return resultWithoutExcludes;
        }
        return resultWithoutExcludes == RangerAccessRequest.ResourceElementMatchType.NONE ? RangerAccessRequest.ResourceElementMatchType.SELF : RangerAccessRequest.ResourceElementMatchType.NONE;
    }

    ResourceMatcher getMatcher(String policyValue) {
        AbstractStringResourceMatcher ret;
        int len;
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        int wildcardStartIdx = -1;
        int wildcardEndIdx = -1;
        boolean needWildcardMatch = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c == '?') {
                    needWildcardMatch = true;
                    break;
                }
                if (c != '*') continue;
                if (wildcardEndIdx == -1 || wildcardEndIdx == i - 1) {
                    wildcardEndIdx = i;
                    if (wildcardStartIdx != -1) continue;
                    wildcardStartIdx = i;
                    continue;
                }
                needWildcardMatch = true;
                break;
            }
        }
        if (needWildcardMatch) {
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveWildcardMatcher(policyValue, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveWildcardMatcher(policyValue, this.getOptions())) : new CaseSensitiveWildcardMatcher(policyValue, this.getOptions());
        } else if (wildcardStartIdx == -1) {
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveStringMatcher(policyValue, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveStringMatcher(policyValue, this.getOptions())) : new CaseSensitiveStringMatcher(policyValue, this.getOptions());
        } else if (wildcardStartIdx == 0) {
            String matchStr = policyValue.substring(wildcardEndIdx + 1);
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveEndsWithMatcher(matchStr, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveEndsWithMatcher(matchStr, this.getOptions())) : new CaseSensitiveEndsWithMatcher(matchStr, this.getOptions());
        } else if (wildcardEndIdx != len - 1) {
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveWildcardMatcher(policyValue, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveWildcardMatcher(policyValue, this.getOptions())) : new CaseSensitiveWildcardMatcher(policyValue, this.getOptions());
        } else {
            String matchStr = policyValue.substring(0, wildcardStartIdx);
            AbstractStringResourceMatcher abstractStringResourceMatcher = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveStartsWithMatcher(matchStr, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveStartsWithMatcher(matchStr, this.getOptions())) : (ret = new CaseSensitiveStartsWithMatcher(matchStr, this.getOptions()));
        }
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }
}

