/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.UnsignedLongWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;

public class FlowWriter
extends AbstractDescribedTypeWriter<Flow> {
    private static final ValueWriter<UnsignedLong> DESCRIPTOR_WRITER = UnsignedLongWriter.getWriter((byte)19);
    private static final ValueWriter.Factory<Flow> FACTORY = FlowWriter::new;

    private FlowWriter(ValueWriter.Registry registry, Flow object) {
        super(DESCRIPTOR_WRITER, new Writer(registry, object));
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Flow.class, FACTORY);
    }

    private static class Writer
    extends AbstractListWriter<Flow> {
        private final Flow _value;
        private final int _count;
        private int _field;

        public Writer(ValueWriter.Registry registry, Flow object) {
            super(registry);
            this._value = object;
            this._count = this.calculateCount();
        }

        private int calculateCount() {
            if (this._value.getProperties() != null) {
                return 11;
            }
            if (this._value.getEcho() != null) {
                return 10;
            }
            if (this._value.getDrain() != null) {
                return 9;
            }
            if (this._value.getAvailable() != null) {
                return 8;
            }
            if (this._value.getLinkCredit() != null) {
                return 7;
            }
            if (this._value.getDeliveryCount() != null) {
                return 6;
            }
            if (this._value.getHandle() != null) {
                return 5;
            }
            if (this._value.getOutgoingWindow() != null) {
                return 4;
            }
            if (this._value.getNextOutgoingId() != null) {
                return 3;
            }
            if (this._value.getIncomingWindow() != null) {
                return 2;
            }
            if (this._value.getNextIncomingId() != null) {
                return 1;
            }
            return 0;
        }

        @Override
        protected int getCount() {
            return this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return this._value.getNextIncomingId();
                }
                case 1: {
                    return this._value.getIncomingWindow();
                }
                case 2: {
                    return this._value.getNextOutgoingId();
                }
                case 3: {
                    return this._value.getOutgoingWindow();
                }
                case 4: {
                    return this._value.getHandle();
                }
                case 5: {
                    return this._value.getDeliveryCount();
                }
                case 6: {
                    return this._value.getLinkCredit();
                }
                case 7: {
                    return this._value.getAvailable();
                }
                case 8: {
                    return this._value.getDrain();
                }
                case 9: {
                    return this._value.getEcho();
                }
                case 10: {
                    return this._value.getProperties();
                }
            }
            return null;
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

