/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ContextProvider;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.TaskExecutorProvider;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.store.ConfiguredObjectRecord;

@ManagedObject(creatable=false, category=false)
public interface ConfiguredObject<X extends ConfiguredObject<X>>
extends ContextProvider,
TaskExecutorProvider,
PermissionedObject {
    public static final String OVER_SIZED_ATTRIBUTE_ALTERNATIVE_TEXT = "Value is too long to display";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String DESCRIPTION = "description";
    public static final String DURABLE = "durable";
    public static final String CONTEXT = "context";
    public static final String LIFETIME_POLICY = "lifetimePolicy";
    public static final String LAST_UPDATED_BY = "lastUpdatedBy";
    public static final String LAST_UPDATED_TIME = "lastUpdatedTime";
    public static final String STATE = "state";
    public static final String DESIRED_STATE = "desiredState";
    public static final String CREATED_BY = "createdBy";
    public static final String CREATED_TIME = "createdTime";
    public static final String AWAIT_ATTAINMENT_TIMEOUT = "awaitAttainmentTimeout";
    @ManagedContextDefault(name="awaitAttainmentTimeout")
    public static final int DEFAULT_AWAIT_ATTAINMENT_TIMEOUT = 5000;

    @ManagedAttribute(mandatory=true, immutable=true)
    public UUID getId();

    @Override
    @ManagedAttribute(mandatory=true)
    public String getName();

    @ManagedAttribute
    public String getDescription();

    @ManagedAttribute(immutable=true)
    public String getType();

    @ManagedAttribute
    public Map<String, String> getContext();

    @DerivedAttribute(persist=true)
    public String getLastUpdatedBy();

    @DerivedAttribute(persist=true)
    public Date getLastUpdatedTime();

    @DerivedAttribute(persist=true)
    public String getCreatedBy();

    @DerivedAttribute(persist=true)
    public Date getCreatedTime();

    @ManagedAttribute(defaultValue="ACTIVE")
    public State getDesiredState();

    @DerivedAttribute
    public State getState();

    @DerivedAttribute
    public Date getLastOpenedTime();

    public void addChangeListener(ConfigurationChangeListener var1);

    public boolean removeChangeListener(ConfigurationChangeListener var1);

    public ConfiguredObject<?> getParent();

    @ManagedAttribute(defaultValue="true", immutable=true)
    public boolean isDurable();

    @ManagedAttribute(defaultValue="PERMANENT")
    public LifetimePolicy getLifetimePolicy();

    @ManagedOperation(description="Return the (selected) statistic values", nonModifying=true, changesConfiguredObjectState=false, skipAclCheck=true)
    public Map<String, Object> getStatistics(@Param(name="statistics", defaultValue="[]", description="Optional list of statistic values to retrieve") List<String> var1);

    @ManagedOperation(description="Set context variable with given name to given value. Previous value is returned or null if not set directly on configured object.", changesConfiguredObjectState=true, skipAclCheck=true)
    public String setContextVariable(@Param(name="name", description="Context variable name") String var1, @Param(name="value", description="Context variable value") String var2);

    @ManagedOperation(description="Remove context variable with given name. Variable value is returned or null if not set directly on configured object.", changesConfiguredObjectState=true, skipAclCheck=true)
    public String removeContextVariable(@Param(name="name", description="Context variable name") String var1);

    public Collection<String> getAttributeNames();

    public Object getAttribute(String var1);

    public Map<String, Object> getActualAttributes();

    public Map<String, Object> getStatistics();

    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> var1);

    public <C extends ConfiguredObject> C getChildById(Class<C> var1, UUID var2);

    public <C extends ConfiguredObject> C getChildByName(Class<C> var1, String var2);

    public <C extends ConfiguredObject> C createChild(Class<C> var1, Map<String, Object> var2);

    public <C extends ConfiguredObject> CompletableFuture<C> getAttainedChildById(Class<C> var1, UUID var2);

    public <C extends ConfiguredObject> CompletableFuture<C> getAttainedChildByName(Class<C> var1, String var2);

    public <C extends ConfiguredObject> CompletableFuture<C> createChildAsync(Class<C> var1, Map<String, Object> var2);

    public void setAttributes(Map<String, Object> var1) throws IllegalStateException, AccessControlException, IllegalArgumentException;

    public CompletableFuture<Void> setAttributesAsync(Map<String, Object> var1) throws IllegalStateException, AccessControlException, IllegalArgumentException;

    @Override
    public Class<? extends ConfiguredObject> getCategoryClass();

    public Class<? extends ConfiguredObject> getTypeClass();

    public boolean managesChildStorage();

    public <C extends ConfiguredObject<C>> C findConfiguredObject(Class<C> var1, String var2);

    public ConfiguredObjectRecord asObjectRecord();

    public void open();

    public CompletableFuture<Void> openAsync();

    public void close();

    public CompletableFuture<Void> closeAsync();

    public CompletableFuture<Void> deleteAsync();

    public TaskExecutor getChildExecutor();

    public ConfiguredObjectFactory getObjectFactory();

    public Model getModel();

    public void delete();

    public boolean hasEncrypter();

    public void decryptSecrets();

    public UserPreferences getUserPreferences();

    public void setUserPreferences(UserPreferences var1);

    public void authorise(Operation var1) throws AccessControlException;

    public void authorise(Operation var1, Map<String, Object> var2) throws AccessControlException;

    public void authorise(SecurityToken var1, Operation var2, Map<String, Object> var3) throws AccessControlException;

    public SecurityToken newToken(Subject var1);
}

