/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.configuration.anonymizer;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DefaultRoleAnonymizerType {
    NONE{

        @Override
        public String anonymize(String role) {
            return role;
        }
    }
    ,
    REDACTED{

        @Override
        public String anonymize(String role) {
            return DefaultRoleAnonymizerType.REDACTED_VALUE;
        }
    }
    ,
    SHA256{
        private static final String PREFIX = "SHA-256:";
        private final MessageDigest digest;
        {
            try {
                this.digest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SHA-256 algorithm not found", e);
            }
        }

        @Override
        public String anonymize(String role) {
            byte[] hash = this.digest.digest(role.getBytes());
            return PREFIX + Base64.getEncoder().encodeToString(hash);
        }
    }
    ,
    MD5{
        private static final String PREFIX = "MD5:";
        private final MessageDigest digest;
        {
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("MD5 algorithm not found", e);
            }
        }

        @Override
        public String anonymize(String role) {
            byte[] hash = this.digest.digest(role.getBytes());
            return PREFIX + Base64.getEncoder().encodeToString(hash);
        }
    };

    private static final String REDACTED_VALUE = "[REDACTED]";

    public abstract String anonymize(String var1);
}

