/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.broker.resources.TopicListener;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicResources {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicResources.class);
    private static final String MANAGED_LEDGER_PATH = "/managed-ledgers";
    private final MetadataStoreExtended store;
    private final Map<TopicListener, Pattern> topicListeners;

    public TopicResources(MetadataStoreExtended store) {
        this.store = store;
        this.topicListeners = new ConcurrentHashMap<TopicListener, Pattern>();
        store.registerListener(this::handleNotification);
        store.registerSessionListener(this::handleSessionEvent);
    }

    public CompletableFuture<List<String>> listPersistentTopicsAsync(NamespaceName ns) {
        String path = "/managed-ledgers/" + String.valueOf(ns) + "/persistent";
        return this.store.getChildren(path).thenApply(children -> children.stream().map(c -> TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)ns, (String)Codec.decode((String)c)).toString()).collect(Collectors.toList()));
    }

    public CompletableFuture<List<String>> getExistingPartitions(TopicName topic) {
        return this.getExistingPartitions(topic.getNamespaceObject(), topic.getDomain());
    }

    public CompletableFuture<List<String>> getExistingPartitions(NamespaceName ns, TopicDomain domain) {
        String topicPartitionPath = "/managed-ledgers/" + String.valueOf(ns) + "/" + String.valueOf(domain);
        return this.store.getChildren(topicPartitionPath).thenApply(topics -> topics.stream().map(s -> String.format("%s://%s/%s", domain.value(), ns, Codec.decode((String)s))).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> createPersistentTopicAsync(TopicName topic) {
        String path = "/managed-ledgers/" + topic.getPersistenceNamingEncoding();
        return this.store.put(path, new byte[0], Optional.of(-1L)).thenApply(__ -> null);
    }

    public CompletableFuture<Boolean> persistentTopicExists(TopicName topic) {
        String path = "/managed-ledgers/" + topic.getPersistenceNamingEncoding();
        return this.store.exists(path);
    }

    public CompletableFuture<Void> clearNamespacePersistence(NamespaceName ns) {
        String path = "/managed-ledgers/" + String.valueOf(ns);
        log.info("Clearing namespace persistence for namespace: {}, path {}", (Object)ns, (Object)path);
        return this.store.deleteIfExists(path, Optional.empty());
    }

    public CompletableFuture<Void> clearDomainPersistence(NamespaceName ns) {
        String path = "/managed-ledgers/" + String.valueOf(ns) + "/persistent";
        log.info("Clearing domain persistence for namespace: {}, path {}", (Object)ns, (Object)path);
        return this.store.deleteIfExists(path, Optional.empty());
    }

    public CompletableFuture<Void> clearTenantPersistence(String tenant) {
        String path = "/managed-ledgers/" + tenant;
        log.info("Clearing tenant persistence for tenant: {}, path {}", (Object)tenant, (Object)path);
        return this.store.deleteRecursive(path);
    }

    void handleNotification(Notification notification) {
        if (this.topicListeners.isEmpty()) {
            return;
        }
        if (notification.getPath().startsWith(MANAGED_LEDGER_PATH) && (notification.getType() == NotificationType.Created || notification.getType() == NotificationType.Deleted)) {
            for (Map.Entry<TopicListener, Pattern> entry : this.topicListeners.entrySet()) {
                TopicName topicName;
                Matcher matcher = entry.getValue().matcher(notification.getPath());
                if (!matcher.matches() || SystemTopicNames.isSystemTopic((TopicName)(topicName = TopicName.get((String)matcher.group(2), (NamespaceName)NamespaceName.get((String)matcher.group(1)), (String)Codec.decode((String)matcher.group(3)))))) continue;
                entry.getKey().onTopicEvent(topicName.toString(), notification.getType());
            }
        }
    }

    Pattern namespaceNameToTopicNamePattern(NamespaceName namespaceName) {
        return Pattern.compile("/managed-ledgers/(" + Pattern.quote(namespaceName.toString()) + ")/(" + String.valueOf(TopicDomain.persistent) + ")/([^/]+)");
    }

    public void registerPersistentTopicListener(TopicListener listener) {
        this.topicListeners.put(listener, this.namespaceNameToTopicNamePattern(listener.getNamespaceName()));
    }

    public void deregisterPersistentTopicListener(TopicListener listener) {
        this.topicListeners.remove(listener);
    }

    private void handleSessionEvent(SessionEvent sessionEvent) {
        this.topicListeners.keySet().forEach(listener -> {
            try {
                listener.onSessionEvent(sessionEvent);
            }
            catch (Exception e) {
                log.warn("Failed to handle session event {} for listener {}", new Object[]{sessionEvent, listener, e});
            }
        });
    }

    @Deprecated
    public void registerPersistentTopicListener(NamespaceName namespaceName, BiConsumer<String, NotificationType> listener) {
        this.topicListeners.put(new BiConsumerTopicListener(listener, namespaceName), this.namespaceNameToTopicNamePattern(namespaceName));
    }

    @Deprecated
    public void deregisterPersistentTopicListener(BiConsumer<String, NotificationType> listener) {
        this.topicListeners.remove(new BiConsumerTopicListener(listener, null));
    }

    @Deprecated
    static class BiConsumerTopicListener
    implements TopicListener {
        private final BiConsumer<String, NotificationType> listener;
        private final NamespaceName namespaceName;

        BiConsumerTopicListener(BiConsumer<String, NotificationType> listener, NamespaceName namespaceName) {
            this.listener = listener;
            this.namespaceName = namespaceName;
        }

        @Override
        public NamespaceName getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public void onTopicEvent(String topicName, NotificationType notificationType) {
            this.listener.accept(topicName, notificationType);
        }

        @Override
        public void onSessionEvent(SessionEvent sessionEvent) {
        }

        public String toString() {
            return "BiConsumerTopicListener [listener=" + String.valueOf(this.listener) + ", namespaceName=" + String.valueOf(this.namespaceName) + "]";
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof BiConsumerTopicListener && this.listener.equals(((BiConsumerTopicListener)obj).listener);
        }
    }
}

