/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication.metrics;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.prometheus.client.Counter;

public class AuthenticationMetrics {
    @Deprecated
    private static final Counter authSuccessMetrics = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_authentication_success_total")).help("Pulsar authentication success")).labelNames(new String[]{"provider_name", "auth_method"})).register();
    @Deprecated
    private static final Counter authFailuresMetrics = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_authentication_failures_total")).help("Pulsar authentication failures")).labelNames(new String[]{"provider_name", "auth_method", "reason"})).register();
    public static final String INSTRUMENTATION_SCOPE_NAME = "org.apache.pulsar.authentication";
    public static final String AUTHENTICATION_COUNTER_METRIC_NAME = "pulsar.authentication.operation.count";
    private final LongCounter authenticationCounter;
    public static final AttributeKey<String> PROVIDER_KEY = AttributeKey.stringKey((String)"pulsar.authentication.provider");
    public static final AttributeKey<String> AUTH_METHOD_KEY = AttributeKey.stringKey((String)"pulsar.authentication.method");
    public static final AttributeKey<String> ERROR_CODE_KEY = AttributeKey.stringKey((String)"pulsar.authentication.error");
    public static final AttributeKey<String> AUTH_RESULT_KEY = AttributeKey.stringKey((String)"pulsar.authentication.result");
    private final String providerName;
    private final String authMethod;

    @Deprecated
    public static void authenticateFailure(String providerName, String authMethod, String reason) {
        ((Counter.Child)authFailuresMetrics.labels(new String[]{providerName, authMethod, reason})).inc();
    }

    @Deprecated
    public static void authenticateFailure(String providerName, String authMethod, Enum<?> errorCode) {
        ((Counter.Child)authFailuresMetrics.labels(new String[]{providerName, authMethod, errorCode.name()})).inc();
    }

    public AuthenticationMetrics(OpenTelemetry openTelemetry, String providerName, String authMethod) {
        this.providerName = providerName;
        this.authMethod = authMethod;
        Meter meter = openTelemetry.getMeter(INSTRUMENTATION_SCOPE_NAME);
        this.authenticationCounter = meter.counterBuilder(AUTHENTICATION_COUNTER_METRIC_NAME).setDescription("The number of authentication operations").setUnit("{operation}").build();
    }

    public void recordSuccess() {
        ((Counter.Child)authSuccessMetrics.labels(new String[]{this.providerName, this.authMethod})).inc();
        Attributes attributes = Attributes.of(PROVIDER_KEY, (Object)this.providerName, AUTH_METHOD_KEY, (Object)this.authMethod, AUTH_RESULT_KEY, (Object)AuthenticationResult.SUCCESS.name().toLowerCase());
        this.authenticationCounter.add(1L, attributes);
    }

    public void recordFailure(Enum<?> errorCode) {
        this.recordFailure(this.providerName, this.authMethod, errorCode.name());
    }

    public void recordFailure(String providerName, String authMethod, Enum<?> errorCode) {
        this.recordFailure(providerName, authMethod, errorCode.name());
    }

    public void recordFailure(String providerName, String authMethod, String errorCode) {
        AuthenticationMetrics.authenticateFailure(providerName, authMethod, errorCode);
        Attributes attributes = Attributes.of(PROVIDER_KEY, (Object)providerName, AUTH_METHOD_KEY, (Object)authMethod, AUTH_RESULT_KEY, (Object)AuthenticationResult.FAILURE.name().toLowerCase(), ERROR_CODE_KEY, (Object)errorCode);
        this.authenticationCounter.add(1L, attributes);
    }

    public static enum AuthenticationResult {
        SUCCESS,
        FAILURE;

    }
}

