/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslRoleToken
implements Principal {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaslRoleToken.class);
    public static final SaslRoleToken ANONYMOUS = new SaslRoleToken();
    private static final String ATTR_SEPARATOR = "&";
    private static final String USER_ROLE = "u";
    private static final String EXPIRES = "e";
    private static final String SESSION = "i";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("u", "e", "i"));
    private String userRole;
    private String session;
    private long expires;
    private String token;
    private static final String ILLEGAL_ARG_MSG = " is NULL, empty or contains a '&'";

    private SaslRoleToken() {
        this.userRole = null;
        this.session = null;
        this.expires = -1L;
        this.token = "ANONYMOUS";
        this.generateToken();
    }

    public SaslRoleToken(String userRole, String session) {
        SaslRoleToken.checkForIllegalArgument(session, "session");
        this.userRole = userRole;
        this.session = session;
        this.expires = -1L;
        this.generateToken();
    }

    public SaslRoleToken(String userRole, String session, long expires) {
        SaslRoleToken.checkForIllegalArgument(userRole, "userRole");
        SaslRoleToken.checkForIllegalArgument(session, "session");
        this.userRole = userRole;
        this.session = session;
        this.expires = expires;
        this.generateToken();
    }

    private static void checkForIllegalArgument(String value, String name) {
        if (value == null || value.length() == 0 || value.contains(ATTR_SEPARATOR)) {
            throw new IllegalArgumentException(name + ILLEGAL_ARG_MSG);
        }
    }

    public void setExpires(long expires) {
        if (this != ANONYMOUS) {
            this.expires = expires;
            this.generateToken();
        }
    }

    private void generateToken() {
        StringBuilder sb = new StringBuilder();
        sb.append(USER_ROLE).append("=").append(this.getUserRole()).append(ATTR_SEPARATOR);
        sb.append(SESSION).append("=").append(this.getSession()).append(ATTR_SEPARATOR);
        sb.append(EXPIRES).append("=").append(this.getExpires());
        this.token = sb.toString();
    }

    public String getUserRole() {
        return this.userRole;
    }

    @Override
    public String getName() {
        return this.userRole;
    }

    public String getSession() {
        return this.session;
    }

    public long getExpires() {
        return this.expires;
    }

    public boolean isExpired() {
        return this.getExpires() != -1L && System.currentTimeMillis() > this.getExpires();
    }

    @Override
    public String toString() {
        return this.token;
    }

    public static SaslRoleToken parse(String tokenStr) throws AuthenticationException {
        Map<String, String> map = SaslRoleToken.split(tokenStr);
        if (!map.keySet().equals(ATTRIBUTES)) {
            throw new AuthenticationException("Invalid token string, missing attributes");
        }
        long expires = Long.parseLong(map.get(EXPIRES));
        SaslRoleToken token = new SaslRoleToken(map.get(USER_ROLE), map.get(SESSION));
        token.setExpires(expires);
        return token;
    }

    private static Map<String, String> split(String tokenStr) throws AuthenticationException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(tokenStr, ATTR_SEPARATOR);
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            int separator = part.indexOf(61);
            if (separator == -1) {
                throw new AuthenticationException("Invalid authentication token");
            }
            String key = part.substring(0, separator);
            String value = part.substring(separator + 1);
            map.put(key, value);
        }
        return map;
    }
}

