/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip.timestamps;

import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.timestamps.Java8TimestampStrategy;
import org.zeroturnaround.zip.timestamps.PreJava8TimestampStrategy;
import org.zeroturnaround.zip.timestamps.TimestampStrategy;

public class TimestampStrategyFactory {
    public static boolean HAS_ZIP_ENTRY_FILE_TIME_METHODS = TimestampStrategyFactory.hasZipEntryFileTimeMethods();
    private static TimestampStrategy INSTANCE = TimestampStrategyFactory.getStrategy();

    private TimestampStrategyFactory() {
    }

    private static boolean hasZipEntryFileTimeMethods() {
        try {
            ZipEntry.class.getDeclaredMethod("getCreationTime", new Class[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static TimestampStrategy getStrategy() {
        if (HAS_ZIP_ENTRY_FILE_TIME_METHODS) {
            return new Java8TimestampStrategy();
        }
        return new PreJava8TimestampStrategy();
    }

    public static TimestampStrategy getInstance() {
        return INSTANCE;
    }
}

