/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.strategy;

import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateChannel;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateChannelImpl;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.models.Split;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitDecision;
import org.apache.pulsar.broker.loadbalance.extensions.strategy.NamespaceBundleSplitStrategy;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNamespaceBundleSplitStrategyImpl
implements NamespaceBundleSplitStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNamespaceBundleSplitStrategyImpl.class);
    private static final String CANNOT_CONTINUE_SPLIT_MSG = "Can't continue the split cycle.";
    private static final String CANNOT_SPLIT_BUNDLE_MSG = "Can't split broker:%s.";
    private final Set<SplitDecision> decisionCache = new HashSet<SplitDecision>();
    private final Map<String, Integer> namespaceBundleCount = new HashMap<String, Integer>();
    private final Map<String, Integer> splitConditionHitCounts = new HashMap<String, Integer>();
    private final Map<String, String> splittingBundles = new HashMap<String, String>();
    private final SplitCounter counter;

    public DefaultNamespaceBundleSplitStrategyImpl(SplitCounter counter) {
        this.counter = counter;
    }

    @Override
    public Set<SplitDecision> findBundlesToSplit(LoadManagerContext context, PulsarService pulsar) {
        this.decisionCache.clear();
        this.namespaceBundleCount.clear();
        this.splittingBundles.clear();
        ServiceConfiguration conf = pulsar.getConfiguration();
        int maxBundleCount = conf.getLoadBalancerNamespaceMaximumBundles();
        long maxBundleTopics = conf.getLoadBalancerNamespaceBundleMaxTopics();
        long maxBundleSessions = conf.getLoadBalancerNamespaceBundleMaxSessions();
        long maxBundleMsgRate = conf.getLoadBalancerNamespaceBundleMaxMsgRate();
        long maxBundleBandwidth = conf.getLoadBalancerNamespaceBundleMaxBandwidthMbytes() * 0x100000;
        long maxSplitCount = conf.getLoadBalancerMaxNumberOfBundlesToSplitPerCycle();
        long splitConditionHitCountThreshold = conf.getLoadBalancerNamespaceBundleSplitConditionHitCountThreshold();
        boolean debug = log.isDebugEnabled() || conf.isLoadBalancerDebugModeEnabled();
        ServiceUnitStateChannel channel = ServiceUnitStateChannelImpl.get(pulsar);
        for (Map.Entry<String, ServiceUnitStateData> etr : channel.getOwnershipEntrySet()) {
            ServiceUnitStateData eData = etr.getValue();
            if (eData.state() != ServiceUnitState.Splitting) continue;
            String bundle = etr.getKey();
            String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(bundle);
            this.splittingBundles.put(bundle, bundleRange);
        }
        Map<String, NamespaceBundleStats> bundleStatsMap = pulsar.getBrokerService().getBundleStats();
        NamespaceBundleFactory namespaceBundleFactory = pulsar.getNamespaceService().getNamespaceBundleFactory();
        this.splitConditionHitCounts.keySet().retainAll(bundleStatsMap.keySet());
        for (Map.Entry<String, NamespaceBundleStats> entry : bundleStatsMap.entrySet()) {
            String namespace;
            SplitDecision.Reason reason;
            double totalMessageThroughput;
            double totalMessageRate;
            String bundleRange;
            String namespaceName;
            NamespaceBundleStats stats;
            String bundle;
            block26: {
                bundle = entry.getKey();
                stats = entry.getValue();
                if (stats.topics < 2L) {
                    if (!debug) continue;
                    log.info(String.format("Can't split broker:%s. The topic count is less than 2.", bundle));
                    continue;
                }
                if (!channel.isOwner(bundle)) {
                    if (!debug) continue;
                    log.warn(String.format("Can't split broker:%s. This broker is not the owner.", bundle));
                    continue;
                }
                namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(bundle);
                if (!namespaceBundleFactory.canSplitBundle(namespaceBundleFactory.getBundle(namespaceName, bundleRange = LoadManagerShared.getBundleRangeFromBundleName(bundle)))) {
                    if (debug) {
                        log.info(String.format("Can't split broker:%s. Invalid bundle range:%s.", bundle, bundleRange));
                    }
                    this.counter.update(SplitDecision.Label.Failure, SplitDecision.Reason.Unknown);
                    continue;
                }
                totalMessageRate = stats.msgRateIn + stats.msgRateOut;
                totalMessageThroughput = stats.msgThroughputIn + stats.msgThroughputOut;
                int totalSessionCount = stats.consumerCount + stats.producerCount;
                reason = SplitDecision.Reason.Unknown;
                if (stats.topics > maxBundleTopics) {
                    reason = SplitDecision.Reason.Topics;
                } else if (maxBundleSessions > 0L && (long)totalSessionCount > maxBundleSessions) {
                    reason = SplitDecision.Reason.Sessions;
                } else if (totalMessageRate > (double)maxBundleMsgRate) {
                    reason = SplitDecision.Reason.MsgRate;
                } else if (totalMessageThroughput > (double)maxBundleBandwidth) {
                    reason = SplitDecision.Reason.Bandwidth;
                }
                if (reason != SplitDecision.Reason.Unknown) {
                    this.splitConditionHitCounts.put(bundle, this.splitConditionHitCounts.getOrDefault(bundle, 0) + 1);
                } else {
                    this.splitConditionHitCounts.remove(bundle);
                }
                if ((long)this.splitConditionHitCounts.getOrDefault(bundle, 0).intValue() <= splitConditionHitCountThreshold) {
                    if (!debug) continue;
                    log.info(String.format("Can't split broker:%s. Split condition hit count: %d is less than or equal to threshold: %d. Topics: %d/%d, Sessions: (%d+%d)/%d, Message Rate: %.2f/%d (msgs/s), Message Throughput: %.2f/%d (MB/s).", bundle, this.splitConditionHitCounts.getOrDefault(bundle, 0), splitConditionHitCountThreshold, stats.topics, maxBundleTopics, stats.producerCount, stats.consumerCount, maxBundleSessions, totalMessageRate, maxBundleMsgRate, totalMessageThroughput / 1048576.0, maxBundleBandwidth / 0x100000L));
                    continue;
                }
                namespace = LoadManagerShared.getNamespaceNameFromBundleName(bundle);
                try {
                    int bundleCount = pulsar.getNamespaceService().getBundleCount(NamespaceName.get((String)namespace));
                    if (bundleCount + this.namespaceBundleCount.getOrDefault(namespace, 0) >= maxBundleCount) {
                        if (!debug) continue;
                        log.info(String.format("Can't split broker:%s. Namespace:%s has too many bundles:%d", bundle, namespace, bundleCount));
                    }
                    break block26;
                }
                catch (Exception e) {
                    this.counter.update(SplitDecision.Label.Failure, SplitDecision.Reason.Unknown);
                    log.warn("Failed to get bundle count in namespace:{}", (Object)namespace, (Object)e);
                }
                continue;
            }
            String[] ranges = bundleRange.split("_");
            boolean foundSplittingBundle = false;
            for (Map.Entry<String, String> etr : this.splittingBundles.entrySet()) {
                String splittingBundleRange;
                String splittingBundle = etr.getKey();
                if (!splittingBundle.startsWith(namespace) || !(splittingBundleRange = etr.getValue()).startsWith(ranges[0]) && !splittingBundleRange.endsWith(ranges[1])) continue;
                if (debug) {
                    log.info(String.format("Can't split broker:%s. (parent) bundle:%s is in Splitting state.", bundle, splittingBundle));
                }
                foundSplittingBundle = true;
                break;
            }
            if (foundSplittingBundle) continue;
            if (debug) {
                log.info(String.format("Splitting bundle: %s. Topics: %d/%d, Sessions: (%d+%d)/%d, Message Rate: %.2f/%d (msgs/s), Message Throughput: %.2f/%d (MB/s)", bundle, stats.topics, maxBundleTopics, stats.producerCount, stats.consumerCount, maxBundleSessions, totalMessageRate, maxBundleMsgRate, totalMessageThroughput / 1048576.0, maxBundleBandwidth / 0x100000L));
            }
            SplitDecision decision = new SplitDecision();
            NamespaceService namespaceService = pulsar.getNamespaceService();
            NamespaceBundle namespaceBundle = namespaceService.getNamespaceBundleFactory().getBundle(namespaceName, bundleRange);
            NamespaceBundleSplitAlgorithm algorithm = namespaceService.getNamespaceBundleSplitAlgorithmByName(conf.getDefaultNamespaceBundleSplitAlgorithm());
            List<Long> splitBoundary = null;
            try {
                splitBoundary = namespaceService.getSplitBoundary(namespaceBundle, null, algorithm).get(conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                this.counter.update(SplitDecision.Label.Failure, SplitDecision.Reason.Unknown);
                log.warn(String.format("Can't split broker:%s. Failed to get split boundaries.", bundle), e);
                continue;
            }
            if (splitBoundary == null) {
                this.counter.update(SplitDecision.Label.Failure, SplitDecision.Reason.Unknown);
                log.warn(String.format("Can't split broker:%s. The split boundaries is null.", bundle));
                continue;
            }
            if (splitBoundary.size() != 1) {
                this.counter.update(SplitDecision.Label.Failure, SplitDecision.Reason.Unknown);
                log.warn(String.format("Can't split broker:%s. The size of split boundaries is not 1. splitBoundary:%s", bundle, splitBoundary));
                continue;
            }
            Range<Long> parentRange = namespaceBundle.getKeyRange();
            NamespaceBundle leftChildBundle = namespaceBundleFactory.getBundle(namespaceBundle.getNamespaceObject(), NamespaceBundleFactory.getRange((Long)parentRange.lowerEndpoint(), splitBoundary.get(0)));
            NamespaceBundle rightChildBundle = namespaceBundleFactory.getBundle(namespaceBundle.getNamespaceObject(), NamespaceBundleFactory.getRange(splitBoundary.get(0), (Long)parentRange.upperEndpoint()));
            Map<String, Optional<String>> splitServiceUnitToDestBroker = Map.of(leftChildBundle.getBundleRange(), Optional.empty(), rightChildBundle.getBundleRange(), Optional.empty());
            decision.setSplit(new Split(bundle, context.brokerRegistry().getBrokerId(), splitServiceUnitToDestBroker));
            decision.succeed(reason);
            this.decisionCache.add(decision);
            int bundleNum = this.namespaceBundleCount.getOrDefault(namespace, 0);
            this.namespaceBundleCount.put(namespace, bundleNum + 1);
            this.splitConditionHitCounts.remove(bundle);
            namespaceBundleFactory.invalidateBundleCache(NamespaceName.get((String)namespaceName));
            if ((long)this.decisionCache.size() != maxSplitCount) continue;
            if (!debug) break;
            log.info("Can't continue the split cycle.Too many bundles split in this cycle {} / {}.", (Object)this.decisionCache.size(), (Object)maxSplitCount);
            break;
        }
        return this.decisionCache;
    }
}

