/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class PulsarStandaloneStarter
extends PulsarStandalone {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneStarter.class);
    private static final String PULSAR_CONFIG_FILE = "pulsar.config.file";
    @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
    private boolean generateDocs = false;
    private Thread shutdownThread;
    private boolean testMode;

    public PulsarStandaloneStarter(String[] args) throws Exception {
        CommandLine commander = new CommandLine((Object)this);
        try {
            commander.parseArgs(args);
            if (this.isHelp()) {
                commander.usage(commander.getOut());
                this.exit(0);
            }
            if (Strings.isNullOrEmpty((String)this.getConfigFile())) {
                String configFile = System.getProperty(PULSAR_CONFIG_FILE);
                if (Strings.isNullOrEmpty((String)configFile)) {
                    throw new IllegalArgumentException("Config file not specified. Please use -c, --config-file or -Dpulsar.config.file to specify the config file.");
                }
                this.setConfigFile(configFile);
            }
            if (this.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("standalone", (Object)this);
                cmd.run(null);
                this.exit(0);
            }
            if (this.isNoBroker() && this.isOnlyBroker()) {
                log.error("Only one option is allowed between '--no-broker' and '--only-broker'");
                commander.usage(commander.getOut());
                return;
            }
        }
        catch (Exception e) {
            commander.usage(commander.getOut());
            log.error(e.getMessage());
            this.exit(1);
        }
        try (FileInputStream inputStream = new FileInputStream(this.getConfigFile());){
            this.config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)inputStream, ServiceConfiguration.class);
        }
        if (this.getAdvertisedAddress() != null) {
            this.config.setAdvertisedAddress(this.getAdvertisedAddress());
        } else if (StringUtils.isBlank((CharSequence)this.config.getAdvertisedAddress()) && StringUtils.isBlank((CharSequence)this.config.getAdvertisedListeners())) {
            this.config.setAdvertisedAddress("localhost");
        }
        if (!PulsarStandaloneStarter.argsContains(args, "--zookeeper-port") && StringUtils.isNotBlank((CharSequence)this.config.getMetadataStoreUrl())) {
            String[] metadataStoreUrl = this.config.getMetadataStoreUrl().split(",")[0].split(":");
            if (metadataStoreUrl.length == 2) {
                this.setZkPort(Integer.parseInt(metadataStoreUrl[1]));
            } else if (metadataStoreUrl.length == 3) {
                String zkPort = metadataStoreUrl[2];
                if (zkPort.contains("/")) {
                    this.setZkPort(Integer.parseInt(zkPort.substring(0, zkPort.lastIndexOf("/"))));
                } else {
                    this.setZkPort(Integer.parseInt(zkPort));
                }
            }
        }
    }

    @Override
    public synchronized void start() throws Exception {
        this.registerShutdownHook();
        super.start();
    }

    protected void registerShutdownHook() {
        if (this.shutdownThread != null) {
            throw new IllegalStateException("Shutdown hook already registered");
        }
        this.shutdownThread = new Thread(() -> {
            try {
                this.doClose(false);
            }
            catch (Exception e) {
                log.error("Shutdown failed: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                if (!this.testMode) {
                    LogManager.shutdown();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    @VisibleForTesting
    void runShutdownHook() {
        if (!this.testMode) {
            throw new IllegalStateException("Not in test mode");
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        this.shutdownThread.run();
        this.shutdownThread = null;
    }

    @Override
    public void close() {
        this.doClose(true);
    }

    private synchronized void doClose(boolean removeShutdownHook) {
        super.close();
        if (this.shutdownThread != null && removeShutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
    }

    protected void exit(int status) {
        System.exit(status);
    }

    private static boolean argsContains(String[] args, String arg) {
        return Arrays.asList(args).contains(arg);
    }

    public static void main(String[] args) throws Exception {
        PulsarStandaloneStarter standalone = new PulsarStandaloneStarter(args);
        try {
            standalone.start();
        }
        catch (Throwable th) {
            log.error("Failed to start pulsar service.", th);
            LogManager.shutdown();
            Runtime.getRuntime().exit(1);
        }
    }

    @Generated
    void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }
}

