/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.raw.MessageParser;
import org.apache.pulsar.common.api.raw.RawMessage;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.StringInterner;
import org.apache.pulsar.proxy.server.ProxyService;
import org.apache.pulsar.proxy.stats.TopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserProxyHandler
extends ChannelInboundHandlerAdapter {
    protected static final String FRONTEND_CONN = "frontendconn";
    protected static final String BACKEND_CONN = "backendconn";
    private final String connType;
    private final int maxMessageSize;
    private final ChannelId peerChannelId;
    private final Context context;
    private final ProxyService service;
    private final BaseCommand cmd = new BaseCommand();
    private static final Logger log = LoggerFactory.getLogger(ParserProxyHandler.class);

    public ParserProxyHandler(Context context, ProxyService service, String type, int maxMessageSize, ChannelId peerChannelId) {
        this.context = context;
        this.service = service;
        this.connType = type;
        this.maxMessageSize = maxMessageSize;
        this.peerChannelId = peerChannelId;
    }

    public static Context createContext() {
        return new Context();
    }

    private void logging(Channel conn, BaseCommand.Type cmdtype, String info, List<RawMessage> messages) {
        if (messages != null) {
            StringBuilder infoBuilder = new StringBuilder(info);
            for (RawMessage message : messages) {
                infoBuilder.append("[").append(System.currentTimeMillis() - message.getPublishTime()).append("] ").append(new String(ByteBufUtil.getBytes((ByteBuf)message.getData()), StandardCharsets.UTF_8));
            }
            info = infoBuilder.toString();
        }
        switch (this.connType) {
            case "frontendconn": {
                log.info("frontendconn:{} cmd:{} msg:{}", new Object[]{"[" + String.valueOf(conn.remoteAddress()) + String.valueOf(conn.localAddress()) + "]", cmdtype, info});
                break;
            }
            case "backendconn": {
                log.info("backendconn:{} cmd:{} msg:{}", new Object[]{"[" + String.valueOf(conn.localAddress()) + String.valueOf(conn.remoteAddress()) + "]", cmdtype, info});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ArrayList<RawMessage> messages = new ArrayList<RawMessage>();
        ByteBuf buffer = (ByteBuf)msg;
        try {
            buffer.markReaderIndex();
            buffer.markWriterIndex();
            int cmdSize = (int)buffer.readUnsignedInt();
            this.cmd.parseFrom(buffer, cmdSize);
            switch (this.cmd.getType()) {
                case PRODUCER: {
                    String topicName = StringInterner.intern((String)this.cmd.getProducer().getTopic());
                    this.context.producerIdToTopicName.put(this.cmd.getProducer().getProducerId(), topicName);
                    String producerName = "";
                    if (this.cmd.getProducer().hasProducerName()) {
                        producerName = this.cmd.getProducer().getProducerName();
                    }
                    this.logging(ctx.channel(), this.cmd.getType(), "{producer:" + producerName + ",topic:" + topicName + "}", null);
                    break;
                }
                case CLOSE_PRODUCER: {
                    this.context.producerIdToTopicName.remove(this.cmd.getCloseProducer().getProducerId());
                    this.logging(ctx.channel(), this.cmd.getType(), "", null);
                    break;
                }
                case SEND: {
                    if (this.service.getProxyLogLevel() != 2) {
                        this.logging(ctx.channel(), this.cmd.getType(), "", null);
                        break;
                    }
                    long producerId = this.cmd.getSend().getProducerId();
                    String topicForProducer = this.context.producerIdToTopicName.get(producerId);
                    if (topicForProducer != null) {
                        String topicName = TopicName.toFullTopicName((String)topicForProducer);
                        MutableLong msgBytes = new MutableLong(0L);
                        MessageParser.parseMessage((String)topicName, (long)-1L, (long)-1L, (ByteBuf)buffer, message -> {
                            messages.add(message);
                            msgBytes.add((long)message.getData().readableBytes());
                        }, (int)this.maxMessageSize);
                        TopicStats topicStats = this.service.getTopicStats().computeIfAbsent(topicName, topic -> new TopicStats());
                        topicStats.getMsgInRate().recordMultipleEvents((long)messages.size(), msgBytes.longValue());
                        this.logging(ctx.channel(), this.cmd.getType(), "", messages);
                        break;
                    }
                    this.logging(ctx.channel(), this.cmd.getType(), "Cannot find topic name for producerId " + producerId, null);
                    break;
                }
                case SUBSCRIBE: {
                    String topicName = StringInterner.intern((String)this.cmd.getSubscribe().getTopic());
                    this.context.consumerIdToTopicName.put(this.cmd.getSubscribe().getConsumerId(), topicName);
                    this.logging(ctx.channel(), this.cmd.getType(), "{consumer:" + this.cmd.getSubscribe().getConsumerName() + ",topic:" + topicName + "}", null);
                    break;
                }
                case CLOSE_CONSUMER: {
                    this.context.consumerIdToTopicName.remove(this.cmd.getCloseConsumer().getConsumerId());
                    this.logging(ctx.channel(), this.cmd.getType(), "", null);
                    break;
                }
                case UNSUBSCRIBE: {
                    this.context.consumerIdToTopicName.remove(this.cmd.getUnsubscribe().getConsumerId());
                    this.logging(ctx.channel(), this.cmd.getType(), "", null);
                    break;
                }
                case MESSAGE: {
                    if (this.service.getProxyLogLevel() != 2) {
                        this.logging(ctx.channel(), this.cmd.getType(), "", null);
                        break;
                    }
                    long consumerId = this.cmd.getMessage().getConsumerId();
                    String topicForConsumer = this.context.consumerIdToTopicName.get(consumerId);
                    if (topicForConsumer != null) {
                        String topicName = TopicName.toFullTopicName((String)topicForConsumer);
                        MutableLong msgBytes = new MutableLong(0L);
                        MessageParser.parseMessage((String)topicName, (long)-1L, (long)-1L, (ByteBuf)buffer, message -> {
                            messages.add(message);
                            msgBytes.add((long)message.getData().readableBytes());
                        }, (int)this.maxMessageSize);
                        TopicStats topicStats = this.service.getTopicStats().computeIfAbsent(topicName.toString(), topic -> new TopicStats());
                        topicStats.getMsgOutRate().recordMultipleEvents((long)messages.size(), msgBytes.longValue());
                        this.logging(ctx.channel(), this.cmd.getType(), "", messages);
                        break;
                    }
                    this.logging(ctx.channel(), this.cmd.getType(), "Cannot find topic name for consumerId " + consumerId, null);
                    break;
                }
                default: {
                    this.logging(ctx.channel(), this.cmd.getType(), "", null);
                }
            }
        }
        catch (Exception e) {
            try {
                log.error("channelRead error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                buffer.resetReaderIndex();
                buffer.resetWriterIndex();
                ByteBuf totalSizeBuf = Unpooled.buffer((int)4);
                totalSizeBuf.writeInt(buffer.readableBytes());
                CompositeByteBuf compBuf = Unpooled.compositeBuffer();
                compBuf.addComponents(new ByteBuf[]{totalSizeBuf, buffer});
                compBuf.writerIndex(totalSizeBuf.capacity() + buffer.capacity());
                messages.forEach(RawMessage::release);
                ctx.fireChannelRead((Object)compBuf);
                throw throwable;
            }
            buffer.resetReaderIndex();
            buffer.resetWriterIndex();
            ByteBuf totalSizeBuf = Unpooled.buffer((int)4);
            totalSizeBuf.writeInt(buffer.readableBytes());
            CompositeByteBuf compBuf = Unpooled.compositeBuffer();
            compBuf.addComponents(new ByteBuf[]{totalSizeBuf, buffer});
            compBuf.writerIndex(totalSizeBuf.capacity() + buffer.capacity());
            messages.forEach(RawMessage::release);
            ctx.fireChannelRead((Object)compBuf);
        }
        buffer.resetReaderIndex();
        buffer.resetWriterIndex();
        ByteBuf totalSizeBuf = Unpooled.buffer((int)4);
        totalSizeBuf.writeInt(buffer.readableBytes());
        CompositeByteBuf compBuf = Unpooled.compositeBuffer();
        compBuf.addComponents(new ByteBuf[]{totalSizeBuf, buffer});
        compBuf.writerIndex(totalSizeBuf.capacity() + buffer.capacity());
        messages.forEach(RawMessage::release);
        ctx.fireChannelRead((Object)compBuf);
    }

    @Generated
    public Context getContext() {
        return this.context;
    }

    public static class Context {
        private final Map<Long, String> producerIdToTopicName = new ConcurrentHashMap<Long, String>();
        private final Map<Long, String> consumerIdToTopicName = new ConcurrentHashMap<Long, String>();

        private Context() {
        }

        @Generated
        public Map<Long, String> getProducerIdToTopicName() {
            return this.producerIdToTopicName;
        }

        @Generated
        public Map<Long, String> getConsumerIdToTopicName() {
            return this.consumerIdToTopicName;
        }
    }
}

