/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.cli.AbstractCmd;
import org.apache.pulsar.internal.CommandDescriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Generate documentation automatically."})
public class CmdGenerateDocumentation
extends AbstractCmd {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocumentation.class);
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec pulsarClientCommandSpec;
    @CommandLine.Option(names={"-n", "--command-names"}, description={"List of command names"})
    private List<String> commandNames = new ArrayList<String>();

    @Override
    public int run() throws PulsarClientException {
        if (this.commandNames == null || this.commandNames.isEmpty()) {
            this.pulsarClientCommandSpec.parent().subcommands().forEach((k, v) -> {
                if (k.equals("generate_documentation")) {
                    return;
                }
                this.generateDocument((String)k, (CommandLine)v);
            });
        } else {
            this.commandNames.forEach(module -> {
                CommandLine commandLine = (CommandLine)this.pulsarClientCommandSpec.parent().subcommands().get(module);
                if (commandLine == null) {
                    return;
                }
                if (commandLine.getCommandName().equals("generate_documentation")) {
                    return;
                }
                this.generateDocument((String)module, commandLine);
            });
        }
        return 0;
    }

    protected String generateDocument(String module, CommandLine parentCmd) {
        StringBuilder sb = new StringBuilder();
        sb.append("## ").append(module).append("\n\n");
        sb.append(CommandDescriptionUtil.getCommandDescription(parentCmd)).append("\n");
        sb.append("\n\n```shell\n").append("$ pulsar-client ").append(module).append(" [options]").append("\n```");
        sb.append("\n\n");
        sb.append("|Flag|Description|Default|\n");
        sb.append("|---|---|---|\n");
        List options = parentCmd.getCommandSpec().args();
        options.forEach(ele -> {
            if (ele.hidden() || !(ele instanceof CommandLine.Model.OptionSpec)) {
                return;
            }
            String argDescription = CommandDescriptionUtil.getArgDescription(ele);
            String descriptions = argDescription.replace("\n", " ");
            sb.append("| `").append(Arrays.toString(((CommandLine.Model.OptionSpec)ele).names())).append("` | ").append(descriptions).append("|").append(ele.defaultValue()).append("|\n");
            sb.append("|\n");
        });
        System.out.println(sb.toString());
        return sb.toString();
    }

    @Generated
    public CommandLine.Model.CommandSpec getPulsarClientCommandSpec() {
        return this.pulsarClientCommandSpec;
    }

    @Generated
    public List<String> getCommandNames() {
        return this.commandNames;
    }
}

