/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class TopicTransactionBufferState {
    private static final AtomicReferenceFieldUpdater<TopicTransactionBufferState, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TopicTransactionBufferState.class, State.class, "state");
    private volatile State state = null;

    public TopicTransactionBufferState(State state) {
        STATE_UPDATER.set(this, state);
    }

    protected boolean changeToReadyState() {
        return STATE_UPDATER.compareAndSet(this, State.Initializing, State.Ready);
    }

    protected boolean changeToNoSnapshotState() {
        return STATE_UPDATER.compareAndSet(this, State.Initializing, State.NoSnapshot);
    }

    protected boolean changeToInitializingState() {
        return STATE_UPDATER.compareAndSet(this, State.None, State.Initializing);
    }

    protected boolean changeToReadyStateFromNoSnapshot() {
        return STATE_UPDATER.compareAndSet(this, State.FirstSnapshotting, State.Ready);
    }

    protected boolean changeToFirstSnapshotting() {
        return STATE_UPDATER.compareAndSet(this, State.NoSnapshot, State.FirstSnapshotting);
    }

    protected void changeToCloseState() {
        STATE_UPDATER.set(this, State.Close);
    }

    protected void changeToClosedAndClearedState() {
        STATE_UPDATER.compareAndSet(this, State.Close, State.ClosedAndCleared);
    }

    public boolean checkIfInitializing() {
        return STATE_UPDATER.get(this) == State.Initializing;
    }

    public boolean checkIfFirstSnapshotting() {
        return STATE_UPDATER.get(this) == State.FirstSnapshotting;
    }

    public boolean checkIfReady() {
        return STATE_UPDATER.get(this) == State.Ready;
    }

    public boolean checkIfNoSnapshot() {
        return STATE_UPDATER.get(this) == State.NoSnapshot;
    }

    public boolean checkIfClosed() {
        return STATE_UPDATER.get(this) == State.Close || STATE_UPDATER.get(this) == State.ClosedAndCleared;
    }

    public boolean checkIfClosedAndCleared() {
        return STATE_UPDATER.get(this) == State.ClosedAndCleared;
    }

    public State getState() {
        return STATE_UPDATER.get(this);
    }

    public static enum State {
        None,
        Initializing,
        Ready,
        Close,
        ClosedAndCleared,
        NoSnapshot,
        FirstSnapshotting;

    }
}

