/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.PersistentTopicAttributes;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TopicAttributes;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.service.persistent.PersistentTopicMetrics;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.stats.MetricsUtil;
import org.apache.pulsar.compaction.CompactedTopicContext;
import org.apache.pulsar.compaction.Compactor;

public class OpenTelemetryTopicStats
implements AutoCloseable {
    public static final String SUBSCRIPTION_COUNTER = "pulsar.broker.topic.subscription.count";
    private final ObservableLongMeasurement subscriptionCounter;
    public static final String PRODUCER_COUNTER = "pulsar.broker.topic.producer.count";
    private final ObservableLongMeasurement producerCounter;
    public static final String CONSUMER_COUNTER = "pulsar.broker.topic.consumer.count";
    private final ObservableLongMeasurement consumerCounter;
    public static final String MESSAGE_IN_COUNTER = "pulsar.broker.topic.message.incoming.count";
    private final ObservableLongMeasurement messageInCounter;
    public static final String MESSAGE_OUT_COUNTER = "pulsar.broker.topic.message.outgoing.count";
    private final ObservableLongMeasurement messageOutCounter;
    public static final String BYTES_IN_COUNTER = "pulsar.broker.topic.message.incoming.size";
    private final ObservableLongMeasurement bytesInCounter;
    public static final String BYTES_OUT_COUNTER = "pulsar.broker.topic.message.outgoing.size";
    private final ObservableLongMeasurement bytesOutCounter;
    public static final String PUBLISH_RATE_LIMIT_HIT_COUNTER = "pulsar.broker.topic.publish.rate.limit.count";
    private final ObservableLongMeasurement publishRateLimitHitCounter;
    public static final String STORAGE_COUNTER = "pulsar.broker.topic.storage.size";
    private final ObservableLongMeasurement storageCounter;
    public static final String STORAGE_LOGICAL_COUNTER = "pulsar.broker.topic.storage.logical.size";
    private final ObservableLongMeasurement storageLogicalCounter;
    public static final String STORAGE_BACKLOG_COUNTER = "pulsar.broker.topic.storage.backlog.size";
    private final ObservableLongMeasurement storageBacklogCounter;
    public static final String STORAGE_OFFLOADED_COUNTER = "pulsar.broker.topic.storage.offloaded.size";
    private final ObservableLongMeasurement storageOffloadedCounter;
    public static final String BACKLOG_QUOTA_LIMIT_SIZE = "pulsar.broker.topic.storage.backlog.quota.limit.size";
    private final ObservableLongMeasurement backlogQuotaLimitSize;
    public static final String BACKLOG_QUOTA_LIMIT_TIME = "pulsar.broker.topic.storage.backlog.quota.limit.time";
    private final ObservableLongMeasurement backlogQuotaLimitTime;
    public static final String BACKLOG_EVICTION_COUNTER = "pulsar.broker.topic.storage.backlog.quota.eviction.count";
    private final ObservableLongMeasurement backlogEvictionCounter;
    public static final String BACKLOG_QUOTA_AGE = "pulsar.broker.topic.storage.backlog.age";
    private final ObservableLongMeasurement backlogQuotaAge;
    public static final String STORAGE_OUT_COUNTER = "pulsar.broker.topic.storage.entry.outgoing.count";
    private final ObservableLongMeasurement storageOutCounter;
    public static final String STORAGE_IN_COUNTER = "pulsar.broker.topic.storage.entry.incoming.count";
    private final ObservableLongMeasurement storageInCounter;
    public static final String COMPACTION_REMOVED_COUNTER = "pulsar.broker.topic.compaction.removed.message.count";
    private final ObservableLongMeasurement compactionRemovedCounter;
    public static final String COMPACTION_OPERATION_COUNTER = "pulsar.broker.topic.compaction.operation.count";
    private final ObservableLongMeasurement compactionOperationCounter;
    public static final String COMPACTION_DURATION_SECONDS = "pulsar.broker.topic.compaction.duration";
    private final ObservableDoubleMeasurement compactionDurationSeconds;
    public static final String COMPACTION_BYTES_IN_COUNTER = "pulsar.broker.topic.compaction.incoming.size";
    private final ObservableLongMeasurement compactionBytesInCounter;
    public static final String COMPACTION_BYTES_OUT_COUNTER = "pulsar.broker.topic.compaction.outgoing.size";
    private final ObservableLongMeasurement compactionBytesOutCounter;
    public static final String COMPACTION_ENTRIES_COUNTER = "pulsar.broker.topic.compaction.compacted.entry.count";
    private final ObservableLongMeasurement compactionEntriesCounter;
    public static final String COMPACTION_BYTES_COUNTER = "pulsar.broker.topic.compaction.compacted.entry.size";
    private final ObservableLongMeasurement compactionBytesCounter;
    public static final String TRANSACTION_COUNTER = "pulsar.broker.topic.transaction.count";
    private final ObservableLongMeasurement transactionCounter;
    public static final String TRANSACTION_BUFFER_CLIENT_OPERATION_COUNTER = "pulsar.broker.topic.transaction.buffer.client.operation.count";
    private final ObservableLongMeasurement transactionBufferClientOperationCounter;
    public static final String DELAYED_SUBSCRIPTION_COUNTER = "pulsar.broker.topic.subscription.delayed.entry.count";
    private final ObservableLongMeasurement delayedSubscriptionCounter;
    private final BatchCallback batchCallback;
    private final PulsarService pulsar;

    public OpenTelemetryTopicStats(PulsarService pulsar) {
        this.pulsar = pulsar;
        Meter meter = pulsar.getOpenTelemetry().getMeter();
        this.subscriptionCounter = meter.upDownCounterBuilder(SUBSCRIPTION_COUNTER).setUnit("{subscription}").setDescription("The number of Pulsar subscriptions of the topic served by this broker.").buildObserver();
        this.producerCounter = meter.upDownCounterBuilder(PRODUCER_COUNTER).setUnit("{producer}").setDescription("The number of active producers of the topic connected to this broker.").buildObserver();
        this.consumerCounter = meter.upDownCounterBuilder(CONSUMER_COUNTER).setUnit("{consumer}").setDescription("The number of active consumers of the topic connected to this broker.").buildObserver();
        this.messageInCounter = meter.counterBuilder(MESSAGE_IN_COUNTER).setUnit("{message}").setDescription("The total number of messages received for this topic.").buildObserver();
        this.messageOutCounter = meter.counterBuilder(MESSAGE_OUT_COUNTER).setUnit("{message}").setDescription("The total number of messages read from this topic.").buildObserver();
        this.bytesInCounter = meter.counterBuilder(BYTES_IN_COUNTER).setUnit("By").setDescription("The total number of messages bytes received for this topic.").buildObserver();
        this.bytesOutCounter = meter.counterBuilder(BYTES_OUT_COUNTER).setUnit("By").setDescription("The total number of messages bytes read from this topic.").buildObserver();
        this.publishRateLimitHitCounter = meter.counterBuilder(PUBLISH_RATE_LIMIT_HIT_COUNTER).setUnit("{event}").setDescription("The number of times the publish rate limit is triggered.").buildObserver();
        this.storageCounter = meter.upDownCounterBuilder(STORAGE_COUNTER).setUnit("By").setDescription("The total storage size of the messages in this topic, including storage used by replicas.").buildObserver();
        this.storageLogicalCounter = meter.upDownCounterBuilder(STORAGE_LOGICAL_COUNTER).setUnit("By").setDescription("The storage size of the messages in this topic, excluding storage used by replicas.").buildObserver();
        this.storageBacklogCounter = meter.upDownCounterBuilder(STORAGE_BACKLOG_COUNTER).setUnit("By").setDescription("The size of the backlog storage for this topic.").buildObserver();
        this.storageOffloadedCounter = meter.upDownCounterBuilder(STORAGE_OFFLOADED_COUNTER).setUnit("By").setDescription("The total amount of the data in this topic offloaded to the tiered storage.").buildObserver();
        this.backlogQuotaLimitSize = meter.upDownCounterBuilder(BACKLOG_QUOTA_LIMIT_SIZE).setUnit("By").setDescription("The size based backlog quota limit for this topic.").buildObserver();
        this.backlogQuotaLimitTime = meter.gaugeBuilder(BACKLOG_QUOTA_LIMIT_TIME).ofLongs().setUnit("s").setDescription("The time based backlog quota limit for this topic.").buildObserver();
        this.backlogEvictionCounter = meter.counterBuilder(BACKLOG_EVICTION_COUNTER).setUnit("{eviction}").setDescription("The number of times a backlog was evicted since it has exceeded its quota.").buildObserver();
        this.backlogQuotaAge = meter.gaugeBuilder(BACKLOG_QUOTA_AGE).ofLongs().setUnit("s").setDescription("The age of the oldest unacknowledged message (backlog).").buildObserver();
        this.storageOutCounter = meter.counterBuilder(STORAGE_OUT_COUNTER).setUnit("{entry}").setDescription("The total message batches (entries) written to the storage for this topic.").buildObserver();
        this.storageInCounter = meter.counterBuilder(STORAGE_IN_COUNTER).setUnit("{entry}").setDescription("The total message batches (entries) read from the storage for this topic.").buildObserver();
        this.compactionRemovedCounter = meter.counterBuilder(COMPACTION_REMOVED_COUNTER).setUnit("{message}").setDescription("The total number of messages removed by compaction.").buildObserver();
        this.compactionOperationCounter = meter.counterBuilder(COMPACTION_OPERATION_COUNTER).setUnit("{operation}").setDescription("The total number of compaction operations.").buildObserver();
        this.compactionDurationSeconds = meter.upDownCounterBuilder(COMPACTION_DURATION_SECONDS).ofDoubles().setUnit("s").setDescription("The total time duration of compaction operations on the topic.").buildObserver();
        this.compactionBytesInCounter = meter.counterBuilder(COMPACTION_BYTES_IN_COUNTER).setUnit("By").setDescription("The total count of bytes read by the compaction process for this topic.").buildObserver();
        this.compactionBytesOutCounter = meter.counterBuilder(COMPACTION_BYTES_OUT_COUNTER).setUnit("By").setDescription("The total count of bytes written by the compaction process for this topic.").buildObserver();
        this.compactionEntriesCounter = meter.counterBuilder(COMPACTION_ENTRIES_COUNTER).setUnit("{entry}").setDescription("The total number of compacted entries.").buildObserver();
        this.compactionBytesCounter = meter.counterBuilder(COMPACTION_BYTES_COUNTER).setUnit("By").setDescription("The total size of the compacted entries.").buildObserver();
        this.transactionCounter = meter.upDownCounterBuilder(TRANSACTION_COUNTER).setUnit("{transaction}").setDescription("The number of transactions on this topic.").buildObserver();
        this.transactionBufferClientOperationCounter = meter.counterBuilder(TRANSACTION_BUFFER_CLIENT_OPERATION_COUNTER).setUnit("{operation}").setDescription("The number of operations on the transaction buffer client.").buildObserver();
        this.delayedSubscriptionCounter = meter.upDownCounterBuilder(DELAYED_SUBSCRIPTION_COUNTER).setUnit("{entry}").setDescription("The total number of message batches (entries) delayed for dispatching.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> pulsar.getBrokerService().getTopics().values().stream().map(topicFuture -> topicFuture.getNow(Optional.empty())).forEach(topic -> topic.ifPresent(this::recordMetricsForTopic)), (ObservableMeasurement)this.subscriptionCounter, new ObservableMeasurement[]{this.producerCounter, this.consumerCounter, this.messageInCounter, this.messageOutCounter, this.bytesInCounter, this.bytesOutCounter, this.publishRateLimitHitCounter, this.storageCounter, this.storageLogicalCounter, this.storageBacklogCounter, this.storageOffloadedCounter, this.backlogQuotaLimitSize, this.backlogQuotaLimitTime, this.backlogEvictionCounter, this.backlogQuotaAge, this.storageOutCounter, this.storageInCounter, this.compactionRemovedCounter, this.compactionOperationCounter, this.compactionDurationSeconds, this.compactionBytesInCounter, this.compactionBytesOutCounter, this.compactionEntriesCounter, this.compactionBytesCounter, this.transactionCounter, this.transactionBufferClientOperationCounter, this.delayedSubscriptionCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetricsForTopic(Topic topic) {
        TopicAttributes topicAttributes = topic.getTopicAttributes();
        Attributes attributes = topicAttributes.getCommonAttributes();
        if (topic instanceof AbstractTopic) {
            AbstractTopic abstractTopic = (AbstractTopic)topic;
            this.subscriptionCounter.record((long)abstractTopic.getSubscriptions().size(), attributes);
            this.producerCounter.record((long)abstractTopic.getProducers().size(), attributes);
            this.consumerCounter.record((long)abstractTopic.getNumberOfConsumers(), attributes);
            this.messageInCounter.record(abstractTopic.getMsgInCounter(), attributes);
            this.messageOutCounter.record(abstractTopic.getMsgOutCounter(), attributes);
            this.bytesInCounter.record(abstractTopic.getBytesInCounter(), attributes);
            this.bytesOutCounter.record(abstractTopic.getBytesOutCounter(), attributes);
            this.publishRateLimitHitCounter.record(abstractTopic.getTotalPublishRateLimitCounter(), attributes);
        }
        if (topic instanceof PersistentTopic) {
            PersistentTopic persistentTopic = (PersistentTopic)topic;
            PersistentTopicMetrics persistentTopicMetrics = persistentTopic.getPersistentTopicMetrics();
            PersistentTopicAttributes persistentTopicAttributes = persistentTopic.getTopicAttributes();
            ManagedLedger managedLedger = persistentTopic.getManagedLedger();
            ManagedLedgerMXBean managedLedgerStats = persistentTopic.getManagedLedger().getStats();
            this.storageCounter.record(managedLedgerStats.getStoredMessagesSize(), attributes);
            this.storageLogicalCounter.record(managedLedgerStats.getStoredMessagesLogicalSize(), attributes);
            this.storageBacklogCounter.record(managedLedger.getEstimatedBacklogSize(), attributes);
            this.storageOffloadedCounter.record(managedLedger.getOffloadedSize(), attributes);
            this.storageInCounter.record(managedLedgerStats.getReadEntriesSucceededTotal(), attributes);
            this.storageOutCounter.record(managedLedgerStats.getAddEntrySucceedTotal(), attributes);
            this.backlogQuotaLimitSize.record(topic.getBacklogQuota(BacklogQuota.BacklogQuotaType.destination_storage).getLimitSize(), attributes);
            this.backlogQuotaLimitTime.record((long)topic.getBacklogQuota(BacklogQuota.BacklogQuotaType.message_age).getLimitTime(), attributes);
            this.backlogQuotaAge.record(topic.getBestEffortOldestUnacknowledgedMessageAgeSeconds(), attributes);
            PersistentTopicMetrics.BacklogQuotaMetrics backlogQuotaMetrics = persistentTopicMetrics.getBacklogQuotaMetrics();
            this.backlogEvictionCounter.record(backlogQuotaMetrics.getSizeBasedBacklogQuotaExceededEvictionCount(), persistentTopicAttributes.getSizeBasedQuotaAttributes());
            this.backlogEvictionCounter.record(backlogQuotaMetrics.getTimeBasedBacklogQuotaExceededEvictionCount(), persistentTopicAttributes.getTimeBasedQuotaAttributes());
            TransactionBuffer txnBuffer = persistentTopic.getTransactionBuffer();
            this.transactionCounter.record(txnBuffer.getOngoingTxnCount(), persistentTopicAttributes.getTransactionActiveAttributes());
            this.transactionCounter.record(txnBuffer.getCommittedTxnCount(), persistentTopicAttributes.getTransactionCommittedAttributes());
            this.transactionCounter.record(txnBuffer.getAbortedTxnCount(), persistentTopicAttributes.getTransactionAbortedAttributes());
            PersistentTopicMetrics.TransactionBufferClientMetrics txnBufferClientMetrics = persistentTopicMetrics.getTransactionBufferClientMetrics();
            this.transactionBufferClientOperationCounter.record(txnBufferClientMetrics.getCommitSucceededCount().sum(), persistentTopicAttributes.getTransactionBufferClientCommitSucceededAttributes());
            this.transactionBufferClientOperationCounter.record(txnBufferClientMetrics.getCommitFailedCount().sum(), persistentTopicAttributes.getTransactionBufferClientCommitFailedAttributes());
            this.transactionBufferClientOperationCounter.record(txnBufferClientMetrics.getAbortSucceededCount().sum(), persistentTopicAttributes.getTransactionBufferClientAbortSucceededAttributes());
            this.transactionBufferClientOperationCounter.record(txnBufferClientMetrics.getAbortFailedCount().sum(), persistentTopicAttributes.getTransactionBufferClientAbortFailedAttributes());
            Optional.ofNullable(this.pulsar.getNullableCompactor()).map(Compactor::getStats).flatMap(compactorMXBean -> compactorMXBean.getCompactionRecordForTopic(topic.getName())).ifPresent(compactionRecord -> {
                this.compactionRemovedCounter.record(compactionRecord.getCompactionRemovedEventCount(), attributes);
                this.compactionOperationCounter.record(compactionRecord.getCompactionSucceedCount(), persistentTopicAttributes.getCompactionSuccessAttributes());
                this.compactionOperationCounter.record(compactionRecord.getCompactionFailedCount(), persistentTopicAttributes.getCompactionFailureAttributes());
                this.compactionDurationSeconds.record(MetricsUtil.convertToSeconds((long)compactionRecord.getCompactionDurationTimeInMills(), (TimeUnit)TimeUnit.MILLISECONDS), attributes);
                this.compactionBytesInCounter.record(compactionRecord.getCompactionReadBytes(), attributes);
                this.compactionBytesOutCounter.record(compactionRecord.getCompactionWriteBytes(), attributes);
                persistentTopic.getCompactedTopicContext().map(CompactedTopicContext::getLedger).ifPresent(ledger -> {
                    this.compactionEntriesCounter.record(ledger.getLastAddConfirmed() + 1L, attributes);
                    this.compactionBytesCounter.record(ledger.getLength(), attributes);
                });
            });
            long delayedMessages = topic.getSubscriptions().values().stream().map(Subscription::getDispatcher).filter(Objects::nonNull).mapToLong(Dispatcher::getNumberOfDelayedMessages).sum();
            this.delayedSubscriptionCounter.record(delayedMessages, attributes);
        }
    }
}

