/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.ClusterOperation;
import org.apache.pulsar.common.policies.data.ClusterPolicies;
import org.apache.pulsar.common.policies.data.ClusterPoliciesImpl;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationPolicyUnloadScope;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicyImpl;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClustersBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(ClustersBase.class);

    @GET
    @ApiOperation(value="Get the list of all the Pulsar clusters.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="Return a list of clusters."), @ApiResponse(code=500, message="Internal server error.")})
    public void getClusters(@Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)this.clusterResources().listAsync().thenApply(clusters -> clusters.stream().filter(cluster -> !"global".equals(cluster)).collect(Collectors.toSet()))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get clusters {}", (Object)this.clientAppId(), ex);
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{cluster}")
    @ApiOperation(value="Get the configuration for the specified cluster.", response=ClusterDataImpl.class, notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=200, message="Return the cluster data.", response=ClusterDataImpl.class), @ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void getCluster(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.GET_CLUSTER).thenCompose(__ -> this.clusterResources().getClusterAsync(cluster))).thenAccept(clusterData -> asyncResponse.resume(clusterData.orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster does not exist"))))).exceptionally(ex -> {
            log.error("[{}] Failed to get cluster {}", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{cluster}")
    @ApiOperation(value="Create a new cluster.", notes="This operation requires Pulsar superuser privileges, and the name cannot contain the '/' characters.")
    @ApiResponses(value={@ApiResponse(code=200, message="Cluster has been created."), @ApiResponse(code=400, message="Bad request parameter."), @ApiResponse(code=403, message="You don't have admin permission to create the cluster."), @ApiResponse(code=409, message="Cluster already exists."), @ApiResponse(code=412, message="Cluster name is not valid."), @ApiResponse(code=500, message="Internal server error.")})
    public void createCluster(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The cluster data", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n   \"serviceUrl\": \"http://pulsar.example.com:8080\",\n   \"brokerServiceUrl\": \"pulsar://pulsar.example.com:6651\",\n}\n")})) ClusterDataImpl clusterData) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.CREATE_CLUSTER).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> {
            NamedEntity.checkName((String)cluster);
            if (clusterData == null) {
                throw new RestException(Response.Status.BAD_REQUEST, "cluster data is required");
            }
            try {
                clusterData.checkPropertiesIfPresent();
            }
            catch (IllegalArgumentException ex) {
                throw new RestException(Response.Status.BAD_REQUEST, ex.getMessage());
            }
            return this.clusterResources().getClusterAsync(cluster);
        })).thenCompose(clusterOpt -> {
            if (clusterOpt.isPresent()) {
                throw new RestException(Response.Status.CONFLICT, "Cluster already exists");
            }
            return this.clusterResources().createClusterAsync(cluster, (ClusterData)clusterData);
        })).thenAccept(__ -> {
            log.info("[{}] Created cluster {}", (Object)this.clientAppId(), (Object)cluster);
            asyncResponse.resume((Object)Response.ok().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to create cluster {}", new Object[]{this.clientAppId(), cluster, ex});
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof IllegalArgumentException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Cluster name is not valid")));
                return null;
            }
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{cluster}")
    @ApiOperation(value="Update the configuration for a cluster.", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=200, message="Cluster has been updated."), @ApiResponse(code=400, message="Bad request parameter."), @ApiResponse(code=403, message="Don't have admin permission or policies are read-only."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void updateCluster(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The cluster data", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n   \"serviceUrl\": \"http://pulsar.example.com:8080\",\n   \"brokerServiceUrl\": \"pulsar://pulsar.example.com:6651\"\n}\n")})) ClusterDataImpl clusterData) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.UPDATE_CLUSTER).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> {
            try {
                clusterData.checkPropertiesIfPresent();
            }
            catch (IllegalArgumentException ex) {
                throw new RestException(Response.Status.BAD_REQUEST, ex.getMessage());
            }
            return this.clusterResources().updateClusterAsync(cluster, old -> clusterData);
        })).thenAccept(__ -> {
            log.info("[{}] Updated cluster {}", (Object)this.clientAppId(), (Object)cluster);
            asyncResponse.resume((Object)Response.ok().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to update cluster {}", new Object[]{this.clientAppId(), cluster, ex});
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Cluster does not exist")));
                return null;
            }
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{cluster}/migrate")
    @ApiOperation(value="Get the cluster migration configuration for the specified cluster.", response=ClusterDataImpl.class, notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=200, message="Return the cluster data.", response=ClusterDataImpl.class), @ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void getClusterMigration(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.CLUSTER_MIGRATION, PolicyOperation.READ).thenCompose(__ -> this.clusterResources().getClusterPoliciesResources().getClusterPoliciesAsync(cluster))).thenAccept(policies -> asyncResponse.resume(policies.orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster does not exist"))))).exceptionally(ex -> {
            log.error("[{}] Failed to get cluster {} migration", new Object[]{this.clientAppId(), cluster, ex});
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Cluster does not exist")));
                return null;
            }
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{cluster}/migrate")
    @ApiOperation(value="Update the configuration for a cluster migration.", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=200, message="Cluster has been updated."), @ApiResponse(code=400, message="Cluster url must not be empty."), @ApiResponse(code=403, message="Don't have admin permission or policies are read-only."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void updateClusterMigration(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="Is cluster migrated", required=true) @QueryParam(value="migrated") boolean isMigrated, @ApiParam(value="The cluster url data", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n   \"serviceUrl\": \"http://pulsar.example.com:8080\",\n   \"brokerServiceUrl\": \"pulsar://pulsar.example.com:6651\"\n}\n")})) ClusterPolicies.ClusterUrl clusterUrl) {
        if (isMigrated && clusterUrl.isEmpty()) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Cluster url must not be empty")));
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.CLUSTER_MIGRATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.clusterResources().getClusterPoliciesResources().setPoliciesWithCreateAsync(cluster, old -> {
            ClusterPoliciesImpl data = old.orElse(new ClusterPoliciesImpl());
            data.setMigrated(isMigrated);
            data.setMigratedClusterUrl(clusterUrl);
            return data;
        }))).thenAccept(__ -> {
            log.info("[{}] Updated cluster {}", (Object)this.clientAppId(), (Object)cluster);
            asyncResponse.resume((Object)Response.ok().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to update cluster {}", new Object[]{this.clientAppId(), cluster, ex});
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Cluster does not exist")));
                return null;
            }
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{cluster}/peers")
    @ApiOperation(value="Update peer-cluster-list for a cluster.", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Cluster has been updated."), @ApiResponse(code=403, message="Don't have admin permission or policies are read-only."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=412, message="Peer cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void setPeerClusterNames(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The list of peer cluster names", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="[\n   \"cluster-a\",\n   \"cluster-b\"\n]")})) LinkedHashSet<String> peerClusterNames) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.UPDATE_PEER_CLUSTER).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.innerSetPeerClusterNamesAsync(cluster, peerClusterNames))).thenAccept(__ -> {
            log.info("[{}] Successfully added peer-cluster {} for {}", new Object[]{this.clientAppId(), peerClusterNames, cluster});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            log.error("[{}] Failed to validate peer-cluster list {}, {}", new Object[]{this.clientAppId(), peerClusterNames, ex});
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Cluster does not exist")));
                return null;
            }
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> innerSetPeerClusterNamesAsync(String cluster, LinkedHashSet<String> peerClusterNames) {
        CompletableFuture future = CollectionUtils.isNotEmpty(peerClusterNames) ? FutureUtil.waitForAll((Collection)peerClusterNames.stream().map(peerCluster -> {
            if (cluster.equalsIgnoreCase((String)peerCluster)) {
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, cluster + " itself can't be part of peer-list")));
            }
            return this.clusterResources().getClusterAsync(peerCluster).thenAccept(peerClusterOpt -> {
                if (!peerClusterOpt.isPresent()) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Peer cluster " + peerCluster + " does not exist");
                }
            });
        }).collect(Collectors.toList())) : CompletableFuture.completedFuture(null);
        return future.thenCompose(__ -> this.clusterResources().updateClusterAsync(cluster, old -> old.clone().peerClusterNames(peerClusterNames).build()));
    }

    @GET
    @Path(value="/{cluster}/peers")
    @ApiOperation(value="Get the peer-cluster data for the specified cluster.", response=String.class, responseContainer="Set", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void getPeerCluster(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.GET_PEER_CLUSTER).thenCompose(__ -> this.clusterResources().getClusterAsync(cluster))).thenAccept(clusterOpt -> {
            ClusterData clusterData = (ClusterData)clusterOpt.orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster does not exist"));
            asyncResponse.resume((Object)clusterData.getPeerClusterNames());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get cluster {}", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{cluster}")
    @ApiOperation(value="Delete an existing cluster.", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Cluster has been deleted."), @ApiResponse(code=403, message="Don't have admin permission or policies are read-only."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=412, message="Cluster is not empty."), @ApiResponse(code=500, message="Internal server error.")})
    public void deleteCluster(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.DELETE_CLUSTER).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.internalDeleteClusterAsync(cluster))).thenAccept(__ -> {
            log.info("[{}] Deleted cluster {}", (Object)this.clientAppId(), (Object)cluster);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                log.warn("[{}] Failed to delete cluster {} - Does not exist", (Object)this.clientAppId(), (Object)cluster);
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Cluster does not exist")));
                return null;
            }
            log.error("[{}] Failed to delete cluster {}", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> internalDeleteClusterAsync(String cluster) {
        return ((CompletableFuture)((CompletableFuture)this.pulsar().getPulsarResources().getClusterResources().isClusterUsedAsync(cluster).thenCompose(isClusterUsed -> {
            if (isClusterUsed.booleanValue()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster not empty");
            }
            return this.namespaceIsolationPolicies().getIsolationDataPoliciesAsync(cluster);
        })).thenCompose(nsIsolationPoliciesOpt -> {
            if (nsIsolationPoliciesOpt.isPresent()) {
                if (!((NamespaceIsolationPolicies)nsIsolationPoliciesOpt.get()).getPolicies().isEmpty()) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster not empty");
                }
                return this.namespaceIsolationPolicies().deleteIsolationDataAsync(cluster);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(unused -> this.clusterResources().getFailureDomainResources().deleteFailureDomainsAsync(cluster).thenCompose(__ -> this.clusterResources().deleteClusterAsync(cluster)));
    }

    @GET
    @Path(value="/{cluster}/namespaceIsolationPolicies")
    @ApiOperation(value="Get the namespace isolation policies assigned to the cluster.", response=NamespaceIsolationDataImpl.class, responseContainer="Map", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void getNamespaceIsolationPolicies(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.NAMESPACE_ISOLATION, PolicyOperation.READ).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.NOT_FOUND))).thenCompose(__ -> this.internalGetNamespaceIsolationPolicies(cluster))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get clusters/{}/namespaceIsolationPolicies", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> validateClusterExistAsync(String cluster, Response.Status notExistStatus) {
        return this.clusterResources().clusterExistsAsync(cluster).thenAccept(clusterExist -> {
            if (!clusterExist.booleanValue()) {
                throw new RestException(notExistStatus, "Cluster " + cluster + " does not exist.");
            }
        });
    }

    private CompletableFuture<Map<String, NamespaceIsolationDataImpl>> internalGetNamespaceIsolationPolicies(String cluster) {
        return this.namespaceIsolationPolicies().getIsolationDataPoliciesAsync(cluster).thenApply(namespaceIsolationPolicies -> {
            if (!namespaceIsolationPolicies.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, "NamespaceIsolationPolicies for cluster " + cluster + " does not exist");
            }
            return ((NamespaceIsolationPolicies)namespaceIsolationPolicies.get()).getPolicies();
        });
    }

    @GET
    @Path(value="/{cluster}/namespaceIsolationPolicies/{policyName}")
    @ApiOperation(value="Get the single namespace isolation policy assigned to the cluster.", response=NamespaceIsolationDataImpl.class, notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Policy doesn't exist."), @ApiResponse(code=412, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void getNamespaceIsolationPolicy(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The name of the namespace isolation policy", required=true) @PathParam(value="policyName") String policyName) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.NAMESPACE_ISOLATION, PolicyOperation.READ).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> this.internalGetNamespaceIsolationPolicies(cluster))).thenAccept(policies -> {
            if (!policies.containsKey(policyName)) {
                throw new RestException(Response.Status.NOT_FOUND, "Cannot find NamespaceIsolationPolicy " + policyName + " for cluster " + cluster);
            }
            asyncResponse.resume(policies.get(policyName));
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get clusters/{}/namespaceIsolationPolicies/{}", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{cluster}/namespaceIsolationPolicies/brokers")
    @ApiOperation(value="Get list of brokers with namespace-isolation policies attached to them.", response=BrokerNamespaceIsolationDataImpl.class, responseContainer="set", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Namespace-isolation policies not found."), @ApiResponse(code=412, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void getBrokersWithNamespaceIsolationPolicy(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.NAMESPACE_ISOLATION, PolicyOperation.READ).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> this.pulsar().getLoadManager().get().getAvailableBrokersAsync())).thenCompose(availableBrokers -> this.internalGetNamespaceIsolationPolicies(cluster).thenApply(policies -> availableBrokers.stream().map(broker -> this.internalGetBrokerNsIsolationData((String)broker, (Map<String, NamespaceIsolationDataImpl>)policies)).collect(Collectors.toList())))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get namespace isolation-policies {}", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private BrokerNamespaceIsolationData internalGetBrokerNsIsolationData(String broker, Map<String, NamespaceIsolationDataImpl> policies) {
        BrokerNamespaceIsolationData.Builder brokerIsolationData = BrokerNamespaceIsolationData.builder().brokerName(broker);
        if (policies == null) {
            return brokerIsolationData.build();
        }
        ArrayList namespaceRegexes = new ArrayList();
        policies.forEach((name, policyData) -> {
            NamespaceIsolationPolicyImpl nsPolicyImpl = new NamespaceIsolationPolicyImpl((NamespaceIsolationData)policyData);
            if (nsPolicyImpl.isPrimaryBroker(broker) || nsPolicyImpl.isSecondaryBroker(broker)) {
                namespaceRegexes.addAll(policyData.getNamespaces());
                brokerIsolationData.primary(nsPolicyImpl.isPrimaryBroker(broker));
                brokerIsolationData.policyName(name);
            }
        });
        brokerIsolationData.namespaceRegex(namespaceRegexes);
        return brokerIsolationData.build();
    }

    @GET
    @Path(value="/{cluster}/namespaceIsolationPolicies/brokers/{broker}")
    @ApiOperation(value="Get a broker with namespace-isolation policies attached to it.", response=BrokerNamespaceIsolationDataImpl.class, notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Namespace-isolation policies/ Broker not found."), @ApiResponse(code=412, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void getBrokerWithNamespaceIsolationPolicy(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The broker name (<broker-hostname>:<web-service-port>)", required=true, example="broker1:8080") @PathParam(value="broker") String broker) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.NAMESPACE_ISOLATION, PolicyOperation.READ).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> this.internalGetNamespaceIsolationPolicies(cluster))).thenApply(policies -> this.internalGetBrokerNsIsolationData(broker, (Map<String, NamespaceIsolationDataImpl>)policies))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get namespace isolation-policies {}", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{cluster}/namespaceIsolationPolicies/{policyName}")
    @ApiOperation(value="Set namespace isolation policy.", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Set namespace isolation policy successfully."), @ApiResponse(code=400, message="Namespace isolation policy data is invalid."), @ApiResponse(code=403, message="Don't have admin permission or policies are read-only."), @ApiResponse(code=404, message="Namespace isolation policy doesn't exist."), @ApiResponse(code=412, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void setNamespaceIsolationPolicy(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The namespace isolation policy name", required=true) @PathParam(value="policyName") String policyName, @ApiParam(value="The namespace isolation policy data", required=true) NamespaceIsolationDataImpl policyData) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.NAMESPACE_ISOLATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> {
            policyData.validate();
            return this.namespaceIsolationPolicies().getIsolationDataPoliciesAsync(cluster);
        })).thenCompose(nsIsolationPoliciesOpt -> nsIsolationPoliciesOpt.map(CompletableFuture::completedFuture).orElseGet(() -> this.namespaceIsolationPolicies().setIsolationDataWithCreateAsync(cluster, p -> Collections.emptyMap()).thenApply(__ -> new NamespaceIsolationPolicies())))).thenCompose(nsIsolationPolicies -> {
            NamespaceIsolationDataImpl oldPolicy = nsIsolationPolicies.getPolicies().getOrDefault(policyName, null);
            nsIsolationPolicies.setPolicy(policyName, (NamespaceIsolationData)policyData);
            return this.namespaceIsolationPolicies().setIsolationDataAsync(cluster, old -> nsIsolationPolicies.getPolicies()).thenApply(__ -> oldPolicy);
        })).thenCompose(oldPolicy -> this.filterAndUnloadMatchedNamespaceAsync(cluster, policyData, (NamespaceIsolationDataImpl)oldPolicy))).thenAccept(__ -> {
            log.info("[{}] Successful to update clusters/{}/namespaceIsolationPolicies/{}.", new Object[]{this.clientAppId(), cluster, policyName});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof IllegalArgumentException) {
                String jsonData;
                try {
                    jsonData = JsonUtil.toJson((Object)policyData);
                }
                catch (JsonUtil.ParseJsonException e) {
                    jsonData = "[Failed to serialize]";
                }
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Invalid format of input policy data. policy: " + policyName + "; data: " + jsonData)));
                return null;
            }
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                log.warn("[{}] Failed to update clusters/{}/namespaceIsolationPolicies: Does not exist", (Object)this.clientAppId(), (Object)cluster);
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "NamespaceIsolationPolicies for cluster " + cluster + " does not exist")));
                return null;
            }
            log.info("[{}] Failed to update clusters/{}/namespaceIsolationPolicies/{}. Input data is invalid", new Object[]{this.clientAppId(), cluster, policyName, realCause});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> filterAndUnloadMatchedNamespaceAsync(String cluster, NamespaceIsolationDataImpl policyData, NamespaceIsolationDataImpl oldPolicy) {
        PulsarAdmin adminClient;
        if (NamespaceIsolationPolicyUnloadScope.none.equals((Object)policyData.getUnloadScope())) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            adminClient = this.pulsar().getAdminClient();
        }
        catch (PulsarServerException e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
        HashSet combinedNamespaces = new HashSet(policyData.getNamespaces());
        ArrayList oldNamespaces = new ArrayList();
        if (oldPolicy != null) {
            oldNamespaces.addAll(oldPolicy.getNamespaces());
            combinedNamespaces.addAll(oldNamespaces);
        }
        return ((CompletableFuture)adminClient.tenants().getTenantsAsync().thenCompose(tenants -> {
            List<CompletableFuture> filteredNamespacesForEachTenant = tenants.stream().map(tenant -> adminClient.namespaces().getNamespacesAsync(tenant).thenCompose(namespaces -> {
                List namespaceNamesInCluster = namespaces.stream().map(namespaceName -> adminClient.namespaces().getPoliciesAsync(namespaceName).thenApply(policies -> {
                    boolean allowed = this.pulsar().getBrokerService().isCurrentClusterAllowed(NamespaceName.get((String)namespaceName), (Policies)policies);
                    return allowed ? namespaceName : null;
                })).collect(Collectors.toList());
                return FutureUtil.waitForAll(namespaceNamesInCluster).thenApply(__ -> namespaceNamesInCluster.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList()));
            })).toList();
            return FutureUtil.waitForAll(filteredNamespacesForEachTenant).thenApply(__ -> filteredNamespacesForEachTenant.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList()));
        })).thenCompose(clusterLocalNamespaces -> {
            if (CollectionUtils.isEmpty((Collection)clusterLocalNamespaces)) {
                return CompletableFuture.completedFuture(null);
            }
            log.debug("Old policy: {} ; new policy: {}", (Object)oldPolicy, (Object)policyData);
            boolean unloadAllNamespaces = false;
            if (NamespaceIsolationPolicyUnloadScope.all_matching.equals((Object)policyData.getUnloadScope()) || oldPolicy != null && !CollectionUtils.isEqualCollection((Collection)oldPolicy.getPrimary(), (Collection)policyData.getPrimary())) {
                unloadAllNamespaces = true;
            }
            HashSet commonNamespaces = new HashSet(policyData.getNamespaces());
            commonNamespaces.retainAll(oldNamespaces);
            log.debug("combined regexes: {}; common regexes:{}", (Object)combinedNamespaces, commonNamespaces);
            if (!unloadAllNamespaces) {
                combinedNamespaces.removeAll(commonNamespaces);
                log.debug("changed regexes: {}", commonNamespaces);
            }
            List<Pattern> namespacePatterns = combinedNamespaces.stream().map(Pattern::compile).toList();
            clusterLocalNamespaces = clusterLocalNamespaces.stream().filter(name -> namespacePatterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)name).matches())).toList();
            List futures = clusterLocalNamespaces.stream().map(namespaceName -> adminClient.namespaces().unloadAsync(namespaceName)).collect(Collectors.toList());
            return FutureUtil.waitForAll(futures).thenAccept(__ -> {
                try {
                    this.pulsar().getLoadManager().get().writeLoadReportOnZookeeper(true);
                }
                catch (Exception e) {
                    log.warn("[{}] Failed to writeLoadReportOnZookeeper.", (Object)this.clientAppId(), (Object)e);
                }
            });
        });
    }

    @DELETE
    @Path(value="/{cluster}/namespaceIsolationPolicies/{policyName}")
    @ApiOperation(value="Delete namespace isolation policy.", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Delete namespace isolation policy successfully."), @ApiResponse(code=403, message="Don't have admin permission or policies are read only."), @ApiResponse(code=404, message="Namespace isolation policy doesn't exist."), @ApiResponse(code=412, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void deleteNamespaceIsolationPolicy(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The namespace isolation policy name", required=true) @PathParam(value="policyName") String policyName) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterPolicyOperation(cluster, PolicyName.NAMESPACE_ISOLATION, PolicyOperation.WRITE).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.namespaceIsolationPolicies().getIsolationDataPoliciesAsync(cluster))).thenCompose(nsIsolationPoliciesOpt -> nsIsolationPoliciesOpt.map(CompletableFuture::completedFuture).orElseGet(() -> this.namespaceIsolationPolicies().setIsolationDataWithCreateAsync(cluster, p -> Collections.emptyMap()).thenApply(__ -> new NamespaceIsolationPolicies())))).thenCompose(policies -> {
            policies.deletePolicy(policyName);
            return this.namespaceIsolationPolicies().setIsolationDataAsync(cluster, old -> policies.getPolicies());
        })).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                log.warn("[{}] Failed to update brokers/{}/namespaceIsolationPolicies: Does not exist", (Object)this.clientAppId(), (Object)cluster);
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "NamespaceIsolationPolicies for cluster " + cluster + " does not exist")));
                return null;
            }
            log.error("[{}] Failed to update brokers/{}/namespaceIsolationPolicies/{}", new Object[]{this.clientAppId(), cluster, policyName, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{cluster}/failureDomains/{domainName}")
    @ApiOperation(value="Set the failure domain of the cluster.", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Set the failure domain of the cluster successfully."), @ApiResponse(code=403, message="Don't have admin permission."), @ApiResponse(code=404, message="Failure domain doesn't exist."), @ApiResponse(code=409, message="Broker already exists in another domain."), @ApiResponse(code=412, message="Cluster doesn't exist."), @ApiResponse(code=500, message="Internal server error.")})
    public void setFailureDomain(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The failure domain name", required=true) @PathParam(value="domainName") String domainName, @ApiParam(value="The configuration data of a failure domain", required=true) FailureDomainImpl domain) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.UPDATE_FAILURE_DOMAIN).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> this.validateBrokerExistsInOtherDomain(cluster, domainName, domain))).thenCompose(__ -> this.clusterResources().getFailureDomainResources().setFailureDomainWithCreateAsync(cluster, domainName, old -> domain))).thenAccept(__ -> {
            log.info("[{}] Successful set failure domain {} for cluster {}", new Object[]{this.clientAppId(), domainName, cluster});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                log.warn("[{}] Failed to update domain {}. clusters {}  Does not exist", new Object[]{this.clientAppId(), cluster, domainName});
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Domain " + domainName + " for cluster " + cluster + " does not exist")));
                return null;
            }
            log.error("[{}] Failed to update clusters/{}/domainName/{}", new Object[]{this.clientAppId(), cluster, domainName, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{cluster}/failureDomains")
    @ApiOperation(value="Get the cluster failure domains.", response=FailureDomainImpl.class, responseContainer="Map", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=500, message="Internal server error")})
    public void getFailureDomains(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.GET_FAILURE_DOMAIN).thenCompose(__ -> ((CompletableFuture)this.clusterResources().getFailureDomainResources().listFailureDomainsAsync(cluster).thenCompose(domainNames -> {
            List futures = domainNames.stream().map(domainName -> ((CompletableFuture)this.clusterResources().getFailureDomainResources().getFailureDomainAsync(cluster, domainName).thenApply(failureDomainImpl -> Pair.of((Object)domainName, (Object)failureDomainImpl))).exceptionally(ex -> {
                log.warn("Failed to get domain {}", domainName, ex);
                return null;
            })).collect(Collectors.toList());
            return FutureUtil.waitForAll(futures).thenApply(unused -> futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).filter(v -> ((Optional)v.getRight()).isPresent()).collect(Collectors.toMap(Pair::getLeft, v -> (FailureDomainImpl)((Optional)v.getRight()).get())));
        })).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException) {
                log.warn("[{}] Failure-domain is not configured for cluster {}", new Object[]{this.clientAppId(), cluster, ex});
                return Collections.emptyMap();
            }
            throw FutureUtil.wrapToCompletionException((Throwable)ex);
        }))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get failure-domains for cluster {}", new Object[]{this.clientAppId(), cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{cluster}/failureDomains/{domainName}")
    @ApiOperation(value="Get a domain in a cluster", response=FailureDomainImpl.class, notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="FailureDomain doesn't exist"), @ApiResponse(code=412, message="Cluster doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void getDomain(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The failure domain name", required=true) @PathParam(value="domainName") String domainName) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.GET_FAILURE_DOMAIN).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> this.clusterResources().getFailureDomainResources().getFailureDomainAsync(cluster, domainName))).thenAccept(domain -> {
            FailureDomainImpl failureDomain = (FailureDomainImpl)domain.orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Domain " + domainName + " for cluster " + cluster + " does not exist"));
            asyncResponse.resume((Object)failureDomain);
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get domain {} for cluster {}", new Object[]{this.clientAppId(), domainName, cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{cluster}/failureDomains/{domainName}")
    @ApiOperation(value="Delete the failure domain of the cluster", notes="This operation requires Pulsar superuser privileges.")
    @ApiResponses(value={@ApiResponse(code=200, message="Delete the failure domain of the cluster successfully"), @ApiResponse(code=403, message="Don't have admin permission or policy is read only"), @ApiResponse(code=404, message="FailureDomain doesn't exist"), @ApiResponse(code=412, message="Cluster doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void deleteFailureDomain(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The cluster name", required=true) @PathParam(value="cluster") String cluster, @ApiParam(value="The failure domain name", required=true) @PathParam(value="domainName") String domainName) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndClusterOperation(cluster, ClusterOperation.DELETE_FAILURE_DOMAIN).thenCompose(__ -> this.validateClusterExistAsync(cluster, Response.Status.PRECONDITION_FAILED))).thenCompose(__ -> this.clusterResources().getFailureDomainResources().deleteFailureDomainAsync(cluster, domainName))).thenAccept(__ -> {
            log.info("[{}] Successful delete domain {} in cluster {}", new Object[]{this.clientAppId(), domainName, cluster});
            asyncResponse.resume((Object)Response.ok().build());
        })).exceptionally(ex -> {
            Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (cause instanceof MetadataStoreException.NotFoundException) {
                log.warn("[{}] Domain {} does not exist in {}", new Object[]{this.clientAppId(), domainName, cluster});
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Domain-name " + domainName + " or cluster " + cluster + " does not exist")));
                return null;
            }
            log.error("[{}] Failed to delete domain {} in cluster {}", new Object[]{this.clientAppId(), domainName, cluster, ex});
            ClustersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> validateBrokerExistsInOtherDomain(String cluster, String inputDomainName, FailureDomainImpl inputDomain) {
        if (inputDomain == null || inputDomain.brokers == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.clusterResources().getFailureDomainResources().listFailureDomainsAsync(cluster).thenCompose(domainNames -> {
            List futures = domainNames.stream().filter(domainName -> !domainName.equals(inputDomainName)).map(domainName -> ((CompletableFuture)this.clusterResources().getFailureDomainResources().getFailureDomainAsync(cluster, domainName).thenAccept(failureDomainOpt -> {
                if (failureDomainOpt.isPresent() && CollectionUtils.isNotEmpty((Collection)((FailureDomainImpl)failureDomainOpt.get()).getBrokers())) {
                    List duplicateBrokers = ((Stream)((FailureDomainImpl)failureDomainOpt.get()).getBrokers().stream().parallel()).filter(inputDomain.brokers::contains).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(duplicateBrokers)) {
                        throw new RestException(Response.Status.CONFLICT, String.valueOf(duplicateBrokers) + " already exists in " + domainName);
                    }
                }
            })).exceptionally(ex -> {
                Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (realCause instanceof WebApplicationException) {
                    throw FutureUtil.wrapToCompletionException((Throwable)ex);
                }
                if (realCause instanceof MetadataStoreException.NotFoundException) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Domain is not configured for cluster", (Object)this.clientAppId(), ex);
                    }
                    return null;
                }
                log.warn("Failed to get domain {}", domainName, ex);
                return null;
            })).collect(Collectors.toList());
            return FutureUtil.waitForAll(futures);
        });
    }

    private CompletableFuture<Void> validateBothSuperuserAndClusterOperation(String clusterName, ClusterOperation operation) {
        CompletableFuture<Void> superUserAccessValidation = this.validateSuperUserAccessAsync();
        CompletableFuture<Void> clusterOperationValidation = this.validateClusterOperationAsync(clusterName, operation);
        return FutureUtil.waitForAll(List.of(superUserAccessValidation, clusterOperationValidation)).handle((result, err) -> {
            if (!superUserAccessValidation.isCompletedExceptionally() || !clusterOperationValidation.isCompletedExceptionally()) {
                return null;
            }
            if (log.isDebugEnabled()) {
                Throwable superUserValidationException = null;
                try {
                    superUserAccessValidation.join();
                }
                catch (Throwable ex) {
                    superUserValidationException = FutureUtil.unwrapCompletionException((Throwable)ex);
                }
                Throwable clusterOperationValidationException = null;
                try {
                    clusterOperationValidation.join();
                }
                catch (Throwable ex) {
                    clusterOperationValidationException = FutureUtil.unwrapCompletionException((Throwable)ex);
                }
                log.debug("validateBothSuperuserAndClusterOperation failed. originalPrincipal={} clientAppId={} operation={} cluster={} superuserValidationError={} clusterOperationValidationError={}", new Object[]{this.originalPrincipal(), this.clientAppId(), operation.toString(), clusterName, superUserValidationException, clusterOperationValidationException});
            }
            throw new RestException(Response.Status.UNAUTHORIZED, String.format("Unauthorized to validateBothSuperuserAndClusterOperation for originalPrincipal [%s] and clientAppId [%s] about operation [%s] on cluster [%s]", this.originalPrincipal(), this.clientAppId(), operation.toString(), clusterName));
        });
    }

    private CompletableFuture<Void> validateBothSuperuserAndClusterPolicyOperation(String clusterName, PolicyName name, PolicyOperation operation) {
        CompletableFuture<Void> superUserAccessValidation = this.validateSuperUserAccessAsync();
        CompletableFuture<Void> clusterOperationValidation = this.validateClusterPolicyOperationAsync(clusterName, name, operation);
        return FutureUtil.waitForAll(List.of(superUserAccessValidation, clusterOperationValidation)).handle((result, err) -> {
            if (!superUserAccessValidation.isCompletedExceptionally() || !clusterOperationValidation.isCompletedExceptionally()) {
                return null;
            }
            if (log.isDebugEnabled()) {
                Throwable superUserValidationException = null;
                try {
                    superUserAccessValidation.join();
                }
                catch (Throwable ex) {
                    superUserValidationException = FutureUtil.unwrapCompletionException((Throwable)ex);
                }
                Throwable clusterOperationValidationException = null;
                try {
                    clusterOperationValidation.join();
                }
                catch (Throwable ex) {
                    clusterOperationValidationException = FutureUtil.unwrapCompletionException((Throwable)ex);
                }
                log.debug("validateBothSuperuserAndClusterPolicyOperation failed. originalPrincipal={} clientAppId={} operation={} cluster={} superuserValidationError={} clusterOperationValidationError={}", new Object[]{this.originalPrincipal(), this.clientAppId(), operation.toString(), clusterName, superUserValidationException, clusterOperationValidationException});
            }
            throw new RestException(Response.Status.UNAUTHORIZED, String.format("Unauthorized to validateBothSuperuserAndClusterPolicyOperation for originalPrincipal [%s] and clientAppId [%s] about operation [%s] on cluster [%s]", this.originalPrincipal(), this.clientAppId(), operation.toString(), clusterName));
        });
    }

    private CompletableFuture<Void> validateClusterOperationAsync(String cluster, ClusterOperation operation) {
        PulsarService pulsar = this.pulsar();
        if (pulsar.getBrokerService().isAuthenticationEnabled() && pulsar.getBrokerService().isAuthorizationEnabled()) {
            return pulsar.getBrokerService().getAuthorizationService().allowClusterOperationAsync(cluster, operation, this.originalPrincipal(), this.clientAppId(), this.clientAuthData()).thenAccept(isAuthorized -> {
                if (!isAuthorized.booleanValue()) {
                    throw new RestException(Response.Status.UNAUTHORIZED, String.format("Unauthorized to validateClusterOperation for originalPrincipal [%s] and clientAppId [%s] about operation [%s] on cluster [%s]", this.originalPrincipal(), this.clientAppId(), operation.toString(), cluster));
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> validateClusterPolicyOperationAsync(String cluster, PolicyName policyName, PolicyOperation operation) {
        PulsarService pulsar = this.pulsar();
        if (pulsar.getBrokerService().isAuthenticationEnabled() && pulsar.getBrokerService().isAuthorizationEnabled()) {
            return pulsar.getBrokerService().getAuthorizationService().allowClusterPolicyOperationAsync(cluster, policyName, operation, this.originalPrincipal(), this.clientAppId(), this.clientAuthData()).thenAccept(isAuthorized -> {
                if (!isAuthorized.booleanValue()) {
                    throw new RestException(Response.Status.UNAUTHORIZED, String.format("Unauthorized to validateClusterPolicyOperation for originalPrincipal [%s] and clientAppId [%s] about operation [%s] on cluster [%s]", this.originalPrincipal(), this.clientAppId(), operation.toString(), cluster));
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

