/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterInitializer;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.ShutdownUtil;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreLifecycle;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver;
import org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver;
import org.apache.pulsar.metadata.impl.MetadataStoreFactoryImpl;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class PulsarClusterMetadataSetup {
    private static final int DEFAULT_BUNDLE_NUMBER = 16;
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataSetup.class);

    private static void createMetadataNode(MetadataStore store, String path, byte[] data) throws InterruptedException, ExecutionException {
        block2: {
            try {
                store.put(path, data, Optional.of(-1L)).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof MetadataStoreException.BadVersionException) break block2;
                throw e;
            }
        }
    }

    private static void initialDlogNamespaceMetadata(String configurationStore, String bkMetadataServiceUri) throws IOException {
        InternalConfigurationData internalConf = new InternalConfigurationData(configurationStore, configurationStore, null, bkMetadataServiceUri, null);
        WorkerUtils.initializeDlogNamespace((InternalConfigurationData)internalConf);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("bookkeeper.metadata.bookie.drivers", PulsarMetadataBookieDriver.class.getName());
        System.setProperty("bookkeeper.metadata.client.drivers", PulsarMetadataClientDriver.class.getName());
        Arguments arguments = new Arguments();
        CommandLine commander = new CommandLine((Object)arguments);
        try {
            commander.parseArgs(args);
            if (arguments.help) {
                commander.usage(commander.getOut());
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("initialize-cluster-metadata", (Object)commander);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            commander.getErr().println(e);
            throw e;
        }
        if (arguments.metadataStoreUrl == null && arguments.zookeeper == null) {
            System.err.println("Metadata store address argument is required (--metadata-store)");
            commander.usage(commander.getOut());
            System.exit(1);
        }
        if (arguments.configurationMetadataStore == null && arguments.configurationStore == null && arguments.globalZookeeper == null) {
            System.err.println("Configuration metadata store address argument is required (--configuration-metadata-store)");
            commander.usage(commander.getOut());
            System.exit(1);
        }
        if (arguments.configurationMetadataStore != null && (arguments.configurationStore != null || arguments.globalZookeeper != null)) {
            System.err.println("Configuration metadata store argument (--configuration-metadata-store) supersedes the deprecated (--global-zookeeper and --configuration-store) argument");
            commander.usage(commander.getOut());
            System.exit(1);
        }
        if (arguments.configurationMetadataStore == null) {
            String string = arguments.configurationMetadataStore = arguments.configurationStore == null ? arguments.globalZookeeper : arguments.configurationStore;
        }
        if (arguments.metadataStoreUrl == null) {
            arguments.metadataStoreUrl = "zk:" + arguments.zookeeper;
        }
        if (arguments.numTransactionCoordinators <= 0) {
            System.err.println("Number of transaction coordinators must greater than 0");
            System.exit(1);
        }
        int bundleNumberForDefaultNamespace = arguments.numberOfDefaultNamespaceBundles > 0 ? arguments.numberOfDefaultNamespaceBundles : 16;
        try {
            PulsarClusterMetadataSetup.initializeCluster(arguments, bundleNumberForDefaultNamespace);
        }
        catch (Exception e) {
            System.err.println("Unexpected error occured.");
            e.printStackTrace(System.err);
            System.err.println("Terminating JVM...");
            ShutdownUtil.triggerImmediateForcefulShutdown();
        }
    }

    private static void initializeCluster(Arguments arguments, int bundleNumberForDefaultNamespace) throws Exception {
        log.info("Setting up cluster {} with metadata-store={} configuration-metadata-store={}", new Object[]{arguments.cluster, arguments.metadataStoreUrl, arguments.configurationMetadataStore});
        MetadataStoreExtended localStore = PulsarClusterMetadataSetup.initLocalMetadataStore(arguments.metadataStoreUrl, arguments.metadataStoreConfigPath, arguments.zkSessionTimeoutMillis);
        MetadataStoreExtended configStore = PulsarClusterMetadataSetup.initConfigMetadataStore(arguments.configurationMetadataStore, arguments.configurationStoreConfigPath, arguments.zkSessionTimeoutMillis);
        String metadataStoreUrlNoIdentifer = MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)arguments.metadataStoreUrl);
        if (arguments.existingBkMetadataServiceUri == null && arguments.bookieMetadataServiceUri == null) {
            ServerConfiguration bkConf = new ServerConfiguration();
            bkConf.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
            bkConf.setMetadataServiceUri("metadata-store:" + arguments.metadataStoreUrl);
            bkConf.setZkTimeout(arguments.zkSessionTimeoutMillis);
            if (!((Boolean)localStore.exists("/ledgers").get()).booleanValue() && !BookKeeperAdmin.format((ServerConfiguration)bkConf, (boolean)false, (boolean)false)) {
                throw new IOException("Failed to initialize BookKeeper metadata");
            }
        }
        if (localStore instanceof ZKMetadataStore && configStore instanceof ZKMetadataStore) {
            Object uriStr = arguments.existingBkMetadataServiceUri != null ? arguments.existingBkMetadataServiceUri : (arguments.bookieMetadataServiceUri != null ? arguments.bookieMetadataServiceUri : "zk+null://" + metadataStoreUrlNoIdentifer + "/ledgers");
            PulsarClusterMetadataSetup.initialDlogNamespaceMetadata(arguments.configurationMetadataStore, (String)uriStr);
            ServiceURI bkMetadataServiceUri = ServiceURI.create((String)uriStr);
            if (arguments.numStreamStorageContainers > 0) {
                ZkClusterInitializer initializer = new ZkClusterInitializer(metadataStoreUrlNoIdentifer);
                initializer.initializeCluster(bkMetadataServiceUri.getUri(), arguments.numStreamStorageContainers);
            }
        }
        if (!((Boolean)localStore.exists("/bookies").get()).booleanValue()) {
            PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)localStore, "/bookies", "{}".getBytes());
        }
        PulsarResources resources = new PulsarResources(localStore, (MetadataStore)configStore);
        ClusterData.Builder clusterDataBuilder = ClusterData.builder();
        if (arguments.clusterWebServiceUrl != null) {
            clusterDataBuilder.serviceUrl(arguments.clusterWebServiceUrl);
        }
        if (arguments.clusterWebServiceUrlTls != null) {
            clusterDataBuilder.serviceUrlTls(arguments.clusterWebServiceUrlTls);
        }
        if (arguments.clusterBrokerServiceUrl != null) {
            clusterDataBuilder.brokerServiceUrl(arguments.clusterBrokerServiceUrl);
        }
        if (arguments.clusterBrokerServiceUrlTls != null) {
            clusterDataBuilder.brokerServiceUrlTls(arguments.clusterBrokerServiceUrlTls);
        }
        if (arguments.clusterBrokerClientTlsEnabled != null) {
            clusterDataBuilder.brokerClientTlsEnabled(arguments.clusterBrokerClientTlsEnabled.booleanValue());
        }
        if (arguments.clusterAuthenticationPlugin != null) {
            clusterDataBuilder.authenticationPlugin(arguments.clusterAuthenticationPlugin);
        }
        if (arguments.clusterAuthenticationParameters != null) {
            clusterDataBuilder.authenticationParameters(arguments.clusterAuthenticationParameters);
        }
        if (arguments.clusterProxyUrl != null) {
            clusterDataBuilder.proxyServiceUrl(arguments.clusterProxyUrl);
        }
        if (arguments.clusterProxyProtocol != null) {
            clusterDataBuilder.proxyProtocol(arguments.clusterProxyProtocol);
        }
        ClusterData clusterData = clusterDataBuilder.build();
        if (!resources.getClusterResources().clusterExists(arguments.cluster)) {
            resources.getClusterResources().createCluster(arguments.cluster, clusterData);
        }
        ClusterData globalClusterData = ClusterData.builder().build();
        if (!resources.getClusterResources().clusterExists("global")) {
            resources.getClusterResources().createCluster("global", globalClusterData);
        }
        PulsarClusterMetadataSetup.createTenantIfAbsent(resources, "public", arguments.cluster);
        PulsarClusterMetadataSetup.createTenantIfAbsent(resources, NamespaceName.SYSTEM_NAMESPACE.getTenant(), arguments.cluster);
        PulsarClusterMetadataSetup.createNamespaceIfAbsent(resources, NamespaceName.get((String)"public", (String)"default"), arguments.cluster, bundleNumberForDefaultNamespace);
        PulsarClusterMetadataSetup.createNamespaceIfAbsent(resources, NamespaceName.SYSTEM_NAMESPACE, arguments.cluster);
        PulsarClusterMetadataSetup.createPartitionedTopic((MetadataStore)configStore, SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN, arguments.numTransactionCoordinators);
        localStore.close();
        configStore.close();
        log.info("Cluster metadata for '{}' setup correctly", (Object)arguments.cluster);
    }

    public static void createTenantIfAbsent(PulsarResources resources, String tenant, String cluster) throws IOException, InterruptedException, ExecutionException {
        TenantResources tenantResources = resources.getTenantResources();
        if (!tenantResources.tenantExists(tenant)) {
            TenantInfoImpl publicTenant = new TenantInfoImpl(Collections.emptySet(), Collections.singleton(cluster));
            tenantResources.createTenant(tenant, (TenantInfo)publicTenant);
        } else {
            tenantResources.updateTenantAsync(tenant, ti -> {
                ti.getAllowedClusters().add(cluster);
                return ti;
            }).get();
        }
    }

    public static void createNamespaceIfAbsent(PulsarResources resources, NamespaceName namespaceName, String cluster, int bundleNumber) throws IOException {
        NamespaceResources namespaceResources = resources.getNamespaceResources();
        if (!namespaceResources.namespaceExists(namespaceName)) {
            Policies policies2 = new Policies();
            policies2.bundles = PoliciesUtil.getBundles((int)bundleNumber);
            policies2.replication_clusters = Collections.singleton(cluster);
            namespaceResources.createPolicies(namespaceName, policies2);
        } else {
            log.info("Namespace {} already exists.", (Object)namespaceName);
            boolean replicaClusterFound = false;
            Optional policiesOptional = namespaceResources.getPolicies(namespaceName);
            if (policiesOptional.isPresent() && ((Policies)policiesOptional.get()).replication_clusters.contains(cluster)) {
                replicaClusterFound = true;
            }
            if (!replicaClusterFound) {
                namespaceResources.setPolicies(namespaceName, policies -> {
                    policies.replication_clusters.add(cluster);
                    return policies;
                });
                log.info("Updated namespace:{} policies. Added the replication cluster:{}", (Object)namespaceName, (Object)cluster);
            }
        }
    }

    public static void createNamespaceIfAbsent(PulsarResources resources, NamespaceName namespaceName, String cluster) throws IOException {
        PulsarClusterMetadataSetup.createNamespaceIfAbsent(resources, namespaceName, cluster, 16);
    }

    static void createPartitionedTopic(MetadataStore configStore, TopicName topicName, int numPartitions) throws InterruptedException, IOException, ExecutionException {
        PulsarResources resources = new PulsarResources(null, configStore);
        NamespaceResources.PartitionedTopicResources partitionedTopicResources = resources.getNamespaceResources().getPartitionedTopicResources();
        Optional getResult = (Optional)partitionedTopicResources.getPartitionedTopicMetadataAsync(topicName).get();
        if (!getResult.isPresent()) {
            partitionedTopicResources.createPartitionedTopic(topicName, new PartitionedTopicMetadata(numPartitions));
        } else {
            PartitionedTopicMetadata existsMeta = (PartitionedTopicMetadata)getResult.get();
            if (existsMeta.partitions < numPartitions) {
                partitionedTopicResources.updatePartitionedTopicAsync(topicName, __ -> new PartitionedTopicMetadata(numPartitions)).get();
            }
        }
    }

    public static MetadataStoreExtended initLocalMetadataStore(String connection, int sessionTimeout) throws Exception {
        return PulsarClusterMetadataSetup.initLocalMetadataStore(connection, null, sessionTimeout);
    }

    public static MetadataStoreExtended initLocalMetadataStore(String connection, String configPath, int sessionTimeout) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)connection, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeout).configFilePath(configPath).metadataStoreName("metadata-store").build());
        if (store instanceof MetadataStoreLifecycle) {
            ((MetadataStoreLifecycle)store).initializeCluster().get();
        }
        return store;
    }

    public static MetadataStoreExtended initConfigMetadataStore(String connection, int sessionTimeout) throws Exception {
        return PulsarClusterMetadataSetup.initConfigMetadataStore(connection, null, sessionTimeout);
    }

    public static MetadataStoreExtended initConfigMetadataStore(String connection, String configPath, int sessionTimeout) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)connection, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeout).configFilePath(configPath).metadataStoreName("configuration-metadata-store").build());
        if (store instanceof MetadataStoreLifecycle) {
            ((MetadataStoreLifecycle)store).initializeCluster().get();
        }
        return store;
    }

    @CommandLine.Command(name="initialize-cluster-metadata", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
    private static class Arguments {
        @CommandLine.Option(names={"-c", "--cluster"}, description={"Cluster name"}, required=true)
        private String cluster;
        @CommandLine.Option(names={"-bn", "--default-namespace-bundle-number"}, description={"The bundle numbers for the default namespaces(public/default), default is 16"}, required=false)
        private int numberOfDefaultNamespaceBundles;
        @CommandLine.Option(names={"-uw", "--web-service-url"}, description={"Web-service URL for new cluster"}, required=true)
        private String clusterWebServiceUrl;
        @CommandLine.Option(names={"-tw", "--web-service-url-tls"}, description={"Web-service URL for new cluster with TLS encryption"}, required=false)
        private String clusterWebServiceUrlTls;
        @CommandLine.Option(names={"-ub", "--broker-service-url"}, description={"Broker-service URL for new cluster"}, required=false)
        private String clusterBrokerServiceUrl;
        @CommandLine.Option(names={"-tb", "--broker-service-url-tls"}, description={"Broker-service URL for new cluster with TLS encryption"}, required=false)
        private String clusterBrokerServiceUrlTls;
        @CommandLine.Option(names={"-te", "--tls-enable"}, description={"Enable TLS connection for new cluster"})
        private Boolean clusterBrokerClientTlsEnabled;
        @CommandLine.Option(names={"--auth-plugin"}, description={"The authentication plugin for new cluster"})
        protected String clusterAuthenticationPlugin;
        @CommandLine.Option(names={"--auth-parameters"}, description={"The authentication parameters for new cluster"})
        protected String clusterAuthenticationParameters;
        @CommandLine.Option(names={"-zk", "--zookeeper"}, description={"Local ZooKeeper quorum connection string"}, required=false, hidden=true)
        private String zookeeper;
        @CommandLine.Option(names={"-md", "--metadata-store"}, description={"Metadata Store service url. eg: zk:my-zk:2181"}, required=false)
        private String metadataStoreUrl;
        @CommandLine.Option(names={"--zookeeper-session-timeout-ms"}, description={"Local zookeeper session timeout ms"})
        private int zkSessionTimeoutMillis = 30000;
        @CommandLine.Option(names={"-gzk", "--global-zookeeper"}, description={"Global ZooKeeper quorum connection string"}, required=false, hidden=true)
        private String globalZookeeper;
        @CommandLine.Option(names={"-cs", "--configuration-store"}, description={"Configuration Store connection string"}, hidden=true)
        private String configurationStore;
        @CommandLine.Option(names={"-cms", "--configuration-metadata-store"}, description={"Configuration Metadata Store connection string"}, hidden=false)
        private String configurationMetadataStore;
        @CommandLine.Option(names={"-mscp", "--metadata-store-config-path"}, description={"Metadata Store config path"}, hidden=false)
        private String metadataStoreConfigPath;
        @CommandLine.Option(names={"-cmscp", "--configuration-metadata-store-config-path"}, description={"Configuration Metadata Store config path"}, hidden=false)
        private String configurationStoreConfigPath;
        @CommandLine.Option(names={"--initial-num-stream-storage-containers"}, description={"Num storage containers of BookKeeper stream storage"})
        private int numStreamStorageContainers = 16;
        @CommandLine.Option(names={"--initial-num-transaction-coordinators"}, description={"Num transaction coordinators will assigned in cluster"})
        private int numTransactionCoordinators = 16;
        @CommandLine.Option(names={"--existing-bk-metadata-service-uri"}, description={"The metadata service URI of the existing BookKeeper cluster that you want to use"})
        private String existingBkMetadataServiceUri;
        @Deprecated
        @CommandLine.Option(names={"--bookkeeper-metadata-service-uri"}, description={"The metadata service URI of the existing BookKeeper cluster that you want to use"}, hidden=true)
        private String bookieMetadataServiceUri;
        @CommandLine.Option(names={"-pp", "--proxy-protocol"}, description={"Proxy protocol to select type of routing at proxy. Possible Values: [SNI]"}, required=false)
        private ProxyProtocol clusterProxyProtocol;
        @CommandLine.Option(names={"-pu", "--proxy-url"}, description={"Proxy-server URL to which to connect."}, required=false)
        private String clusterProxyUrl;
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

