/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.grpc;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.TlsChannelCredentials;
import io.grpc.stub.StreamObserver;
import io.oxia.client.ClientConfig;
import io.oxia.client.api.Authentication;
import io.oxia.proto.CloseSessionRequest;
import io.oxia.proto.CloseSessionResponse;
import io.oxia.proto.OxiaClientGrpc;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxiaStub
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OxiaStub.class);
    public static String TLS_SCHEMA = "tls://";
    private final ManagedChannel channel;
    @NonNull
    private final OxiaClientGrpc.OxiaClientStub asyncStub;

    static String getAddress(String address) {
        if (address.startsWith(TLS_SCHEMA)) {
            return address.substring(TLS_SCHEMA.length());
        }
        return address;
    }

    static ChannelCredentials getChannelCredential(String address, boolean tlsEnabled) {
        return tlsEnabled || address.startsWith(TLS_SCHEMA) ? TlsChannelCredentials.newBuilder().build() : InsecureChannelCredentials.create();
    }

    public OxiaStub(String address, ClientConfig clientConfig) {
        this(Grpc.newChannelBuilder((String)OxiaStub.getAddress(address), (ChannelCredentials)OxiaStub.getChannelCredential(address, clientConfig.enableTls())).keepAliveTime(clientConfig.connectionKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(clientConfig.connectionKeepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(true).disableRetry().directExecutor().build(), clientConfig.authentication());
    }

    public OxiaStub(ManagedChannel channel) {
        this(channel, null);
    }

    public OxiaStub(ManagedChannel channel, final @Nullable Authentication authentication) {
        this.channel = channel;
        this.asyncStub = authentication != null ? (OxiaClientGrpc.OxiaClientStub)((OxiaClientGrpc.OxiaClientStub)((OxiaClientGrpc.OxiaClientStub)OxiaClientGrpc.newStub((Channel)channel).withMaxInboundMessageSize(0x10000000)).withMaxOutboundMessageSize(0x10000000)).withCallCredentials(new CallCredentials(){

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                Metadata credentials = new Metadata();
                authentication.generateCredentials().forEach((key, value) -> credentials.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), value));
                applier.apply(credentials);
            }
        }) : (OxiaClientGrpc.OxiaClientStub)((OxiaClientGrpc.OxiaClientStub)OxiaClientGrpc.newStub((Channel)channel).withMaxInboundMessageSize(0x10000000)).withMaxOutboundMessageSize(0x10000000);
    }

    public OxiaClientGrpc.OxiaClientStub async() {
        return this.asyncStub;
    }

    public CompletableFuture<CloseSessionResponse> closeSession(CloseSessionRequest request) {
        final CompletableFuture<CloseSessionResponse> f = new CompletableFuture<CloseSessionResponse>();
        StreamObserver<CloseSessionResponse> defer = new StreamObserver<CloseSessionResponse>(){
            private CloseSessionResponse response;

            public void onNext(CloseSessionResponse response) {
                this.response = response;
            }

            public void onError(Throwable t) {
                f.completeExceptionally(t);
            }

            public void onCompleted() {
                f.complete(this.response);
            }
        };
        try {
            this.asyncStub.closeSession(request, defer);
        }
        catch (Throwable ex) {
            f.completeExceptionally(ex);
        }
        return f;
    }

    @Override
    public void close() throws Exception {
        this.channel.shutdown();
        try {
            if (!this.channel.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.channel.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.channel.shutdownNow();
        }
    }
}

