/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.remotetask;

import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerInfo;
import io.trino.execution.LocationFactory;
import io.trino.execution.TaskId;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.server.InternalCommunicationConfig;
import io.trino.spi.QueryId;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;

public class HttpLocationFactory
implements LocationFactory {
    private final InternalNodeManager nodeManager;
    private final URI baseUri;

    @Inject
    public HttpLocationFactory(InternalNodeManager nodeManager, HttpServerInfo httpServerInfo, InternalCommunicationConfig config) {
        this(nodeManager, config.isHttpsRequired() ? httpServerInfo.getHttpsUri() : httpServerInfo.getHttpUri());
    }

    public HttpLocationFactory(InternalNodeManager nodeManager, URI baseUri) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.baseUri = Objects.requireNonNull(baseUri, "baseUri is null");
    }

    @Override
    public URI createQueryLocation(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("/v1/query").appendPath(queryId.toString()).build();
    }

    @Override
    public URI createLocalTaskLocation(TaskId taskId) {
        return this.createTaskLocation(this.nodeManager.getCurrentNode(), taskId);
    }

    @Override
    public URI createTaskLocation(InternalNode node, TaskId taskId) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(taskId, "taskId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath("/v1/task").appendPath(taskId.toString()).build();
    }

    @Override
    public URI createMemoryInfoLocation(InternalNode node) {
        Objects.requireNonNull(node, "node is null");
        return HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath("/v1/memory").build();
    }
}

