/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.VarianceState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;

@AggregationFunction
public final class VarianceAggregation {
    private VarianceAggregation() {
    }

    @InputFunction
    public static void doubleInput(@AggregationState VarianceState state, @SqlType(value="double") double value) {
        state.update(value);
    }

    @InputFunction
    public static void bigintInput(@AggregationState VarianceState state, @SqlType(value="bigint") long value) {
        state.update(value);
    }

    @CombineFunction
    public static void combine(@AggregationState VarianceState state, @AggregationState VarianceState otherState) {
        state.merge(otherState);
    }

    @AggregationFunction(value="variance", alias={"var_samp"})
    @Description(value="Returns the sample variance of the argument")
    @OutputFunction(value="double")
    public static void variance(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count < 2L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)(count - 1L);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="var_pop")
    @Description(value="Returns the population variance of the argument")
    @OutputFunction(value="double")
    public static void variancePop(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count == 0L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)count;
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="stddev", alias={"stddev_samp"})
    @Description(value="Returns the sample standard deviation of the argument")
    @OutputFunction(value="double")
    public static void stddev(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count < 2L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)(count - 1L);
            result = Math.sqrt(result);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="stddev_pop")
    @Description(value="Returns the population standard deviation of the argument")
    @OutputFunction(value="double")
    public static void stddevPop(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count == 0L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)count;
            result = Math.sqrt(result);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

