/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchBuilder;
import com.yahoo.sketches.quantiles.DoublesUnion;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.StampedLock;

class ThreadLocalAccessor {
    private final ConcurrentHashMap<LocalData, Boolean> map = new ConcurrentHashMap();
    private final FastThreadLocal<LocalData> localData = new FastThreadLocal<LocalData>(){

        protected LocalData initialValue() {
            LocalData localData = new LocalData(Thread.currentThread());
            ThreadLocalAccessor.this.map.put(localData, Boolean.TRUE);
            return localData;
        }

        protected void onRemoval(LocalData value) {
            ThreadLocalAccessor.this.map.remove(value);
        }
    };

    ThreadLocalAccessor() {
    }

    void record(DoublesUnion aggregateSuccess, DoublesUnion aggregateFail) {
        ((ConcurrentHashMap.KeySetView)this.map.keySet()).forEach(key -> {
            key.record(aggregateSuccess, aggregateFail);
            if (key.shouldRemove()) {
                this.map.remove(key);
            }
        });
    }

    LocalData getLocalData() {
        return (LocalData)this.localData.get();
    }

    @VisibleForTesting
    int getLocalDataCount() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).size();
    }

    static class LocalData {
        private final DoublesSketch successSketch = new DoublesSketchBuilder().build();
        private final DoublesSketch failSketch = new DoublesSketchBuilder().build();
        private final StampedLock lock = new StampedLock();
        private final WeakReference<Thread> ownerThreadReference;

        LocalData(Thread ownerThread) {
            this.ownerThreadReference = ownerThread instanceof FastThreadLocalThread ? null : new WeakReference<Thread>(ownerThread);
        }

        private boolean shouldRemove() {
            if (this.ownerThreadReference == null) {
                return false;
            }
            Thread ownerThread = (Thread)this.ownerThreadReference.get();
            if (ownerThread == null) {
                return true;
            }
            return !ownerThread.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void record(DoublesUnion aggregateSuccess, DoublesUnion aggregateFail) {
            long stamp = this.lock.writeLock();
            try {
                aggregateSuccess.update(this.successSketch);
                this.successSketch.reset();
                if (aggregateFail != null) {
                    aggregateFail.update(this.failSketch);
                    this.failSketch.reset();
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSuccess(double value) {
            long stamp = this.lock.readLock();
            try {
                this.successSketch.update(value);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateFail(double value) {
            long stamp = this.lock.readLock();
            try {
                this.failSketch.update(value);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
    }
}

