/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPRightsManagementSchema;
import org.apache.xmpbox.type.AbstractField;
import org.apache.xmpbox.type.ArrayProperty;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.type.BooleanType;
import org.apache.xmpbox.type.TextType;

public class FontMetaDataValidation {
    public List<ValidationResult.ValidationError> validatePDFAIdentifer(XMPMetadata metadata, PDFontDescriptor fontDesc) throws ValidationException {
        ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
        this.analyseFontName(metadata, fontDesc, ve);
        this.analyseRights(metadata, fontDesc, ve);
        return ve;
    }

    public boolean analyseFontName(XMPMetadata metadata, PDFontDescriptor fontDesc, List<ValidationResult.ValidationError> ve) {
        DublinCoreSchema dc;
        String fontName;
        String noSubSetName = fontName = fontDesc.getFontName();
        if (FontDescriptorHelper.isSubSet(fontName)) {
            noSubSetName = fontName.split("\\+")[1];
        }
        if ((dc = metadata.getDublinCoreSchema()) != null && dc.getTitleProperty() != null) {
            String defaultTitle;
            try {
                defaultTitle = dc.getTitle("x-default");
            }
            catch (BadFieldValueException badFieldValueException) {
                ve.add(new ValidationResult.ValidationError("7.1.2", "Title property of XMP information is not a multi-lingual property"));
                return false;
            }
            if (defaultTitle != null) {
                if (!defaultTitle.equals(fontName) && noSubSetName != null && !defaultTitle.equals(noSubSetName)) {
                    ve.add(new ValidationResult.ValidationError("7.2", "FontName present in the FontDescriptor dictionary doesn't match with XMP information dc:title of the Font File Stream."));
                    return false;
                }
                return true;
            }
            Iterator<AbstractField> it = dc.getTitleProperty().getContainer().getAllProperties().iterator();
            boolean empty = true;
            while (it.hasNext()) {
                String val;
                empty = false;
                AbstractField tmp = it.next();
                if (!(tmp instanceof TextType) || !(val = ((TextType)tmp).getStringValue()).equals(fontName) && !val.equals(noSubSetName)) continue;
                return true;
            }
            if (empty) {
                ve.add(new ValidationResult.ValidationError("7.5", "FontName present in the FontDescriptor dictionary can't be found in XMP information the Font File Stream."));
            } else {
                ve.add(new ValidationResult.ValidationError("7.2", "FontName present in the FontDescriptor dictionary doesn't match with XMP information dc:title of the Font File Stream."));
            }
            return false;
        }
        return true;
    }

    public boolean analyseRights(XMPMetadata metadata, PDFontDescriptor fontDesc, List<ValidationResult.ValidationError> ve) {
        BooleanType marked;
        ArrayProperty copyrights;
        DublinCoreSchema dc = metadata.getDublinCoreSchema();
        if (dc != null && ((copyrights = dc.getRightsProperty()) == null || copyrights.getContainer() == null || copyrights.getContainer().getAllProperties().isEmpty())) {
            ve.add(new ValidationResult.ValidationError("7.5", "CopyRights is missing from the XMP information (dc:rights) of the Font File Stream."));
            return false;
        }
        XMPRightsManagementSchema rights = metadata.getXMPRightsManagementSchema();
        if (rights != null && (marked = rights.getMarkedProperty()) != null && !marked.getValue().booleanValue()) {
            ve.add(new ValidationResult.ValidationError("7.5", "the XMP information (xmpRights:Marked) is invalid for the Font File Stream."));
            return false;
        }
        return true;
    }
}

