/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.content;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetLineCapStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineDashPattern;
import org.apache.pdfbox.contentstream.operator.state.SetLineJoinStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineWidth;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.contentstream.operator.text.BeginText;
import org.apache.pdfbox.contentstream.operator.text.EndText;
import org.apache.pdfbox.contentstream.operator.text.MoveText;
import org.apache.pdfbox.contentstream.operator.text.MoveTextSetLeading;
import org.apache.pdfbox.contentstream.operator.text.NextLine;
import org.apache.pdfbox.contentstream.operator.text.SetCharSpacing;
import org.apache.pdfbox.contentstream.operator.text.SetFontAndSize;
import org.apache.pdfbox.contentstream.operator.text.SetTextHorizontalScaling;
import org.apache.pdfbox.contentstream.operator.text.SetTextLeading;
import org.apache.pdfbox.contentstream.operator.text.SetTextRenderingMode;
import org.apache.pdfbox.contentstream.operator.text.SetTextRise;
import org.apache.pdfbox.contentstream.operator.text.SetWordSpacing;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.content.StubOperator;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.utils.FilterHelper;
import org.apache.pdfbox.preflight.utils.RenderingIntents;

public abstract class PreflightStreamEngine
extends PDFStreamEngine {
    protected PreflightContext context = null;
    protected PDPage processedPage = null;

    public PreflightStreamEngine(PreflightContext context, PDPage page) {
        this.context = context;
        this.processedPage = page;
        this.addOperator(new SetLineWidth(this));
        this.addOperator(new Concatenate(this));
        this.addOperator(new SetStrokingColorSpace(this));
        this.addOperator(new SetNonStrokingColorSpace(this));
        this.addOperator(new SetLineDashPattern(this));
        this.addOperator(new DrawObject(this));
        this.addOperator(new SetLineJoinStyle(this));
        this.addOperator(new SetLineCapStyle(this));
        this.addOperator(new SetStrokingDeviceCMYKColor(this));
        this.addOperator(new SetNonStrokingDeviceCMYKColor(this));
        this.addOperator(new SetNonStrokingDeviceRGBColor(this));
        this.addOperator(new SetStrokingDeviceRGBColor(this));
        this.addOperator(new SetNonStrokingDeviceGrayColor(this));
        this.addOperator(new SetStrokingDeviceGrayColor(this));
        this.addOperator(new SetStrokingColor(this));
        this.addOperator(new SetStrokingColorN(this));
        this.addOperator(new SetNonStrokingColor(this));
        this.addOperator(new SetNonStrokingColorN(this));
        this.addOperator(new Restore(this));
        this.addOperator(new Save(this));
        this.addOperator(new BeginText(this));
        this.addOperator(new EndText(this));
        this.addOperator(new SetGraphicsStateParameters(this));
        this.addOperator(new SetFontAndSize(this));
        this.addOperator(new SetTextRenderingMode(this));
        this.addOperator(new SetMatrix(this));
        this.addOperator(new MoveText(this));
        this.addOperator(new NextLine(this));
        this.addOperator(new MoveTextSetLeading(this));
        this.addOperator(new SetCharSpacing(this));
        this.addOperator(new SetTextLeading(this));
        this.addOperator(new SetTextRise(this));
        this.addOperator(new SetWordSpacing(this));
        this.addOperator(new SetTextHorizontalScaling(this));
        this.addOperator(new StubOperator(this, "l"));
        this.addOperator(new StubOperator(this, "re"));
        this.addOperator(new StubOperator(this, "c"));
        this.addOperator(new StubOperator(this, "y"));
        this.addOperator(new StubOperator(this, "v"));
        this.addOperator(new StubOperator(this, "n"));
        this.addOperator(new StubOperator(this, "BI"));
        this.addOperator(new StubOperator(this, "ID"));
        this.addOperator(new StubOperator(this, "EI"));
        this.addOperator(new StubOperator(this, "m"));
        this.addOperator(new StubOperator(this, "W*"));
        this.addOperator(new StubOperator(this, "W"));
        this.addOperator(new StubOperator(this, "h"));
        this.addOperator(new StubOperator(this, "Tj"));
        this.addOperator(new StubOperator(this, "TJ"));
        this.addOperator(new StubOperator(this, "'"));
        this.addOperator(new StubOperator(this, "\""));
        this.addOperator(new StubOperator(this, "b"));
        this.addOperator(new StubOperator(this, "B"));
        this.addOperator(new StubOperator(this, "b*"));
        this.addOperator(new StubOperator(this, "B*"));
        this.addOperator(new StubOperator(this, "BDC"));
        this.addOperator(new StubOperator(this, "BMC"));
        this.addOperator(new StubOperator(this, "DP"));
        this.addOperator(new StubOperator(this, "EMC"));
        this.addOperator(new StubOperator(this, "BX"));
        this.addOperator(new StubOperator(this, "EX"));
        this.addOperator(new StubOperator(this, "d0"));
        this.addOperator(new StubOperator(this, "d1"));
        this.addOperator(new StubOperator(this, "f"));
        this.addOperator(new StubOperator(this, "F"));
        this.addOperator(new StubOperator(this, "f*"));
        this.addOperator(new StubOperator(this, "M"));
        this.addOperator(new StubOperator(this, "MP"));
        this.addOperator(new StubOperator(this, "i"));
        this.addOperator(new StubOperator(this, "ri"));
        this.addOperator(new StubOperator(this, "s"));
        this.addOperator(new StubOperator(this, "S"));
        this.addOperator(new StubOperator(this, "sh"));
    }

    protected void validateRenderingIntent(Operator operator, List<COSBase> arguments) throws ContentStreamException {
        if ("ri".equals(operator.getName()) && arguments.get(0) instanceof COSName && !RenderingIntents.contains((COSName)arguments.get(0))) {
            this.registerError("Unexpected value '" + arguments.get(0) + "' for ri operand. ", "2.3.2");
        }
    }

    protected void validateNumberOfGraphicStates(Operator operator) {
        int numberOfGraphicStates;
        if ("q".equals(operator.getName()) && (numberOfGraphicStates = this.getGraphicsStackSize()) > 28) {
            this.registerError("Too many graphic states", "2.1.8");
        }
    }

    protected void validateInlineImageFilter(Operator operator) {
        COSDictionary dict = operator.getImageParameters();
        COSBase filter = dict.getDictionaryObject(COSName.F, COSName.FILTER);
        FilterHelper.isAuthorizedFilter(this.context, filter instanceof COSName ? ((COSName)filter).getName() : null);
    }

    protected void validateInlineImageColorSpace(Operator operator) throws IOException {
        COSDictionary dict = operator.getImageParameters();
        COSBase csInlinedBase = dict.getDictionaryObject(COSName.CS, COSName.COLORSPACE);
        ColorSpaceHelper csHelper = null;
        if (csInlinedBase != null) {
            if (csInlinedBase instanceof COSName) {
                ColorSpaces cs;
                String colorSpace;
                block7: {
                    colorSpace = ((COSName)csInlinedBase).getName();
                    cs = null;
                    try {
                        cs = ColorSpaces.valueOf(colorSpace);
                    }
                    catch (IllegalArgumentException e) {
                        PDColorSpace pdCS = this.getResources().getColorSpace(COSName.getPDFName(colorSpace));
                        if (pdCS == null) break block7;
                        cs = ColorSpaces.valueOf(pdCS.getName());
                        csHelper = this.getColorSpaceHelper(pdCS);
                    }
                }
                if (cs == null) {
                    this.registerError("The ColorSpace " + colorSpace + " is unknown", "2.3.2");
                    return;
                }
            }
            if (csHelper == null) {
                COSArray srcArray;
                COSBase csType;
                if ((csInlinedBase = this.toLongName(csInlinedBase)) instanceof COSArray && ((COSArray)csInlinedBase).size() > 1 && (COSName.I.equals(csType = (srcArray = (COSArray)csInlinedBase).get(0)) || COSName.INDEXED.equals(csType))) {
                    COSArray dstArray = new COSArray();
                    dstArray.addAll(srcArray);
                    dstArray.set(0, COSName.INDEXED);
                    dstArray.set(1, this.toLongName(srcArray.get(1)));
                    csInlinedBase = dstArray;
                }
                PDColorSpace pdCS = PDColorSpace.create(csInlinedBase);
                csHelper = this.getColorSpaceHelper(pdCS);
            }
            csHelper.validate();
        }
    }

    private ColorSpaceHelper getColorSpaceHelper(PDColorSpace pdCS) {
        PreflightConfiguration cfg = this.context.getConfig();
        ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
        return csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.ONLY_DEVICE);
    }

    private COSBase toLongName(COSBase cs) {
        if (COSName.RGB.equals(cs)) {
            return COSName.DEVICERGB;
        }
        if (COSName.CMYK.equals(cs)) {
            return COSName.DEVICECMYK;
        }
        if (COSName.G.equals(cs)) {
            return COSName.DEVICEGRAY;
        }
        return cs;
    }

    protected void checkColorOperators(String operation) throws ContentStreamException {
        PDColorSpace cs = this.getColorSpace(operation);
        if (("rg".equals(operation) || "RG".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.RGB)) {
            this.registerError("The operator \"" + operation + "\" can't be used without RGB Color Profile", "2.4.1");
            return;
        }
        if (("k".equals(operation) || "K".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.CMYK)) {
            this.registerError("The operator \"" + operation + "\" can't be used without CMYK Color Profile", "2.4.2");
            return;
        }
        if (("g".equals(operation) || "G".equals(operation) || "f".equals(operation) || "F".equals(operation) || "f*".equals(operation) || "B".equals(operation) || "B*".equals(operation) || "b".equals(operation) || "b*".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.ALL)) {
            this.registerError("The operator \"" + operation + "\" can't be used without Color Profile", "2.4.3");
        }
    }

    void validateDefaultColorSpace(Operator operator) throws ContentStreamException {
        boolean v = false;
        String op = operator.getName();
        if ("Tj".equals(op) || "TJ".equals(op) || "'".equals(op) || "\"".equals(op)) {
            RenderingMode rm = this.getGraphicsState().getTextState().getRenderingMode();
            if (rm.isFill() && this.getGraphicsState().getNonStrokingColor().getColorSpace() instanceof PDDeviceGray) {
                v = true;
            }
            if (rm.isStroke() && this.getGraphicsState().getStrokingColor().getColorSpace() instanceof PDDeviceGray) {
                v = true;
            }
        }
        if (("f".equals(op) || "F".equals(op) || "f*".equals(op) || "B".equals(op) || "B*".equals(op) || "b".equals(op) || "b*".equals(op)) && this.getGraphicsState().getNonStrokingColor().getColorSpace() instanceof PDDeviceGray) {
            v = true;
        }
        if (("B".equals(op) || "B*".equals(op) || "b".equals(op) || "b*".equals(op) || "s".equals(op) || "S".equals(op)) && this.getGraphicsState().getStrokingColor().getColorSpace() instanceof PDDeviceGray) {
            v = true;
        }
        if (v && !this.validColorSpaceDestOutputProfile(ColorSpaceType.ALL)) {
            this.registerError("/DeviceGray default for operator \"" + op + "\" can't be used without Color Profile", "2.4.3");
        }
    }

    private boolean validColorSpace(PDColorSpace colorSpace, ColorSpaceType expectedIccType) throws ContentStreamException {
        if (colorSpace == null) {
            return this.validColorSpaceDestOutputProfile(expectedIccType);
        }
        return this.isDeviceIndependent(colorSpace, expectedIccType) || this.validColorSpaceDestOutputProfile(expectedIccType);
    }

    private boolean validColorSpaceDestOutputProfile(ColorSpaceType expectedType) throws ContentStreamException {
        try {
            ICCProfileWrapper profileWrapper = ICCProfileWrapper.getOrSearchICCProfile(this.context);
            if (profileWrapper == null) {
                return false;
            }
            switch (expectedType) {
                case RGB: {
                    return profileWrapper.isRGBColorSpace();
                }
                case CMYK: {
                    return profileWrapper.isCMYKColorSpace();
                }
            }
            return true;
        }
        catch (ValidationException e) {
            throw new ContentStreamException(e);
        }
    }

    private boolean isDeviceIndependent(PDColorSpace cs, ColorSpaceType expectedIccType) {
        if (cs instanceof PDICCBased) {
            int type = ((PDICCBased)cs).getColorSpaceType();
            switch (expectedIccType) {
                case RGB: {
                    return type == 5;
                }
                case CMYK: {
                    return type == 9;
                }
            }
            return true;
        }
        if (cs instanceof PDSeparation) {
            return this.isDeviceIndependent(((PDSeparation)cs).getAlternateColorSpace(), expectedIccType);
        }
        return cs instanceof PDCIEBasedColorSpace;
    }

    private PDColorSpace getColorSpace(String operation) {
        if (this.getGraphicsState() == null) {
            return null;
        }
        if (operation.equals("rg") || operation.equals("g") || operation.equals("k") || operation.equals("f") || operation.equals("F") || operation.equals("f*")) {
            return this.getGraphicsState().getNonStrokingColorSpace();
        }
        return this.getGraphicsState().getStrokingColorSpace();
    }

    protected void checkSetColorSpaceOperators(Operator operator, List<COSBase> arguments) throws IOException {
        ColorSpaces cs;
        ColorSpaceHelper csHelper;
        String colorSpaceName;
        block9: {
            if (!"CS".equals(operator.getName()) && !"cs".equals(operator.getName())) {
                return;
            }
            if (arguments.get(0) instanceof COSString) {
                colorSpaceName = arguments.get(0).toString();
            } else if (arguments.get(0) instanceof COSName) {
                colorSpaceName = ((COSName)arguments.get(0)).getName();
            } else {
                this.registerError("The operand " + arguments.get(0) + " for colorSpace operator " + operator.getName() + " doesn't have the expected type", "2.3.2");
                return;
            }
            csHelper = null;
            cs = null;
            try {
                cs = ColorSpaces.valueOf(colorSpaceName);
            }
            catch (IllegalArgumentException e) {
                PDColorSpace pdCS = this.getResources().getColorSpace(COSName.getPDFName(colorSpaceName));
                if (pdCS == null) break block9;
                cs = ColorSpaces.valueOf(pdCS.getName());
                PreflightConfiguration cfg = this.context.getConfig();
                ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
                csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
            }
        }
        if (cs == null) {
            this.registerError("The ColorSpace " + colorSpaceName + " is unknown", "2.3.2");
            return;
        }
        if (csHelper == null) {
            PDColorSpace pdCS = PDColorSpace.create(COSName.getPDFName(colorSpaceName));
            PreflightConfiguration cfg = this.context.getConfig();
            ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
            csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
        }
        csHelper.validate();
    }

    protected void registerError(String msg, String errorCode) {
        this.registerError(msg, errorCode, null);
    }

    public void registerError(String msg, String errorCode, Throwable cause) {
        this.registerError(msg, errorCode, false, cause);
    }

    protected void registerError(String msg, String errorCode, boolean warning) {
        this.registerError(msg, errorCode, warning, null);
    }

    public void registerError(String msg, String errorCode, boolean warning, Throwable cause) {
        ValidationResult.ValidationError error = new ValidationResult.ValidationError(errorCode, msg, cause);
        error.setWarning(warning);
        this.context.addValidationError(error);
    }

    private static enum ColorSpaceType {
        RGB,
        CMYK,
        ALL;

    }
}

