/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.util.StringUtils;
import org.apache.ozone.fs.http.HttpFSConstants;
import org.apache.ozone.fs.http.server.HttpFSServerWebApp;
import org.apache.ozone.lib.service.FileSystemAccess;
import org.apache.ozone.lib.wsrs.BooleanParam;
import org.apache.ozone.lib.wsrs.EnumParam;
import org.apache.ozone.lib.wsrs.EnumSetParam;
import org.apache.ozone.lib.wsrs.LongParam;
import org.apache.ozone.lib.wsrs.Param;
import org.apache.ozone.lib.wsrs.ParametersProvider;
import org.apache.ozone.lib.wsrs.ShortParam;
import org.apache.ozone.lib.wsrs.StringParam;

@InterfaceAudience.Private
public class HttpFSParametersProvider
extends ParametersProvider {
    private static final Map<Enum, Class<Param<?>>[]> PARAMS_DEF = new HashMap<Enum, Class<Param<?>>[]>();

    public HttpFSParametersProvider() {
        super("op", HttpFSConstants.Operation.class, PARAMS_DEF);
    }

    static {
        PARAMS_DEF.put(HttpFSConstants.Operation.OPEN, new Class[]{OffsetParam.class, LenParam.class, NoRedirectParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETFILESTATUS, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.LISTSTATUS, new Class[]{FilterParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETHOMEDIRECTORY, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.GETCONTENTSUMMARY, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.GETQUOTAUSAGE, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.GETFILECHECKSUM, new Class[]{NoRedirectParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETFILEBLOCKLOCATIONS, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.GETACLSTATUS, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.GETTRASHROOT, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.INSTRUMENTATION, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.APPEND, new Class[]{DataParam.class, NoRedirectParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.CONCAT, new Class[]{SourcesParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.TRUNCATE, new Class[]{NewLengthParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.CREATE, new Class[]{PermissionParam.class, OverwriteParam.class, ReplicationParam.class, BlockSizeParam.class, DataParam.class, UnmaskedPermissionParam.class, NoRedirectParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.MKDIRS, new Class[]{PermissionParam.class, UnmaskedPermissionParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.RENAME, new Class[]{DestinationParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.SETOWNER, new Class[]{OwnerParam.class, GroupParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.SETPERMISSION, new Class[]{PermissionParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.SETREPLICATION, new Class[]{ReplicationParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.SETTIMES, new Class[]{ModifiedTimeParam.class, AccessTimeParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.DELETE, new Class[]{RecursiveParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.SETACL, new Class[]{AclPermissionParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.REMOVEACL, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.MODIFYACLENTRIES, new Class[]{AclPermissionParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.REMOVEACLENTRIES, new Class[]{AclPermissionParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.REMOVEDEFAULTACL, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.SETXATTR, new Class[]{XAttrNameParam.class, XAttrValueParam.class, XAttrSetFlagParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.REMOVEXATTR, new Class[]{XAttrNameParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETXATTRS, new Class[]{XAttrNameParam.class, XAttrEncodingParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.LISTXATTRS, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.LISTSTATUS_BATCH, new Class[]{StartAfterParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETALLSTORAGEPOLICY, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.GETSTORAGEPOLICY, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.SETSTORAGEPOLICY, new Class[]{PolicyNameParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.UNSETSTORAGEPOLICY, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.ALLOWSNAPSHOT, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.DISALLOWSNAPSHOT, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.CREATESNAPSHOT, new Class[]{SnapshotNameParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.DELETESNAPSHOT, new Class[]{SnapshotNameParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.RENAMESNAPSHOT, new Class[]{OldSnapshotNameParam.class, SnapshotNameParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETSNAPSHOTDIFF, new Class[]{OldSnapshotNameParam.class, SnapshotNameParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETSNAPSHOTTABLEDIRECTORYLIST, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.GETSERVERDEFAULTS, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.CHECKACCESS, new Class[]{FsActionParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.SETECPOLICY, new Class[]{ECPolicyParam.class});
        PARAMS_DEF.put(HttpFSConstants.Operation.GETECPOLICY, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.UNSETECPOLICY, new Class[0]);
        PARAMS_DEF.put(HttpFSConstants.Operation.SATISFYSTORAGEPOLICY, new Class[0]);
    }

    @InterfaceAudience.Private
    public static class OffsetParam
    extends LongParam {
        public static final String NAME = "offset";

        public OffsetParam() {
            super(NAME, 0L);
        }
    }

    @InterfaceAudience.Private
    public static class LenParam
    extends LongParam {
        public static final String NAME = "length";

        public LenParam() {
            super(NAME, -1L);
        }
    }

    @InterfaceAudience.Private
    public static class NoRedirectParam
    extends BooleanParam {
        public static final String NAME = "noredirect";

        public NoRedirectParam() {
            super(NAME, false);
        }
    }

    @InterfaceAudience.Private
    public static class FilterParam
    extends StringParam {
        public static final String NAME = "filter";

        public FilterParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class DataParam
    extends BooleanParam {
        public static final String NAME = "data";

        public DataParam() {
            super(NAME, false);
        }
    }

    @InterfaceAudience.Private
    public static class SourcesParam
    extends StringParam {
        public static final String NAME = "sources";

        public SourcesParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class NewLengthParam
    extends LongParam {
        public static final String NAME = "newlength";

        public NewLengthParam() {
            super(NAME, 0L);
        }
    }

    @InterfaceAudience.Private
    public static class PermissionParam
    extends ShortParam {
        public static final String NAME = "permission";

        public PermissionParam() {
            super(NAME, HttpFSConstants.DEFAULT_PERMISSION, 8);
        }
    }

    @InterfaceAudience.Private
    public static class OverwriteParam
    extends BooleanParam {
        public static final String NAME = "overwrite";

        public OverwriteParam() {
            super(NAME, true);
        }
    }

    @InterfaceAudience.Private
    public static class ReplicationParam
    extends ShortParam {
        public static final String NAME = "replication";

        public ReplicationParam() {
            super(NAME, (short)-1);
        }
    }

    @InterfaceAudience.Private
    public static class BlockSizeParam
    extends LongParam {
        public static final String NAME = "blocksize";

        public BlockSizeParam() {
            super(NAME, -1L);
        }
    }

    @InterfaceAudience.Private
    public static class UnmaskedPermissionParam
    extends ShortParam {
        public static final String NAME = "unmaskedpermission";

        public UnmaskedPermissionParam() {
            super(NAME, (short)-1, 8);
        }
    }

    @InterfaceAudience.Private
    public static class DestinationParam
    extends StringParam {
        public static final String NAME = "destination";

        public DestinationParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class OwnerParam
    extends StringParam {
        public static final String NAME = "owner";

        public OwnerParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class GroupParam
    extends StringParam {
        public static final String NAME = "group";

        public GroupParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class ModifiedTimeParam
    extends LongParam {
        public static final String NAME = "modificationtime";

        public ModifiedTimeParam() {
            super(NAME, -1L);
        }
    }

    @InterfaceAudience.Private
    public static class AccessTimeParam
    extends LongParam {
        public static final String NAME = "accesstime";

        public AccessTimeParam() {
            super(NAME, -1L);
        }
    }

    @InterfaceAudience.Private
    public static class RecursiveParam
    extends BooleanParam {
        public static final String NAME = "recursive";

        public RecursiveParam() {
            super(NAME, false);
        }
    }

    @InterfaceAudience.Private
    public static class AclPermissionParam
    extends StringParam {
        public static final String NAME = "aclspec";

        public AclPermissionParam() {
            super(NAME, "", Pattern.compile(HttpFSServerWebApp.get().get(FileSystemAccess.class).getFileSystemConfiguration().get("dfs.webhdfs.acl.provider.permission.pattern", "^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$")));
        }
    }

    @InterfaceAudience.Private
    public static class XAttrNameParam
    extends StringParam {
        public static final String XATTR_NAME_REGX = "^(user\\.|trusted\\.|system\\.|security\\.).+";
        public static final String NAME = "xattr.name";
        private static final Pattern PATTERN = Pattern.compile("^(user\\.|trusted\\.|system\\.|security\\.).+");

        public XAttrNameParam() {
            super(NAME, null, PATTERN);
        }
    }

    @InterfaceAudience.Private
    public static class XAttrValueParam
    extends StringParam {
        public static final String NAME = "xattr.value";

        public XAttrValueParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class XAttrSetFlagParam
    extends EnumSetParam<XAttrSetFlag> {
        public static final String NAME = "flag";

        public XAttrSetFlagParam() {
            super(NAME, XAttrSetFlag.class, null);
        }
    }

    @InterfaceAudience.Private
    public static class XAttrEncodingParam
    extends EnumParam<XAttrCodec> {
        public static final String NAME = "encoding";

        public XAttrEncodingParam() {
            super(NAME, XAttrCodec.class, null);
        }
    }

    @InterfaceAudience.Private
    public static class StartAfterParam
    extends StringParam {
        public static final String NAME = "startAfter";

        public StartAfterParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class PolicyNameParam
    extends StringParam {
        public static final String NAME = "storagepolicy";

        public PolicyNameParam() {
            super(NAME, null);
        }
    }

    public static class SnapshotNameParam
    extends StringParam {
        public static final String NAME = "snapshotname";

        public SnapshotNameParam() {
            super(NAME, null);
        }
    }

    public static class OldSnapshotNameParam
    extends StringParam {
        public static final String NAME = "oldsnapshotname";

        public OldSnapshotNameParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class FsActionParam
    extends StringParam {
        private static final String FILE_SYSTEM_ACTION = "[r-][w-][x-]";
        private static final Pattern FSACTION_PATTERN = Pattern.compile("[r-][w-][x-]");
        public static final String NAME = "fsaction";

        public FsActionParam() {
            super(NAME, null);
        }

        public FsActionParam(String str) {
            super(NAME, str, FSACTION_PATTERN);
        }
    }

    @InterfaceAudience.Private
    public static class ECPolicyParam
    extends StringParam {
        public static final String NAME = "ecpolicy";

        public ECPolicyParam() {
            super(NAME, null);
        }
    }

    @InterfaceAudience.Private
    public static class OperationParam
    extends EnumParam<HttpFSConstants.Operation> {
        public static final String NAME = "op";

        public OperationParam(String operation) {
            super(NAME, HttpFSConstants.Operation.class, HttpFSConstants.Operation.valueOf(StringUtils.toUpperCase((String)operation)));
        }
    }
}

