/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.LogSegmentStartEnd;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogOutputStream;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.SizeInBytes;
import picocli.CommandLine;

@CommandLine.Command(name="skip-ratis-transaction", aliases={"srt"}, description={"CLI to omit a raft log in a ratis segment file. The raft log at the index specified is replaced with an EchoOM command (which is a dummy command). It is an offline command i.e., doesn't require OM to be running. The command should be run for the same transaction on all 3 OMs only when all the OMs are crashing while applying the same transaction. If only one OM is crashing and the other OMs have executed the log successfully, then the DB should be manually copied from one of the good OMs to the crashing OM instead."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class OMRatisLogRepair
extends RepairTool {
    @CommandLine.ArgGroup(multiplicity="1")
    private ExclusiveArguments exclusiveArguments;
    @CommandLine.Option(names={"-b", "--backup"}, required=true, description={"Directory to put the backup of the original repaired segment file before the repair."})
    private File backupDir;
    @CommandLine.Option(names={"--index"}, required=true, description={"Index of the failing transaction that should be removed"})
    private long index;
    private SegmentedRaftLogOutputStream outputStream = null;

    @Override
    public void execute() throws Exception {
        File backupPath;
        if (this.exclusiveArguments.logDir != null) {
            this.exclusiveArguments.segmentFile = this.findSegmentFileContainingIndex();
        }
        if (this.exclusiveArguments.segmentFile.getParentFile().toPath().equals(this.backupDir.toPath())) {
            throw new IOException("Backup directory cannot be same as segment file's parent directory.");
        }
        LogSegmentPath pi = LogSegmentPath.matchLogSegment((Path)this.exclusiveArguments.segmentFile.toPath());
        if (pi == null) {
            throw new IOException("Invalid Segment File");
        }
        if (!this.exclusiveArguments.segmentFile.exists()) {
            throw new IOException("Error: Source segment file \"" + this.exclusiveArguments.segmentFile + "\" does not exist.");
        }
        if (!this.backupDir.exists()) {
            this.info("BackupDir \"" + this.backupDir + "\" does not exist. Creating the directory path.", new Object[0]);
            if (!this.isDryRun()) {
                Files.createDirectories(this.backupDir.toPath(), new FileAttribute[0]);
            }
        }
        if ((backupPath = new File(this.backupDir, this.exclusiveArguments.segmentFile.getName())).exists()) {
            throw new IOException("Error: Backup file for segment file  \"" + this.exclusiveArguments.segmentFile + "\" already exists. Either delete the old backup or provide a different directory to take the backup.");
        }
        this.info("Taking back up of Raft Log file: " + this.exclusiveArguments.segmentFile.getAbsolutePath() + " to location: " + backupPath, new Object[0]);
        if (!this.isDryRun()) {
            Files.copy(this.exclusiveArguments.segmentFile.toPath(), backupPath.toPath(), new CopyOption[0]);
        }
        this.info("File backed-up successfully!", new Object[0]);
        File outputFile = null;
        if (!this.isDryRun()) {
            outputFile = File.createTempFile("srt-output", null, this.backupDir);
            outputFile.deleteOnExit();
        }
        this.info("Created temporary output file: " + (outputFile == null ? "<None>" : outputFile.toPath()), new Object[0]);
        this.info("Processing Raft Log file: " + this.exclusiveArguments.segmentFile.getAbsolutePath() + " size:" + this.exclusiveArguments.segmentFile.length(), new Object[0]);
        if (!this.isDryRun()) {
            this.outputStream = new SegmentedRaftLogOutputStream(outputFile, false, 1024L, 1024L, ByteBuffer.allocateDirect(SizeInBytes.valueOf((String)"8MB").getSizeInt()));
        }
        int entryCount = LogSegment.readSegmentFile((File)this.exclusiveArguments.segmentFile, (LogSegmentStartEnd)pi.getStartEnd(), (SizeInBytes)SizeInBytes.valueOf((String)"32MB"), (RaftServerConfigKeys.Log.CorruptionPolicy)RaftServerConfigKeys.Log.CorruptionPolicy.EXCEPTION, null, this::processLogEntry);
        if (!this.isDryRun()) {
            this.outputStream.flush();
            this.outputStream.close();
            Files.move(outputFile.toPath(), this.exclusiveArguments.segmentFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        this.info("Finished processing all the entries (" + entryCount + " logs) from the segment file.", new Object[0]);
        this.info("Moved temporary output file to correct raft log location : " + this.exclusiveArguments.segmentFile.toPath(), new Object[0]);
    }

    private void processLogEntry(RaftProtos.LogEntryProto proto) {
        try {
            RaftProtos.LogEntryProto newLogEntry;
            RaftProtos.LogEntryProto logEntryProto = newLogEntry = proto.getIndex() != this.index ? proto : this.getOmEchoLogEntry(proto);
            if (!this.isDryRun()) {
                this.outputStream.write(newLogEntry);
                this.outputStream.flush();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while processing logEntry: (" + proto.getIndex() + "). Exception: " + ex);
        }
    }

    private RaftProtos.LogEntryProto getOmEchoLogEntry(RaftProtos.LogEntryProto proto) throws IOException {
        OzoneManagerProtocolProtos.OMRequest.Builder newRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.EchoRPC).setClientId("skip-ratis-transaction-repair-tool").setEchoRPCRequest(OzoneManagerProtocolProtos.EchoRPCRequest.newBuilder().build());
        RaftProtos.StateMachineLogEntryProto.Builder entry = proto.getStateMachineLogEntry().toBuilder().setLogData(OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)newRequest.build()));
        OzoneManagerProtocolProtos.OMRequest oldRequest = OMRatisHelper.convertByteStringToOMRequest((ByteString)proto.getStateMachineLogEntry().getLogData());
        this.info("Replacing {" + oldRequest.toString().replace("\n", "  ") + "} with EchoRPC command at index " + proto.getIndex(), new Object[0]);
        return proto.toBuilder().setStateMachineLogEntry(entry).build();
    }

    private File findSegmentFileContainingIndex() {
        if (!this.exclusiveArguments.logDir.exists() || !this.exclusiveArguments.logDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid log directory: " + this.exclusiveArguments.logDir);
        }
        Pattern pattern = Pattern.compile("log(?:_inprogress)?_(\\d+)(?:-(\\d+))?");
        File[] segmentFiles = this.exclusiveArguments.logDir.listFiles();
        if (segmentFiles == null) {
            throw new IllegalArgumentException("Invalid log directory: " + this.exclusiveArguments.logDir + ". No segment files present.");
        }
        for (File file : segmentFiles) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            long start = Long.parseLong(matcher.group(1));
            String endStr = matcher.group(2);
            if (endStr == null) {
                if (this.index < start) continue;
                this.info("Segment file \"" + file + "\" contains the index (" + this.index + ").", new Object[0]);
                return file;
            }
            long end = Long.parseLong(endStr);
            if (this.index < start || this.index > end) continue;
            this.info("Segment file \"" + file + "\" contains the index (" + this.index + ").", new Object[0]);
            return file;
        }
        throw new IllegalArgumentException("Invalid index (" + this.index + ") for log directory: \"" + this.exclusiveArguments.logDir + "\". None of the segment files have the index.");
    }

    private static final class ExclusiveArguments {
        @CommandLine.Option(names={"-s", "--segment-path"}, description={"Path of the input segment file"})
        private File segmentFile;
        @CommandLine.Option(names={"-d", "--ratis-log-dir"}, description={"Path of the ratis log directory"})
        private File logDir;

        private ExclusiveArguments() {
        }
    }
}

