/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.ByteProcessor;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.container.stream.StreamingSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirstreamServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DirstreamServerHandler.class);
    public static final String END_MARKER = "0 END";
    private StreamingSource source;
    private boolean headerProcessed = false;

    public DirstreamServerHandler(StreamingSource source) {
        this.source = source;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        StringBuilder id = new StringBuilder();
        if (!this.headerProcessed) {
            ByteBuf buffer = (ByteBuf)msg;
            int eolPosition = buffer.forEachByte(ByteProcessor.FIND_LF) - buffer.readerIndex();
            if (eolPosition > 0) {
                this.headerProcessed = true;
                id.append(buffer.toString(Charset.defaultCharset()));
            } else {
                id.append(buffer.toString(0, eolPosition, Charset.defaultCharset()));
            }
            buffer.release();
        }
        if (this.headerProcessed) {
            ArrayList<Map.Entry<String, Path>> entriesToWrite = new ArrayList<Map.Entry<String, Path>>(this.source.getFilesToStream(id.toString().trim()).entrySet());
            this.writeOneElement(ctx, entriesToWrite, 0);
        }
    }

    public void writeOneElement(ChannelHandlerContext ctx, List<Map.Entry<String, Path>> entriesToWrite, int i) throws IOException {
        Map.Entry<String, Path> entryToWrite = entriesToWrite.get(i);
        Path file = entryToWrite.getValue();
        String name = entryToWrite.getKey();
        long fileSize = Files.size(file);
        String identifier = fileSize + " " + name + "\n";
        ByteBuf identifierBuf = Unpooled.wrappedBuffer((byte[])identifier.getBytes(StandardCharsets.UTF_8));
        int currentIndex = i;
        ChannelFuture lastFuture = ctx.writeAndFlush((Object)identifierBuf);
        lastFuture.addListener(f -> {
            ChannelFuture nextFuture = ctx.writeAndFlush((Object)new ChunkedFile(file.toFile()));
            if (currentIndex == entriesToWrite.size() - 1) {
                nextFuture.addListener(a -> {
                    if (!a.isSuccess()) {
                        LOG.error("Error on streaming file", a.cause());
                    }
                    ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])END_MARKER.getBytes(StandardCharsets.UTF_8))).addListener(b -> ctx.channel().close());
                });
            } else {
                nextFuture.addListener(a -> this.writeOneElement(ctx, entriesToWrite, currentIndex + 1));
            }
        });
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)("ERR: " + cause.getClass().getSimpleName() + ": " + cause.getMessage() + '\n')).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        ctx.close();
    }
}

