/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.statemachine.background;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.container.checksum.ContainerChecksumTreeManager;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.BlockDeletingServiceMetrics;
import org.apache.hadoop.ozone.container.common.impl.BlockDeletingService;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.metadata.DeleteTransactionStore;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.util.Time;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockDeletingTask
implements BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(BlockDeletingTask.class);
    private final BlockDeletingServiceMetrics metrics;
    private final int priority;
    private final KeyValueContainerData containerData;
    private long blocksToDelete;
    private final OzoneContainer ozoneContainer;
    private final ConfigurationSource conf;
    private Duration blockDeletingMaxLockHoldingTime;
    private final ContainerChecksumTreeManager checksumTreeManager;

    public BlockDeletingTask(BlockDeletingService blockDeletingService, BlockDeletingService.ContainerBlockInfo containerBlockInfo, ContainerChecksumTreeManager checksumTreeManager, int priority) {
        this.ozoneContainer = blockDeletingService.getOzoneContainer();
        this.metrics = blockDeletingService.getMetrics();
        this.conf = blockDeletingService.getConf();
        this.blockDeletingMaxLockHoldingTime = blockDeletingService.getBlockDeletingMaxLockHoldingTime();
        this.priority = priority;
        this.containerData = (KeyValueContainerData)containerBlockInfo.getContainerData();
        this.blocksToDelete = containerBlockInfo.getNumBlocksToDelete();
        this.checksumTreeManager = checksumTreeManager;
    }

    public BackgroundTaskResult call() throws Exception {
        ContainerBackgroundTaskResult result = new ContainerBackgroundTaskResult();
        while (this.blocksToDelete > 0L) {
            ContainerBackgroundTaskResult crr = this.handleDeleteTask();
            if (this.blocksToDelete > 0L && crr.getSize() == 0) {
                LOG.warn("Block deletion failed, remaining Blocks to be deleted {}, but no Block be deleted. Container {}, pending block count {}", new Object[]{this.blocksToDelete, this.containerData.getContainerID(), this.containerData.getNumPendingDeletionBlocks()});
                break;
            }
            this.blocksToDelete -= (long)crr.getSize();
            result.addAll(crr.getDeletedBlocks());
        }
        return result;
    }

    private ContainerBackgroundTaskResult handleDeleteTask() throws Exception {
        Container<?> container = this.ozoneContainer.getContainerSet().getContainer(this.containerData.getContainerID());
        container.writeLock();
        File dataDir = new File(this.containerData.getChunksPath());
        long startTime = Time.monotonicNow();
        try {
            ContainerBackgroundTaskResult containerBackgroundTaskResult;
            block15: {
                DBHandle meta = BlockUtils.getDB(this.containerData, this.conf);
                try {
                    ContainerBackgroundTaskResult crr;
                    if (this.containerData.hasSchema("1")) {
                        crr = this.deleteViaSchema1(meta, container, dataDir, startTime);
                    } else if (this.containerData.hasSchema("2")) {
                        crr = this.deleteViaSchema2(meta, container, dataDir, startTime);
                    } else if (this.containerData.hasSchema("3")) {
                        crr = this.deleteViaSchema3(meta, container, dataDir, startTime);
                    } else {
                        throw new UnsupportedOperationException("Only schema version 1,2,3 are supported.");
                    }
                    containerBackgroundTaskResult = crr;
                    if (meta == null) break block15;
                }
                catch (Throwable throwable) {
                    if (meta != null) {
                        try {
                            meta.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                meta.close();
            }
            return containerBackgroundTaskResult;
        }
        finally {
            container.writeUnlock();
        }
    }

    public boolean checkDataDir(File dataDir) {
        boolean b = true;
        if (!dataDir.exists() || !dataDir.isDirectory()) {
            LOG.error("Invalid container data dir {} : does not exist or not a directory", (Object)dataDir.getAbsolutePath());
            b = false;
        }
        return b;
    }

    public ContainerBackgroundTaskResult deleteViaSchema1(DBHandle meta, Container container, File dataDir, long startTime) throws IOException {
        ContainerBackgroundTaskResult crr = new ContainerBackgroundTaskResult();
        if (!this.checkDataDir(dataDir)) {
            return crr;
        }
        try {
            Table<String, BlockData> blockDataTable = meta.getStore().getBlockDataTable();
            MetadataKeyFilters.KeyPrefixFilter filter = this.containerData.getDeletingBlockKeyFilter();
            List toDeleteBlocks = blockDataTable.getRangeKVs((Object)this.containerData.startKeyEmpty(), (int)this.blocksToDelete, (Object)this.containerData.containerPrefix(), filter, true);
            if (toDeleteBlocks.isEmpty()) {
                LOG.debug("No under deletion block found in container : {}", (Object)this.containerData.getContainerID());
                return crr;
            }
            HashMap<String, BlockData> succeedDeletedBlocks = new HashMap<String, BlockData>();
            LOG.debug("{}, toDeleteBlocks: {}", (Object)this.containerData, (Object)toDeleteBlocks.size());
            Handler handler = Objects.requireNonNull(this.ozoneContainer.getDispatcher().getHandler(container.getContainerType()));
            long releasedBytes = 0L;
            for (Object entry : toDeleteBlocks) {
                String blockName = (String)entry.getKey();
                BlockData blockData = (BlockData)entry.getValue();
                LOG.debug("Deleting block {}", (Object)blockName);
                if (blockData == null) {
                    LOG.warn("Missing delete block(Container = " + ((ContainerData)container.getContainerData()).getContainerID() + ", Block = " + blockName);
                    continue;
                }
                try {
                    handler.deleteBlock(container, blockData);
                    releasedBytes += KeyValueContainerUtil.getBlockLength(blockData);
                    succeedDeletedBlocks.put(blockName, blockData);
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error("Failed to parse block info for block {}", (Object)blockName, (Object)e);
                }
                catch (IOException e) {
                    LOG.error("Failed to delete files for block {}", (Object)blockName, (Object)e);
                }
            }
            this.checksumTreeManager.addDeletedBlocks(this.containerData, succeedDeletedBlocks.values());
            try (BatchOperation batch = meta.getStore().getBatchHandler().initBatchOperation();){
                for (String key : succeedDeletedBlocks.keySet()) {
                    blockDataTable.deleteWithBatch(batch, (Object)key);
                }
                int deletedBlocksCount = succeedDeletedBlocks.size();
                this.containerData.updateAndCommitDBCounters(meta, batch, deletedBlocksCount, releasedBytes);
                if (!container.hasBlocks()) {
                    this.containerData.markAsEmpty();
                }
                this.containerData.getStatistics().updateDeletion(releasedBytes, deletedBlocksCount, deletedBlocksCount);
                this.containerData.getVolume().decrementUsedSpace(releasedBytes);
                this.metrics.incrSuccessCount(deletedBlocksCount);
                this.metrics.incrSuccessBytes(releasedBytes);
            }
            if (!succeedDeletedBlocks.isEmpty()) {
                LOG.debug("Container: {}, deleted blocks: {}, space reclaimed: {}, task elapsed time: {}ms", new Object[]{this.containerData.getContainerID(), succeedDeletedBlocks.size(), releasedBytes, Time.monotonicNow() - startTime});
            }
            crr.addAll(succeedDeletedBlocks.values().stream().map(BlockData::getLocalID).collect(Collectors.toList()));
            return crr;
        }
        catch (IOException exception) {
            LOG.warn("Deletion operation was not successful for container: " + ((ContainerData)container.getContainerData()).getContainerID(), (Throwable)exception);
            this.metrics.incrFailureCount();
            throw exception;
        }
    }

    public ContainerBackgroundTaskResult deleteViaSchema2(DBHandle meta, Container container, File dataDir, long startTime) throws IOException {
        Deleter schema2Deleter = (table, batch, tid) -> {
            Table delTxTable = table;
            delTxTable.deleteWithBatch(batch, (Object)tid);
        };
        Table deleteTxns = ((DeleteTransactionStore)((Object)meta.getStore())).getDeleteTransactionTable();
        try (TableIterator iterator = deleteTxns.valueIterator();){
            ContainerBackgroundTaskResult containerBackgroundTaskResult = this.deleteViaTransactionStore(iterator, meta, container, dataDir, startTime, schema2Deleter);
            return containerBackgroundTaskResult;
        }
    }

    public ContainerBackgroundTaskResult deleteViaSchema3(DBHandle meta, Container container, File dataDir, long startTime) throws IOException {
        Deleter schema3Deleter = (table, batch, tid) -> {
            Table delTxTable = table;
            delTxTable.deleteWithBatch(batch, (Object)this.containerData.getDeleteTxnKey(tid));
        };
        Table deleteTxns = ((DeleteTransactionStore)((Object)meta.getStore())).getDeleteTransactionTable();
        try (TableIterator iterator = deleteTxns.valueIterator((Object)this.containerData.containerPrefix());){
            ContainerBackgroundTaskResult containerBackgroundTaskResult = this.deleteViaTransactionStore(iterator, meta, container, dataDir, startTime, schema3Deleter);
            return containerBackgroundTaskResult;
        }
    }

    private ContainerBackgroundTaskResult deleteViaTransactionStore(TableIterator<?, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> iter, DBHandle meta, Container container, File dataDir, long startTime, Deleter deleter) throws IOException {
        ContainerBackgroundTaskResult crr = new ContainerBackgroundTaskResult();
        if (!this.checkDataDir(dataDir)) {
            return crr;
        }
        try {
            Table<String, BlockData> blockDataTable = meta.getStore().getBlockDataTable();
            Table<String, BlockData> lastChunkInfoTable = meta.getStore().getLastChunkInfoTable();
            DeleteTransactionStore txnStore = (DeleteTransactionStore)((Object)meta.getStore());
            Table deleteTxns = txnStore.getDeleteTransactionTable();
            ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> delBlocks = new ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>();
            int numBlocks = 0;
            while (iter.hasNext() && (long)numBlocks < this.blocksToDelete) {
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTx = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)iter.next();
                numBlocks += delTx.getLocalIDList().size();
                delBlocks.add(delTx);
            }
            if (delBlocks.isEmpty()) {
                LOG.info("Pending block deletion not found in {}: {}", (Object)this.containerData, (Object)this.containerData.getStatistics());
                this.containerData.resetPendingDeleteBlockCount(meta);
                return crr;
            }
            LOG.debug("{}, delBlocks: {}", (Object)this.containerData, (Object)delBlocks.size());
            Handler handler = Objects.requireNonNull(this.ozoneContainer.getDispatcher().getHandler(container.getContainerType()));
            DeleteTransactionStats deleteBlocksResult = this.deleteTransactions(delBlocks, handler, blockDataTable, container);
            int deletedBlocksProcessed = deleteBlocksResult.getBlocksProcessed();
            int deletedBlocksCount = deleteBlocksResult.getBlocksDeleted();
            long releasedBytes = deleteBlocksResult.getBytesReleased();
            List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTxs = deleteBlocksResult.deletedBlocksTxs();
            deleteBlocksResult.deletedBlocksTxs().forEach(tx -> crr.addAll(tx.getLocalIDList()));
            try (BatchOperation batch = meta.getStore().getBatchHandler().initBatchOperation();){
                for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTx : deletedBlocksTxs) {
                    deleter.apply(deleteTxns, batch, delTx.getTxID());
                    for (Long blk : delTx.getLocalIDList()) {
                        blockDataTable.deleteWithBatch(batch, (Object)this.containerData.getBlockKey(blk));
                        lastChunkInfoTable.deleteWithBatch(batch, (Object)this.containerData.getBlockKey(blk));
                    }
                }
                this.containerData.updateAndCommitDBCounters(meta, batch, deletedBlocksCount, releasedBytes);
                if (!container.hasBlocks()) {
                    this.containerData.markAsEmpty();
                }
                this.containerData.getStatistics().updateDeletion(releasedBytes, deletedBlocksCount, deletedBlocksProcessed);
                this.containerData.getVolume().decrementUsedSpace(releasedBytes);
                this.metrics.incrSuccessCount(deletedBlocksCount);
                this.metrics.incrSuccessBytes(releasedBytes);
            }
            LOG.debug("Container: {}, deleted blocks: {}, space reclaimed: {}, task elapsed time: {}ms", new Object[]{this.containerData.getContainerID(), deletedBlocksCount, releasedBytes, Time.monotonicNow() - startTime});
            return crr;
        }
        catch (IOException exception) {
            LOG.warn("Deletion operation was not successful for container: " + ((ContainerData)container.getContainerData()).getContainerID(), (Throwable)exception);
            this.metrics.incrFailureCount();
            throw exception;
        }
    }

    private DeleteTransactionStats deleteTransactions(List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> delBlocks, Handler handler, Table<String, BlockData> blockDataTable, Container container) throws IOException {
        int blocksProcessed = 0;
        int blocksDeleted = 0;
        long bytesReleased = 0L;
        ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTxs = new ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>();
        Instant startTime = Instant.now();
        HashMap<Long, BlockData> deletedBlocks = new HashMap<Long, BlockData>();
        for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction entry : delBlocks) {
            for (Long blkLong : entry.getLocalIDList()) {
                ++blocksProcessed;
                if (deletedBlocks.containsKey(blkLong)) {
                    LOG.debug("Skipping duplicate deletion for block {}", (Object)blkLong);
                    continue;
                }
                String blk = this.containerData.getBlockKey(blkLong);
                BlockData blkInfo = (BlockData)blockDataTable.get((Object)blk);
                LOG.debug("Deleting block {}", (Object)blkLong);
                if (blkInfo == null) {
                    try {
                        handler.deleteUnreferenced(container, blkLong);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to delete files for unreferenced block {} of container {}", new Object[]{blkLong, ((ContainerData)container.getContainerData()).getContainerID(), e});
                    }
                    continue;
                }
                boolean deleted = false;
                try {
                    handler.deleteBlock(container, blkInfo);
                    ++blocksDeleted;
                    deleted = true;
                    deletedBlocks.put(blkLong, blkInfo);
                }
                catch (IOException e) {
                    LOG.error("Failed to delete files for block {}", (Object)blkLong, (Object)e);
                }
                if (!deleted) continue;
                bytesReleased += KeyValueContainerUtil.getBlockLengthTryCatch(blkInfo);
            }
            deletedBlocksTxs.add(entry);
            Duration execTime = Duration.between(startTime, Instant.now());
            if (deletedBlocksTxs.size() >= delBlocks.size() || execTime.compareTo(this.getBlockDeletingMaxLockHoldingTime()) <= 0) continue;
            LOG.info("Max lock hold time ({} ms) reached after {} ms. Completed {} transactions, deleted {} blocks. In container: {}. Releasing lock and resuming deletion later.", new Object[]{this.getBlockDeletingMaxLockHoldingTime().toMillis(), execTime.toMillis(), deletedBlocksTxs.size(), blocksDeleted, ((ContainerData)container.getContainerData()).getContainerID()});
            break;
        }
        this.checksumTreeManager.addDeletedBlocks(this.containerData, deletedBlocks.values());
        return new DeleteTransactionStats(blocksProcessed, blocksDeleted, bytesReleased, deletedBlocksTxs);
    }

    public int getPriority() {
        return this.priority;
    }

    public Duration getBlockDeletingMaxLockHoldingTime() {
        return this.blockDeletingMaxLockHoldingTime;
    }

    private static class ContainerBackgroundTaskResult
    implements BackgroundTaskResult {
        private final List<Long> deletedBlockIds = new LinkedList<Long>();

        ContainerBackgroundTaskResult() {
        }

        public void addBlockId(Long blockId) {
            this.deletedBlockIds.add(blockId);
        }

        public void addAll(List<Long> blockIds) {
            this.deletedBlockIds.addAll(blockIds);
        }

        public List<Long> getDeletedBlocks() {
            return this.deletedBlockIds;
        }

        public int getSize() {
            return this.deletedBlockIds.size();
        }
    }

    private static interface Deleter {
        public void apply(Table<?, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> var1, BatchOperation var2, long var3) throws IOException;
    }

    private static class DeleteTransactionStats {
        private final int blocksProcessed;
        private final int blocksDeleted;
        private final long bytesReleased;
        private final List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> delBlockTxs;

        DeleteTransactionStats(int proceeded, int deleted, long released, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> delBlocks) {
            this.blocksProcessed = proceeded;
            this.blocksDeleted = deleted;
            this.bytesReleased = released;
            this.delBlockTxs = delBlocks;
        }

        public int getBlocksProcessed() {
            return this.blocksProcessed;
        }

        public int getBlocksDeleted() {
            return this.blocksDeleted;
        }

        public long getBytesReleased() {
            return this.bytesReleased;
        }

        public List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTxs() {
            return this.delBlockTxs;
        }
    }
}

