/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ec.reconstruction;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECContainerOperationClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ECContainerOperationClient.class);
    private final XceiverClientManager xceiverClientManager;

    public ECContainerOperationClient(XceiverClientManager clientManager) {
        this.xceiverClientManager = clientManager;
    }

    public ECContainerOperationClient(ConfigurationSource conf, CertificateClient certificateClient) throws IOException {
        this(ECContainerOperationClient.createClientManager(conf, certificateClient));
    }

    @Nonnull
    private static XceiverClientManager createClientManager(ConfigurationSource conf, CertificateClient certificateClient) throws IOException {
        ClientTrustManager trustManager = null;
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            trustManager = certificateClient.createClientTrustManager();
        }
        XceiverClientManager.ScmClientConfig scmClientConfig = new XceiverClientManager.XceiverClientManagerConfigBuilder().setMaxCacheSize(256).setStaleThresholdMs(10000L).build();
        return new XceiverClientManager(conf, scmClientConfig, trustManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockData[] listBlock(long containerId, DatanodeDetails dn, ECReplicationConfig repConfig, Token<? extends TokenIdentifier> token) throws IOException {
        XceiverClientSpi xceiverClient = this.xceiverClientManager.acquireClient(this.singleNodePipeline(dn, repConfig));
        try {
            List blockDataList = ContainerProtocolCalls.listBlock((XceiverClientSpi)xceiverClient, (long)containerId, null, (int)Integer.MAX_VALUE, token).getBlockDataList();
            BlockData[] blockDataArray = (BlockData[])blockDataList.stream().map(i -> {
                try {
                    return BlockData.getFromProtoBuf((ContainerProtos.BlockData)i);
                }
                catch (IOException e) {
                    LOG.debug("Failed while converting to protobuf BlockData. Returning null for listBlock from DN: {}", (Object)dn, (Object)e);
                    return null;
                }
            }).toArray(BlockData[]::new);
            return blockDataArray;
        }
        finally {
            this.xceiverClientManager.releaseClient(xceiverClient, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContainer(long containerID, DatanodeDetails dn, ECReplicationConfig repConfig, String encodedToken) throws IOException {
        XceiverClientSpi xceiverClient = this.xceiverClientManager.acquireClient(this.singleNodePipeline(dn, repConfig));
        try {
            ContainerProtocolCalls.closeContainer((XceiverClientSpi)xceiverClient, (long)containerID, (String)encodedToken);
        }
        finally {
            this.xceiverClientManager.releaseClient(xceiverClient, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContainerInState(long containerID, DatanodeDetails dn, ECReplicationConfig repConfig, String encodedToken, Set<ContainerProtos.ContainerDataProto.State> acceptableStates) throws IOException {
        XceiverClientSpi xceiverClient = this.xceiverClientManager.acquireClient(this.singleNodePipeline(dn, repConfig));
        try {
            ContainerProtos.ReadContainerResponseProto readContainerResponseProto = ContainerProtocolCalls.readContainer((XceiverClientSpi)xceiverClient, (long)containerID, (String)encodedToken);
            ContainerProtos.ContainerDataProto.State currentState = readContainerResponseProto.getContainerData().getState();
            if (!Objects.isNull(acceptableStates) && acceptableStates.contains(currentState)) {
                ContainerProtocolCalls.deleteContainer((XceiverClientSpi)xceiverClient, (long)containerID, (boolean)true, (String)encodedToken);
            } else {
                LOG.warn("Container {} will not be deleted as current state not in acceptable states. Current state: {}, Acceptable States: {}", new Object[]{containerID, currentState, acceptableStates});
            }
        }
        finally {
            this.xceiverClientManager.releaseClient(xceiverClient, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRecoveringContainer(long containerID, DatanodeDetails dn, ECReplicationConfig repConfig, String encodedToken, int replicaIndex) throws IOException {
        XceiverClientSpi xceiverClient = this.xceiverClientManager.acquireClient(this.singleNodePipeline(dn, repConfig));
        try {
            ContainerProtocolCalls.createRecoveringContainer((XceiverClientSpi)xceiverClient, (long)containerID, (String)encodedToken, (int)replicaIndex);
        }
        finally {
            this.xceiverClientManager.releaseClient(xceiverClient, false);
        }
    }

    Pipeline singleNodePipeline(DatanodeDetails dn, ECReplicationConfig repConfig) {
        return this.singleNodePipeline(dn, repConfig, 0);
    }

    Pipeline singleNodePipeline(DatanodeDetails dn, ECReplicationConfig repConfig, int replicaIndex) {
        return Pipeline.newBuilder().setId(dn.getID()).setReplicationConfig((ReplicationConfig)repConfig).setNodes((List)ImmutableList.of((Object)dn)).setState(Pipeline.PipelineState.CLOSED).setReplicaIndexes(Collections.singletonMap(dn, replicaIndex)).build();
    }

    public XceiverClientManager getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    @Override
    public void close() throws IOException {
        if (this.xceiverClientManager != null) {
            this.xceiverClientManager.close();
        }
    }
}

