/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartAbortInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public abstract class AbstractS3MultipartAbortResponse
extends OmKeyResponse {
    public AbstractS3MultipartAbortResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    public AbstractS3MultipartAbortResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    protected void addAbortToBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation, OmBucketInfo omBucketInfo, List<OmMultipartAbortInfo> multipartAbortInfo) throws IOException {
        for (OmMultipartAbortInfo abortInfo : multipartAbortInfo) {
            omMetadataManager.getOpenKeyTable(abortInfo.getBucketLayout()).deleteWithBatch(batchOperation, (Object)abortInfo.getMultipartOpenKey());
            omMetadataManager.getMultipartInfoTable().deleteWithBatch(batchOperation, (Object)abortInfo.getMultipartKey());
            OmMultipartKeyInfo omMultipartKeyInfo = abortInfo.getOmMultipartKeyInfo();
            for (OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo : omMultipartKeyInfo.getPartKeyInfoMap()) {
                OmKeyInfo currentKeyPartInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                RepeatedOmKeyInfo repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((long)omBucketInfo.getObjectID(), (OmKeyInfo)currentKeyPartInfo, (long)omMultipartKeyInfo.getUpdateID());
                String deleteKey = omMetadataManager.getOzoneDeletePathKey(currentKeyPartInfo.getObjectID(), abortInfo.getMultipartKey());
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deleteKey, (Object)repeatedOmKeyInfo);
            }
        }
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(omBucketInfo.getVolumeName(), omBucketInfo.getBucketName()), (Object)omBucketInfo);
    }

    protected void addAbortToBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation, String multipartKey, String multipartOpenKey, OmMultipartKeyInfo omMultipartKeyInfo, OmBucketInfo omBucketInfo, BucketLayout bucketLayout) throws IOException {
        OmMultipartAbortInfo omMultipartAbortInfo = new OmMultipartAbortInfo.Builder().setMultipartKey(multipartKey).setMultipartOpenKey(multipartOpenKey).setMultipartKeyInfo(omMultipartKeyInfo).setBucketLayout(bucketLayout).build();
        this.addAbortToBatch(omMetadataManager, batchOperation, omBucketInfo, Collections.singletonList(omMultipartAbortInfo));
    }
}

