/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneLockStrategy;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCreateRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyCreateRequest.class);
    }

    public OMKeyCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest = super.preExecute(ozoneManager).getCreateKeyRequest();
        Preconditions.checkNotNull((Object)createKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
        OMPerformanceMetrics perfMetrics = ozoneManager.getPerfMetrics();
        if (keyArgs.hasExpectedDataGeneration()) {
            ozoneManager.checkFeatureEnabled(OzoneManagerVersion.ATOMIC_REWRITE_KEY);
        }
        OmUtils.verifyKeyNameWithSnapshotReservedWord((String)keyArgs.getKeyName());
        if (ozoneManager.getConfig().isKeyNameCharacterCheckEnabled()) {
            OmUtils.validateKeyName((String)keyArgs.getKeyName());
        }
        String keyPath = keyArgs.getKeyName();
        keyPath = OMKeyCreateRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        OzoneManagerProtocolProtos.CreateKeyRequest.Builder newCreateKeyRequest = null;
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = null;
        if (!keyArgs.getIsMultipartKey()) {
            long scmBlockSize = ozoneManager.getScmBlockSize();
            long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
            HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
            HddsProtos.ReplicationType type = keyArgs.getType();
            OmBucketInfo bucketInfo = ozoneManager.getBucketInfo(keyArgs.getVolumeName(), keyArgs.getBucketName());
            ReplicationConfig repConfig = OzoneConfigUtil.resolveReplicationConfigPreference(type, factor, keyArgs.getEcReplicationConfig(), bucketInfo.getDefaultReplicationConfig(), ozoneManager);
            OzoneManagerProtocolProtos.UserInfo userInfo = this.getUserInfo();
            List omKeyLocationInfoList = (List)MetricUtil.captureLatencyNs((MutableRate)perfMetrics.getCreateKeyAllocateBlockLatencyNs(), () -> this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), repConfig, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMServiceId(), ozoneManager.getMetrics(), keyArgs.getSortDatanodes(), userInfo));
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
            newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(info -> info.getProtobuf(false, this.getOmRequest().getVersion())).collect(Collectors.toList()));
        } else {
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        }
        newKeyArgs.setKeyName(keyPath);
        if (keyArgs.getIsMultipartKey()) {
            this.getFileEncryptionInfoForMpuKey(keyArgs, newKeyArgs, ozoneManager);
        } else {
            this.generateRequiredEncryptionInfo(keyArgs, newKeyArgs, ozoneManager);
        }
        OzoneManagerProtocolProtos.KeyArgs.Builder finalNewKeyArgs = newKeyArgs;
        OzoneManagerProtocolProtos.KeyArgs resolvedKeyArgs = (OzoneManagerProtocolProtos.KeyArgs)MetricUtil.captureLatencyNs((MutableRate)perfMetrics.getCreateKeyResolveBucketAndAclCheckLatencyNs(), () -> this.resolveBucketAndCheckKeyAcls(finalNewKeyArgs.build(), ozoneManager, IAccessAuthorizer.ACLType.CREATE));
        newCreateKeyRequest = createKeyRequest.toBuilder().setKeyArgs(resolvedKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateKeyRequest(newCreateKeyRequest).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        int numMissingParents;
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        OMMetrics omMetrics;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest;
        block22: {
            long trxnLogIndex = context.getIndex();
            createKeyRequest = this.getOmRequest().getCreateKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyAllocates();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneLockStrategy ozoneLockStrategy = this.getOzoneLockStrategy(ozoneManager);
            OmKeyInfo omKeyInfo = null;
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            boolean acquireLock = false;
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            result = null;
            List<OmKeyInfo> missingParentInfos = null;
            numMissingParents = 0;
            OMPerformanceMetrics perfMetrics = ozoneManager.getPerfMetrics();
            long createKeyStartTime = Time.monotonicNowNanos();
            try {
                try {
                    this.mergeOmLockDetails(ozoneLockStrategy.acquireWriteLock(omMetadataManager, volumeName, bucketName, keyName));
                    acquireLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    String dbKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    OmKeyInfo dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).getIfExist((Object)dbKeyName);
                    this.validateAtomicRewrite(dbKeyInfo, keyArgs);
                    OmBucketInfo bucketInfo = OMKeyCreateRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("BucketName: {}, BucketLayout: {}", (Object)bucketInfo.getBucketName(), (Object)bucketInfo.getBucketLayout());
                    }
                    OMFileRequest.OMPathInfo pathInfo = null;
                    if (bucketInfo.getBucketLayout().shouldNormalizePaths(ozoneManager.getEnableFileSystemPaths())) {
                        pathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                        OMFileRequest.OMDirectoryResult omDirectoryResult = pathInfo.getDirectoryResult();
                        if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                            throw new OMException("Cannot write to directory. createIntermediateDirs behavior is enabled and hence / has special interpretation: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                        }
                        if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                            throw new OMException("Can not create file: " + keyName + " as there is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
                        }
                        missingParentInfos = this.getAllParentInfo(ozoneManager, keyArgs, pathInfo.getMissingParents(), bucketInfo, pathInfo, trxnLogIndex);
                        numMissingParents = missingParentInfos.size();
                    }
                    ReplicationConfig replicationConfig = OzoneConfigUtil.resolveReplicationConfigPreference(keyArgs.getType(), keyArgs.getFactor(), keyArgs.getEcReplicationConfig(), bucketInfo.getDefaultReplicationConfig(), ozoneManager);
                    omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, dbKeyInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), bucketInfo, pathInfo, trxnLogIndex, ozoneManager.getObjectIdFromTxId(trxnLogIndex), replicationConfig, ozoneManager.getConfig());
                    this.validateEncryptionKeyInfo(bucketInfo, keyArgs);
                    long openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
                    long clientID = createKeyRequest.getClientID();
                    String dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                    List newLocationList = keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
                    omKeyInfo.appendNewBlocks(newLocationList, false);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)replicationConfig.getRequiredNodes();
                    long quotaCheckStartTime = Time.monotonicNowNanos();
                    this.checkBucketQuotaInBytes(omMetadataManager, bucketInfo, preAllocatedSpace);
                    this.checkBucketQuotaInNamespace(bucketInfo, (long)numMissingParents + 1L);
                    perfMetrics.addCreateKeyQuotaCheckLatencyNs(Time.monotonicNowNanos() - quotaCheckStartTime);
                    bucketInfo.incrUsedNamespace((long)numMissingParents);
                    if (numMissingParents > 0) {
                        OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, bucketInfo.getBucketLayout(), null, missingParentInfos, trxnLogIndex);
                    }
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry((Object)dbOpenKeyName, (Object)omKeyInfo, trxnLogIndex);
                    omResponse.setCreateKeyResponse(OzoneManagerProtocolProtos.CreateKeyResponse.newBuilder().setKeyInfo(omKeyInfo.getNetworkProtobuf(this.getOmRequest().getVersion(), keyArgs.getLatestVersionLocation())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponse(omResponse.build(), omKeyInfo, missingParentInfos, clientID, bucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumKeyAllocateFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    long createKeyLatency = Time.monotonicNowNanos() - createKeyStartTime;
                    if (OMClientRequest.Result.SUCCESS.equals((Object)result)) {
                        perfMetrics.addCreateKeySuccessLatencyNs(createKeyLatency);
                    } else {
                        perfMetrics.addCreateKeyFailureLatencyNs(createKeyLatency);
                    }
                    if (acquireLock) {
                        this.mergeOmLockDetails(ozoneLockStrategy.releaseWriteLock(omMetadataManager, volumeName, bucketName, keyName));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                long createKeyLatency = Time.monotonicNowNanos() - createKeyStartTime;
                if (OMClientRequest.Result.SUCCESS.equals((Object)result)) {
                    perfMetrics.addCreateKeySuccessLatencyNs(createKeyLatency);
                } else {
                    perfMetrics.addCreateKeyFailureLatencyNs(createKeyLatency);
                }
                if (acquireLock) {
                    this.mergeOmLockDetails(ozoneLockStrategy.releaseWriteLock(omMetadataManager, volumeName, bucketName, keyName));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            long createKeyLatency = Time.monotonicNowNanos() - createKeyStartTime;
            if (OMClientRequest.Result.SUCCESS.equals((Object)result)) {
                perfMetrics.addCreateKeySuccessLatencyNs(createKeyLatency);
            } else {
                perfMetrics.addCreateKeyFailureLatencyNs(createKeyLatency);
            }
            if (acquireLock) {
                this.mergeOmLockDetails(ozoneLockStrategy.releaseWriteLock(omMetadataManager, volumeName, bucketName, keyName));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.ALLOCATE_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        this.logResult(createKeyRequest, omMetrics, exception, result, numMissingParents);
        return omClientResponse;
    }

    protected void logResult(OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest, OMMetrics omMetrics, Exception exception, OMClientRequest.Result result, int numMissingParents) {
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numMissingParents);
                LOG.debug("Key created. Volume:{}, Bucket:{}, Key:{}", new Object[]{createKeyRequest.getKeyArgs().getVolumeName(), createKeyRequest.getKeyArgs().getBucketName(), createKeyRequest.getKeyArgs().getKeyName()});
                break;
            }
            case FAILURE: {
                if (createKeyRequest.getKeyArgs().hasEcReplicationConfig()) {
                    omMetrics.incEcKeyCreateFailsTotal();
                }
                LOG.error("Key creation failed. Volume:{}, Bucket:{}, Key:{}. ", new Object[]{createKeyRequest.getKeyArgs().getVolumeName(), createKeyRequest.getKeyArgs().getBucketName(), createKeyRequest.getKeyArgs().getKeyName(), exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyCreateRequest: {}", (Object)createKeyRequest);
            }
        }
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateKey)
    public static OzoneManagerProtocolProtos.OMRequest disallowCreateKeyWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getCreateKeyRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateKey)
    public static OzoneManagerProtocolProtos.OMRequest blockCreateKeyWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getCreateKeyRequest().hasKeyArgs() && (keyArgs = req.getCreateKeyRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    protected void validateAtomicRewrite(OmKeyInfo dbKeyInfo, OzoneManagerProtocolProtos.KeyArgs keyArgs) throws OMException {
        if (keyArgs.hasExpectedDataGeneration()) {
            if (dbKeyInfo == null) {
                throw new OMException("Key not found during expected rewrite", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (dbKeyInfo.getUpdateID() != keyArgs.getExpectedDataGeneration()) {
                throw new OMException("Generation mismatch during expected rewrite", OMException.ResultCodes.KEY_NOT_FOUND);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyCreateRequest.java", OMKeyCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 87);
    }
}

