/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyHealthyToHealthyNodeHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyHealthyToHealthyNodeHandler.class);
    private final SCMServiceManager serviceManager;

    public ReadOnlyHealthyToHealthyNodeHandler(SCMServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        LOG.info("Datanode {} moved to HEALTHY state.", (Object)datanodeDetails);
        this.serviceManager.notifyEventTriggered(SCMService.Event.UNHEALTHY_TO_HEALTHY_NODE_HANDLER_TRIGGERED);
    }
}

