/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.CaseWhenStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.Keywords;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class CaseWhenStepImpl<V, T>
extends AbstractFunction<T>
implements CaseWhenStep<V, T> {
    private static final long serialVersionUID = -3817194006479624228L;
    private final Field<V> value;
    private final List<Field<V>> compareValues;
    private final List<Field<T>> results;
    private Field<T> otherwise;

    CaseWhenStepImpl(Field<V> value, Field<V> compareValue, Field<T> result) {
        this(value, result.getDataType());
        this.when(compareValue, result);
    }

    CaseWhenStepImpl(Field<V> value, Map<? extends Field<V>, ? extends Field<T>> map) {
        this(value, CaseWhenStepImpl.dataType(map));
        for (Map.Entry<Field<V>, Field<T>> entry : map.entrySet()) {
            this.when(entry.getKey(), entry.getValue());
        }
    }

    private CaseWhenStepImpl(Field<V> value, DataType<T> type) {
        super("case", type, new Field[0]);
        this.value = value;
        this.compareValues = new ArrayList<Field<V>>();
        this.results = new ArrayList<Field<T>>();
    }

    private static final <T> DataType<T> dataType(Map<? extends Field<?>, ? extends Field<T>> map) {
        if (map.isEmpty()) {
            return SQLDataType.OTHER;
        }
        return map.entrySet().iterator().next().getValue().getDataType();
    }

    @Override
    public final Field<T> otherwise(T result) {
        return this.otherwise(Tools.field(result));
    }

    @Override
    public final Field<T> otherwise(Field<T> result) {
        this.otherwise = result;
        return this;
    }

    @Override
    public final CaseWhenStep<V, T> when(V compareValue, T result) {
        return this.when(Tools.field(compareValue, this.value), Tools.field(result));
    }

    @Override
    public final CaseWhenStep<V, T> when(V compareValue, Field<T> result) {
        return this.when(Tools.field(compareValue, this.value), result);
    }

    @Override
    public final CaseWhenStep<V, T> when(Field<V> compareValue, T result) {
        return this.when(compareValue, Tools.field(result));
    }

    @Override
    public final CaseWhenStep<V, T> when(Field<V> compareValue, Field<T> result) {
        this.compareValues.add(compareValue);
        this.results.add(result);
        return this;
    }

    @Override
    public final CaseWhenStep<V, T> mapValues(Map<V, T> values) {
        for (Map.Entry<V, T> entry : values.entrySet()) {
            this.when(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public final CaseWhenStep<V, T> mapFields(Map<? extends Field<V>, ? extends Field<T>> fields) {
        for (Map.Entry<Field<V>, Field<T>> entry : fields.entrySet()) {
            this.when(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    final QueryPart getFunction0(Configuration configuration) {
        switch (configuration.dialect().family()) {
            default: 
        }
        return new Native();
    }

    private class Native
    extends Base {
        private static final long serialVersionUID = 7564667836130498156L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.formatIndentLockStart().visit(Keywords.K_CASE);
            int size = CaseWhenStepImpl.this.compareValues.size();
            switch (ctx.configuration().dialect()) {
                case DERBY: {
                    ctx.formatIndentLockStart();
                    for (int i = 0; i < size; ++i) {
                        if (i > 0) {
                            ctx.formatNewLine();
                        }
                        ctx.sql(' ').visit(Keywords.K_WHEN).sql(' ');
                        ctx.visit(CaseWhenStepImpl.this.value.equal((Field)CaseWhenStepImpl.this.compareValues.get(i)));
                        ctx.sql(' ').visit(Keywords.K_THEN).sql(' ');
                        ctx.visit((QueryPart)CaseWhenStepImpl.this.results.get(i));
                    }
                    break;
                }
                default: {
                    ctx.sql(' ').visit(CaseWhenStepImpl.this.value).formatIndentStart();
                    for (int i = 0; i < size; ++i) {
                        ctx.formatSeparator().visit(Keywords.K_WHEN).sql(' ').visit((QueryPart)CaseWhenStepImpl.this.compareValues.get(i)).sql(' ').visit(Keywords.K_THEN).sql(' ').visit((QueryPart)CaseWhenStepImpl.this.results.get(i));
                    }
                }
            }
            if (CaseWhenStepImpl.this.otherwise != null) {
                ctx.formatSeparator().visit(Keywords.K_ELSE).sql(' ').visit(CaseWhenStepImpl.this.otherwise);
            }
            ctx.formatIndentEnd();
            if (size > 1 || CaseWhenStepImpl.this.otherwise != null) {
                ctx.formatSeparator();
            } else {
                ctx.sql(' ');
            }
            ctx.visit(Keywords.K_END).formatIndentLockEnd();
        }
    }

    private abstract class Base
    extends AbstractQueryPart {
        private static final long serialVersionUID = 6146002888421945901L;

        private Base() {
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return null;
        }
    }
}

