/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nutch.parse;

import org.apache.hadoop.conf.Configurable;

import org.apache.nutch.plugin.Pluggable;
import org.apache.nutch.protocol.Content;

/**
 * A parser for content generated by a
 * {@link org.apache.nutch.protocol.Protocol} implementation. This interface is
 * implemented by extensions. Nutch's core contains no page parsing code.
 */
public interface Parser extends Pluggable, Configurable {
  /** The name of the extension point. */
  public final static String X_POINT_ID = Parser.class.getName();

  /**
   * <p>
   * This method parses the given content and returns a map of &lt;key,
   * parse&gt; pairs. {@link Parse} instances will be persisted under the given
   * key.
   * </p>
   * <p>
   * Note: Meta-redirects should be followed only when they are coming from the
   * original URL. That is: <br>
   * Assume fetcher is in parsing mode and is currently processing
   * foo.bar.com/redirect.html. If this url contains a meta redirect to another
   * url, fetcher should only follow the redirect if the map contains an entry
   * of the form &lt;"foo.bar.com/redirect.html", {@link Parse} with a
   * {@link ParseStatus} indicating the redirect&gt;.
   * </p>
   * 
   * @param c
   *          Content to be parsed
   * @return a map containing &lt;key, parse&gt; pairs
   * @since NUTCH-443
   */
  ParseResult getParse(Content c);
}
