/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.DenyAllPermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorizationManagerFactory;
import org.springframework.security.authorization.DefaultAuthorizationManagerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public abstract class AbstractSecurityExpressionHandler<T>
implements SecurityExpressionHandler<T>,
ApplicationContextAware {
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private @Nullable BeanResolver beanResolver;
    private @Nullable RoleHierarchy roleHierarchy;
    private AuthorizationManagerFactory<T> authorizationManagerFactory = new DefaultAuthorizationManagerFactory();
    private PermissionEvaluator permissionEvaluator = new DenyAllPermissionEvaluator();

    @Override
    public final ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public final void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"expressionParser cannot be null");
        this.expressionParser = expressionParser;
    }

    @Override
    public final EvaluationContext createEvaluationContext(@Nullable Authentication authentication, T invocation) {
        SecurityExpressionOperations root = this.createSecurityExpressionRoot(authentication, invocation);
        StandardEvaluationContext ctx = this.createEvaluationContextInternal(authentication, invocation);
        if (this.beanResolver != null) {
            ctx.setBeanResolver(this.beanResolver);
        }
        ctx.setRootObject((Object)root);
        return ctx;
    }

    protected StandardEvaluationContext createEvaluationContextInternal(@Nullable Authentication authentication, T invocation) {
        return new StandardEvaluationContext();
    }

    protected abstract SecurityExpressionOperations createSecurityExpressionRoot(@Nullable Authentication var1, T var2);

    public final void setAuthorizationManagerFactory(AuthorizationManagerFactory<T> authorizationManagerFactory) {
        Assert.notNull(authorizationManagerFactory, (String)"authorizationManagerFactory cannot be null");
        this.authorizationManagerFactory = authorizationManagerFactory;
    }

    protected final AuthorizationManagerFactory<T> getAuthorizationManagerFactory() {
        return this.authorizationManagerFactory;
    }

    @Deprecated(since="7.0")
    protected final DefaultAuthorizationManagerFactory<T> getDefaultAuthorizationManagerFactory() {
        AuthorizationManagerFactory<T> authorizationManagerFactory = this.authorizationManagerFactory;
        if (!(authorizationManagerFactory instanceof DefaultAuthorizationManagerFactory)) {
            throw new IllegalStateException("authorizationManagerFactory must be an instance of DefaultAuthorizationManagerFactory");
        }
        DefaultAuthorizationManagerFactory defaultAuthorizationManagerFactory = (DefaultAuthorizationManagerFactory)authorizationManagerFactory;
        return defaultAuthorizationManagerFactory;
    }

    @Deprecated(since="7.0")
    protected @Nullable RoleHierarchy getRoleHierarchy() {
        return this.roleHierarchy;
    }

    @Deprecated(since="7.0")
    public void setRoleHierarchy(@Nullable RoleHierarchy roleHierarchy) {
        if (roleHierarchy != null) {
            this.getDefaultAuthorizationManagerFactory().setRoleHierarchy(roleHierarchy);
        }
        this.roleHierarchy = roleHierarchy;
    }

    protected PermissionEvaluator getPermissionEvaluator() {
        return this.permissionEvaluator;
    }

    public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
        this.permissionEvaluator = permissionEvaluator;
    }

    protected @Nullable BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.beanResolver = new BeanFactoryResolver((BeanFactory)applicationContext);
    }
}

