/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.BatchSettingsDTO;

@XmlType(name="remoteProcessGroupPort")
public class RemoteProcessGroupPortDTO {
    private String id;
    private String targetId;
    private String versionedComponentId;
    private String groupId;
    private String name;
    private String comments;
    private Integer concurrentlySchedulableTaskCount;
    private Boolean transmitting;
    private Boolean useCompression;
    private Boolean exists;
    private Boolean targetRunning;
    private Boolean connected;
    private BatchSettingsDTO batchSettings;

    @Schema(description="The comments as configured on the target port.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Schema(description="The ID of the corresponding component that is under version control")
    public String getVersionedComponentId() {
        return this.versionedComponentId;
    }

    public void setVersionedComponentId(String id) {
        this.versionedComponentId = id;
    }

    @Schema(description="The number of task that may transmit flowfiles to the target port concurrently.")
    public Integer getConcurrentlySchedulableTaskCount() {
        return this.concurrentlySchedulableTaskCount;
    }

    public void setConcurrentlySchedulableTaskCount(Integer concurrentlySchedulableTaskCount) {
        this.concurrentlySchedulableTaskCount = concurrentlySchedulableTaskCount;
    }

    @Schema(description="The id of the port.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The id of the target port.")
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @Schema(description="The id of the remote process group that the port resides in.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The name of the target port.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="Whether the remote port is configured for transmission.")
    public Boolean isTransmitting() {
        return this.transmitting;
    }

    public void setTransmitting(Boolean transmitting) {
        this.transmitting = transmitting;
    }

    @Schema(description="Whether the flowfiles are compressed when sent to the target port.")
    public Boolean getUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(Boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Schema(description="Whether the target port exists.")
    public Boolean getExists() {
        return this.exists;
    }

    public void setExists(Boolean exists) {
        this.exists = exists;
    }

    @Schema(description="Whether the target port is running.")
    public Boolean isTargetRunning() {
        return this.targetRunning;
    }

    public void setTargetRunning(Boolean targetRunning) {
        this.targetRunning = targetRunning;
    }

    @Schema(description="Whether the port has either an incoming or outgoing connection.")
    public Boolean isConnected() {
        return this.connected;
    }

    public void setConnected(Boolean connected) {
        this.connected = connected;
    }

    @Schema(description="The batch settings for data transmission.")
    public BatchSettingsDTO getBatchSettings() {
        return this.batchSettings;
    }

    public void setBatchSettings(BatchSettingsDTO batchSettings) {
        this.batchSettings = batchSettings;
    }

    public int hashCode() {
        return 923847 + String.valueOf(this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteProcessGroupPortDTO)) {
            return false;
        }
        RemoteProcessGroupPortDTO other = (RemoteProcessGroupPortDTO)obj;
        if (this.name == null && other.name == null) {
            return true;
        }
        if (this.name == null) {
            return false;
        }
        return this.name.equals(other.name);
    }
}

