/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.VersionedFlowDTO;
import org.apache.nifi.web.api.entity.VersionedFlowsEntity;

public class RegistryFlowsResult
extends AbstractWritableResult<VersionedFlowsEntity> {
    final VersionedFlowsEntity flowsEntity;

    public RegistryFlowsResult(ResultType resultType, VersionedFlowsEntity flowsEntity) {
        super(resultType);
        this.flowsEntity = Objects.requireNonNull(flowsEntity);
    }

    @Override
    public VersionedFlowsEntity getResult() {
        return this.flowsEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        Set flows = this.flowsEntity.getVersionedFlows();
        if (flows == null || flows.isEmpty()) {
            return;
        }
        List<VersionedFlowDTO> flowsDTO = flows.stream().map(f -> f.getVersionedFlow()).sorted(Comparator.comparing(VersionedFlowDTO::getFlowName)).toList();
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Description", 11, 40, true).build();
        for (int i = 0; i < flowsDTO.size(); ++i) {
            VersionedFlowDTO flow = flowsDTO.get(i);
            table.addRow("" + (i + 1), flow.getFlowName(), flow.getFlowId(), flow.getDescription() == null ? "" : flow.getDescription());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

