/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.io.IOException;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultCancellableSshFuture;

public class DefaultOpenFuture
extends DefaultCancellableSshFuture<OpenFuture>
implements OpenFuture {
    public DefaultOpenFuture(Object id, Object lock) {
        super(id, lock);
    }

    @Override
    public OpenFuture verify(long timeoutMillis, CancelOption ... options) throws IOException {
        Boolean result = this.verifyResult(Boolean.class, timeoutMillis, options);
        if (!result.booleanValue()) {
            throw this.formatExceptionMessage(SshException::new, "Channel opening failed while waiting %d msec.", timeoutMillis);
        }
        return this;
    }

    @Override
    public boolean isOpened() {
        Object value = this.getValue();
        return value instanceof Boolean && (Boolean)value != false;
    }

    @Override
    public void setOpened() {
        this.setValue(Boolean.TRUE);
    }
}

