/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.access.CompositeAccessDeniedHandler;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.access.ObservationMarkingAccessDeniedHandler;
import org.springframework.security.web.csrf.CsrfAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.security.web.session.InvalidSessionAccessDeniedHandler;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CsrfBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String REQUEST_DATA_VALUE_PROCESSOR = "requestDataValueProcessor";
    private static final String ATT_MATCHER = "request-matcher-ref";
    private static final String ATT_REPOSITORY = "token-repository-ref";
    private static final String ATT_REQUEST_HANDLER = "request-handler-ref";
    private static final boolean webMvcPresent;
    private String csrfRepositoryRef;
    private BeanDefinition csrfFilter;
    private String requestMatcherRef;
    private String requestHandlerRef;
    private BeanMetadataElement observationRegistry;

    public BeanDefinition parse(Element element, ParserContext pc) {
        boolean disabled;
        boolean bl = disabled = element != null && "true".equals(element.getAttribute("disabled"));
        if (disabled) {
            return null;
        }
        if (webMvcPresent && !pc.getRegistry().containsBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(CsrfRequestDataValueProcessor.class);
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)beanDefinition, REQUEST_DATA_VALUE_PROCESSOR);
            pc.registerBeanComponent(componentDefinition);
        }
        if (element != null) {
            this.csrfRepositoryRef = element.getAttribute(ATT_REPOSITORY);
            this.requestMatcherRef = element.getAttribute(ATT_MATCHER);
            this.requestHandlerRef = element.getAttribute(ATT_REQUEST_HANDLER);
        }
        if (!StringUtils.hasText((String)this.csrfRepositoryRef)) {
            BeanDefinitionBuilder httpSessionCsrfTokenRepository = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionCsrfTokenRepository.class);
            this.csrfRepositoryRef = pc.getReaderContext().generateBeanName((BeanDefinition)httpSessionCsrfTokenRepository.getBeanDefinition());
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)httpSessionCsrfTokenRepository.getBeanDefinition(), this.csrfRepositoryRef));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CsrfFilter.class);
        builder.addConstructorArgReference(this.csrfRepositoryRef);
        if (StringUtils.hasText((String)this.requestMatcherRef)) {
            builder.addPropertyReference("requireCsrfProtectionMatcher", this.requestMatcherRef);
        }
        if (StringUtils.hasText((String)this.requestHandlerRef)) {
            builder.addPropertyReference("requestHandler", this.requestHandlerRef);
        }
        this.csrfFilter = builder.getBeanDefinition();
        return this.csrfFilter;
    }

    void initAccessDeniedHandler(BeanDefinition invalidSessionStrategy, BeanMetadataElement defaultDeniedHandler) {
        BeanMetadataElement accessDeniedHandler = this.createAccessDeniedHandler(invalidSessionStrategy, defaultDeniedHandler);
        this.csrfFilter.getPropertyValues().addPropertyValue("accessDeniedHandler", (Object)accessDeniedHandler);
    }

    private BeanMetadataElement createAccessDeniedHandler(BeanDefinition invalidSessionStrategy, BeanMetadataElement defaultDeniedHandler) {
        if (invalidSessionStrategy == null) {
            return defaultDeniedHandler;
        }
        ManagedMap handlers = new ManagedMap();
        BeanDefinitionBuilder invalidSessionHandlerBldr = BeanDefinitionBuilder.rootBeanDefinition(InvalidSessionAccessDeniedHandler.class);
        invalidSessionHandlerBldr.addConstructorArgValue((Object)invalidSessionStrategy);
        handlers.put(MissingCsrfTokenException.class, (Object)invalidSessionHandlerBldr.getBeanDefinition());
        BeanDefinitionBuilder deniedBldr = BeanDefinitionBuilder.rootBeanDefinition(DelegatingAccessDeniedHandler.class);
        deniedBldr.addConstructorArgValue((Object)handlers);
        deniedBldr.addConstructorArgValue((Object)defaultDeniedHandler);
        AbstractBeanDefinition denied = deniedBldr.getBeanDefinition();
        ManagedList compositeList = new ManagedList();
        BeanDefinitionBuilder compositeBldr = BeanDefinitionBuilder.rootBeanDefinition(CompositeAccessDeniedHandler.class);
        AbstractBeanDefinition observing = BeanDefinitionBuilder.rootBeanDefinition(ObservationMarkingAccessDeniedHandler.class).addConstructorArgValue((Object)this.observationRegistry).getBeanDefinition();
        compositeList.add((Object)denied);
        compositeList.add((Object)observing);
        compositeBldr.addConstructorArgValue((Object)compositeList);
        return compositeBldr.getBeanDefinition();
    }

    BeanDefinition getCsrfAuthenticationStrategy() {
        BeanDefinitionBuilder csrfAuthenticationStrategy = BeanDefinitionBuilder.rootBeanDefinition(CsrfAuthenticationStrategy.class);
        csrfAuthenticationStrategy.addConstructorArgReference(this.csrfRepositoryRef);
        if (StringUtils.hasText((String)this.requestHandlerRef)) {
            csrfAuthenticationStrategy.addPropertyReference("requestHandler", this.requestHandlerRef);
        }
        return csrfAuthenticationStrategy.getBeanDefinition();
    }

    BeanDefinition getCsrfLogoutHandler() {
        BeanDefinitionBuilder csrfAuthenticationStrategy = BeanDefinitionBuilder.rootBeanDefinition(CsrfLogoutHandler.class);
        csrfAuthenticationStrategy.addConstructorArgReference(this.csrfRepositoryRef);
        return csrfAuthenticationStrategy.getBeanDefinition();
    }

    void setIgnoreCsrfRequestMatchers(List<BeanDefinition> requestMatchers) {
        if (!requestMatchers.isEmpty()) {
            RootBeanDefinition requestMatcher = !StringUtils.hasText((String)this.requestMatcherRef) ? new RootBeanDefinition(DefaultRequiresCsrfMatcher.class) : new RuntimeBeanReference(this.requestMatcherRef);
            BeanDefinitionBuilder and = BeanDefinitionBuilder.rootBeanDefinition(AndRequestMatcher.class);
            BeanDefinitionBuilder negated = BeanDefinitionBuilder.rootBeanDefinition(NegatedRequestMatcher.class);
            BeanDefinitionBuilder or = BeanDefinitionBuilder.rootBeanDefinition(OrRequestMatcher.class);
            or.addConstructorArgValue(requestMatchers);
            negated.addConstructorArgValue((Object)or.getBeanDefinition());
            ManagedList ands = new ManagedList();
            ands.add(requestMatcher);
            ands.add(negated.getBeanDefinition());
            and.addConstructorArgValue((Object)ands);
            this.csrfFilter.getPropertyValues().add("requireCsrfProtectionMatcher", (Object)and.getBeanDefinition());
        }
    }

    void setObservationRegistry(BeanMetadataElement observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    static {
        ClassLoader classLoader = CsrfBeanDefinitionParser.class.getClassLoader();
        webMvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)classLoader);
    }

    private static final class DefaultRequiresCsrfMatcher
    implements RequestMatcher {
        private final HashSet<String> allowedMethods = new HashSet<String>(Arrays.asList("GET", "HEAD", "TRACE", "OPTIONS"));

        private DefaultRequiresCsrfMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            return !this.allowedMethods.contains(request.getMethod());
        }
    }
}

