/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.util.List;
import lombok.Generated;

public enum Tier {
    COMMUNITY("Community"),
    TEAMS("Teams"),
    ENTERPRISE("Enterprise");

    public static final List<Tier> PREMIUM;
    private final String displayName;
    private final String description;

    public static boolean isAtLeast(Tier tier, Tier minimumTier) {
        if (minimumTier == null) {
            return true;
        }
        if (tier == null) {
            return false;
        }
        return tier.ordinal() >= minimumTier.ordinal();
    }

    private Tier(String displayName) {
        this.displayName = displayName;
        this.description = "Flyway " + displayName + " Edition";
    }

    public static String asString(Tier tier) {
        if (tier == null) {
            return "OSS";
        }
        return tier.toString();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    static {
        PREMIUM = List.of(TEAMS, ENTERPRISE);
    }
}

