/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.registry.event.StandardEventField;
import org.apache.nifi.registry.hook.Event;
import org.apache.nifi.registry.hook.EventField;
import org.apache.nifi.registry.hook.EventFieldName;
import org.apache.nifi.registry.hook.EventType;

public class StandardEvent
implements Event {
    private final EventType eventType;
    private final List<EventField> eventFields;

    private StandardEvent(Builder builder) {
        this.eventType = Objects.requireNonNull(builder.eventType);
        this.eventFields = Collections.unmodifiableList(builder.eventFields == null ? Collections.emptyList() : new ArrayList<EventField>(builder.eventFields));
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public List<EventField> getFields() {
        return this.eventFields;
    }

    public EventField getField(EventFieldName fieldName) {
        if (fieldName == null) {
            return null;
        }
        return this.eventFields.stream().filter(e -> fieldName.equals((Object)e.getName())).findFirst().orElse(null);
    }

    public void validate() throws IllegalStateException {
        int numRequiredFields;
        int numProvidedFields = this.eventFields.size();
        if (numProvidedFields != (numRequiredFields = this.eventType.getFieldNames().size())) {
            throw new IllegalStateException(numRequiredFields + " fields were required, but only " + numProvidedFields + " were provided");
        }
        for (int i = 0; i < numRequiredFields; ++i) {
            EventFieldName provided;
            EventFieldName required = (EventFieldName)this.eventType.getFieldNames().get(i);
            if (required.equals((Object)(provided = this.eventFields.get(i).getName()))) continue;
            throw new IllegalStateException("Expected " + required.name() + ", but found " + provided.name());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardEvent that = (StandardEvent)o;
        return this.eventType == that.eventType && Objects.equals(this.eventFields, that.eventFields);
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.eventFields);
    }

    public String toString() {
        return "StandardEvent{eventType=" + String.valueOf(this.eventType) + ", eventFields=" + String.valueOf(this.eventFields) + "}";
    }

    public static class Builder {
        private EventType eventType;
        private List<EventField> eventFields = new ArrayList<EventField>();

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder addField(EventFieldName name, String value) {
            this.eventFields.add(new StandardEventField(name, value));
            return this;
        }

        public Builder addField(EventField arg) {
            if (arg != null) {
                this.eventFields.add(arg);
            }
            return this;
        }

        public Builder addFields(Collection<EventField> fields) {
            if (fields != null) {
                this.eventFields.addAll(fields);
            }
            return this;
        }

        public Builder clearFields() {
            this.eventFields.clear();
            return this;
        }

        public Event build() {
            return new StandardEvent(this);
        }
    }
}

