/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class Window
extends AbstractLoggingBean
implements ChannelHolder,
Closeable {
    protected final Object lock = new Object();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Channel channelInstance;
    private final String suffix;
    private long size;
    private long maxSize;
    private long packetSize;

    protected Window(Channel channel, boolean isClient) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel provided");
        this.suffix = isClient ? "client" : "server";
    }

    protected static Predicate<Window> largerThan(long minSize) {
        return window -> window.size > minSize;
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(long size, long packetSize, PropertyResolver resolver) {
        BufferUtils.validateUint32Value(size, "Illegal initial size: %d");
        BufferUtils.validateUint32Value(packetSize, "Illegal packet size: %d");
        ValidateUtils.checkTrue(packetSize > 0L, "Packet size must be positive: %d", packetSize);
        long limitPacketSize = CoreModuleProperties.LIMIT_PACKET_SIZE.getRequired(resolver);
        if (packetSize > limitPacketSize) {
            throw new IllegalArgumentException("Requested packet size (" + packetSize + ") exceeds max. allowed: " + limitPacketSize);
        }
        Object object = this.lock;
        synchronized (object) {
            this.maxSize = size;
            this.packetSize = packetSize;
            this.updateSize(size);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.initialized.getAndSet(true) && debugEnabled) {
            this.log.debug("init({}) re-initializing", (Object)this);
        }
        if (debugEnabled) {
            this.log.debug("init({}) size={}, max={}, packet={}", new Object[]{this, this.getSize(), this.getMaxSize(), this.getPacketSize()});
        }
    }

    public abstract long consume(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long consumeAll() {
        this.checkInitialized("consumeAll");
        Object object = this.lock;
        synchronized (object) {
            long current = this.size;
            this.size = 0L;
            return current;
        }
    }

    protected void updateSize(long size) {
        BufferUtils.validateUint32Value(size, "Invalid updated size: %d", (Object)size);
        this.size = size;
        this.lock.notifyAll();
    }

    protected void checkInitialized(String location) {
        if (!this.initialized.get()) {
            throw new IllegalStateException(location + " - window not initialized: " + this);
        }
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true) && this.log.isDebugEnabled()) {
            this.log.debug("Closing {}", (Object)this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.suffix + "](" + this.getChannel() + ")";
    }
}

