/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hive.spark.client.BaseProtocol;
import org.apache.hive.spark.client.JobContextImpl;
import org.apache.hive.spark.client.MonitorCallback;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.client.rpc.Rpc;
import org.apache.hive.spark.client.rpc.RpcConfiguration;
import org.apache.hive.spark.counter.SparkCounters;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.Success$;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

@InterfaceAudience.Private
public class RemoteDriver {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDriver.class);
    private final Map<String, JobWrapper<?>> activeJobs;
    private final Object jcLock;
    private final Object shutdownLock;
    private final ExecutorService executor;
    private final NioEventLoopGroup egroup;
    private final Rpc clientRpc;
    private final DriverProtocol protocol;
    private final File localTmpDir;
    private final List<JobWrapper<?>> jobQueue = Lists.newLinkedList();
    private volatile JobContextImpl jc;
    private volatile boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteDriver(String[] args) throws Exception {
        this.activeJobs = Maps.newConcurrentMap();
        this.jcLock = new Object();
        this.shutdownLock = new Object();
        this.localTmpDir = Files.createTempDir();
        this.addShutdownHook();
        SparkConf conf = new SparkConf();
        String serverAddress = null;
        int serverPort = -1;
        for (int idx = 0; idx < args.length; idx += 2) {
            Tuple2[] key = args[idx];
            if (key.equals("--remote-host")) {
                serverAddress = this.getArg(args, idx);
                continue;
            }
            if (key.equals("--remote-port")) {
                serverPort = Integer.parseInt(this.getArg(args, idx));
                continue;
            }
            if (key.equals("--client-id")) {
                conf.set("spark.client.authentication.client_id", this.getArg(args, idx));
                continue;
            }
            if (key.equals("--secret")) {
                conf.set("spark.client.authentication.secret", this.getArg(args, idx));
                continue;
            }
            if (key.equals("--conf")) {
                String[] val = this.getArg(args, idx).split("[=]", 2);
                conf.set(val[0], val[1]);
                continue;
            }
            throw new IllegalArgumentException("Invalid command line: " + Joiner.on(" ").join(args));
        }
        this.executor = Executors.newCachedThreadPool();
        LOG.info("Connecting to: {}:{}", serverAddress, (Object)serverPort);
        HashMap<String, String> mapConf = Maps.newHashMap();
        for (Tuple2 e : conf.getAll()) {
            mapConf.put((String)e._1(), (String)e._2());
            LOG.debug("Remote Driver configured with: " + (String)e._1() + "=" + (String)e._2());
        }
        String clientId = (String)mapConf.get("spark.client.authentication.client_id");
        Preconditions.checkArgument(clientId != null, "No client ID provided.");
        String secret = (String)mapConf.get("spark.client.authentication.secret");
        Preconditions.checkArgument(secret != null, "No secret provided.");
        int threadCount = new RpcConfiguration(mapConf).getRpcThreadCount();
        this.egroup = new NioEventLoopGroup(threadCount, new ThreadFactoryBuilder().setNameFormat("Driver-RPC-Handler-%d").setDaemon(true).build());
        this.protocol = new DriverProtocol();
        this.clientRpc = (Rpc)Rpc.createClient(mapConf, this.egroup, serverAddress, serverPort, clientId, secret, this.protocol).get();
        this.running = true;
        this.clientRpc.addListener(new Rpc.Listener(){

            @Override
            public void rpcClosed(Rpc rpc) {
                LOG.warn("Shutting down driver because RPC channel was closed.");
                RemoteDriver.this.shutdown(null);
            }
        });
        try {
            JavaSparkContext sc = new JavaSparkContext(conf);
            sc.sc().addSparkListener((SparkListenerInterface)new ClientListener());
            Object object = this.jcLock;
            synchronized (object) {
                this.jc = new JobContextImpl(sc, this.localTmpDir);
                this.jcLock.notifyAll();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to start SparkContext: " + e, (Throwable)e);
            this.shutdown(e);
            Object object = this.jcLock;
            synchronized (object) {
                this.jcLock.notifyAll();
            }
            throw e;
        }
        Object object = this.jcLock;
        synchronized (object) {
            Iterator<JobWrapper<?>> it = this.jobQueue.iterator();
            while (it.hasNext()) {
                it.next().submit();
            }
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.running) {
                LOG.info("Received signal SIGTERM, attempting safe shutdown of Remote Spark Context");
                this.protocol.sendErrorMessage("Remote Spark Context was shutdown because it received a SIGTERM signal. Most likely due to a kill request via YARN.");
                this.shutdown(null);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws InterruptedException {
        Object object = this.shutdownLock;
        synchronized (object) {
            while (this.running) {
                this.shutdownLock.wait();
            }
        }
        this.executor.shutdownNow();
        try {
            FileUtils.deleteDirectory((File)this.localTmpDir);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete local tmp dir: " + this.localTmpDir, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(JobWrapper<?> job) {
        Object object = this.jcLock;
        synchronized (object) {
            if (this.jc != null) {
                job.submit();
            } else {
                LOG.info("SparkContext not yet up, queueing job request.");
                this.jobQueue.add(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shutdown(Throwable error) {
        if (this.running) {
            if (error == null) {
                LOG.info("Shutting down remote driver.");
            } else {
                LOG.error("Shutting down remote driver due to error: " + error, error);
            }
            this.running = false;
            for (JobWrapper<?> job : this.activeJobs.values()) {
                this.cancelJob(job);
            }
            if (error != null) {
                this.protocol.sendError(error);
            }
            if (this.jc != null) {
                this.jc.stop();
            }
            this.clientRpc.close();
            this.egroup.shutdownGracefully();
            Object object = this.shutdownLock;
            synchronized (object) {
                this.shutdownLock.notifyAll();
            }
        }
    }

    private boolean cancelJob(JobWrapper<?> job) {
        boolean cancelled = false;
        for (JavaFutureAction action : ((JobWrapper)job).jobs) {
            cancelled |= action.cancel(true);
        }
        return cancelled | (((JobWrapper)job).future != null && ((JobWrapper)job).future.cancel(true));
    }

    private String getArg(String[] args, int keyIdx) {
        int valIdx = keyIdx + 1;
        if (args.length <= valIdx) {
            throw new IllegalArgumentException("Invalid command line: " + Joiner.on(" ").join(args));
        }
        return args[valIdx];
    }

    public static void main(String[] args) throws Exception {
        RemoteDriver rd = new RemoteDriver(args);
        try {
            rd.run();
        }
        catch (Exception e) {
            if (rd.running) {
                rd.protocol.sendError(e);
                rd.shutdown(null);
            }
            throw e;
        }
    }

    private class ClientListener
    extends SparkListener {
        private final Map<Integer, Integer> stageToJobId = Maps.newHashMap();

        private ClientListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onJobStart(SparkListenerJobStart jobStart) {
            Map<Integer, Integer> map = this.stageToJobId;
            synchronized (map) {
                for (int i = 0; i < jobStart.stageIds().length(); ++i) {
                    this.stageToJobId.put((Integer)jobStart.stageIds().apply(i), jobStart.jobId());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onJobEnd(SparkListenerJobEnd jobEnd) {
            Map<Integer, Integer> map = this.stageToJobId;
            synchronized (map) {
                Iterator<Map.Entry<Integer, Integer>> it = this.stageToJobId.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, Integer> e = it.next();
                    if (e.getValue().intValue() != jobEnd.jobId()) continue;
                    it.remove();
                }
            }
            String clientId = this.getClientId(jobEnd.jobId());
            if (clientId != null) {
                ((JobWrapper)RemoteDriver.this.activeJobs.get(clientId)).jobDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
            if (taskEnd.reason() instanceof Success$ && !taskEnd.taskInfo().speculative()) {
                Integer jobId;
                Metrics metrics = new Metrics(taskEnd.taskMetrics(), taskEnd.taskInfo());
                Map<Integer, Integer> map = this.stageToJobId;
                synchronized (map) {
                    jobId = this.stageToJobId.get(taskEnd.stageId());
                }
                String clientId = this.getClientId(jobId);
                if (clientId != null) {
                    RemoteDriver.this.protocol.sendMetrics(clientId, jobId, taskEnd.stageId(), taskEnd.taskInfo().taskId(), metrics);
                }
            }
        }

        private String getClientId(Integer jobId) {
            for (Map.Entry e : RemoteDriver.this.activeJobs.entrySet()) {
                for (JavaFutureAction future : ((JobWrapper)e.getValue()).jobs) {
                    if (!future.jobIds().contains(jobId)) continue;
                    return (String)e.getKey();
                }
            }
            return null;
        }
    }

    private class JobWrapper<T extends Serializable>
    implements Callable<Void> {
        private final BaseProtocol.JobRequest<T> req;
        private final List<JavaFutureAction<?>> jobs;
        private final AtomicInteger jobEndReceived;
        private int completed;
        private SparkCounters sparkCounters;
        private Set<Integer> cachedRDDIds;
        private Integer sparkJobId;
        private Future<?> future;

        JobWrapper(BaseProtocol.JobRequest<T> req) {
            this.req = req;
            this.jobs = Lists.newArrayList();
            this.completed = 0;
            this.jobEndReceived = new AtomicInteger(0);
            this.sparkCounters = null;
            this.cachedRDDIds = null;
            this.sparkJobId = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            RemoteDriver.this.protocol.jobStarted(this.req.id);
            try {
                SparkJobInfo sparkJobInfo;
                RemoteDriver.this.jc.setMonitorCb(new MonitorCallback(){

                    @Override
                    public void call(JavaFutureAction<?> future, SparkCounters sparkCounters, Set<Integer> cachedRDDIds) {
                        JobWrapper.this.monitorJob(future, sparkCounters, cachedRDDIds);
                    }
                });
                Object result = this.req.job.call(RemoteDriver.this.jc);
                for (JavaFutureAction<?> future : this.jobs) {
                    future.get();
                    ++this.completed;
                    LOG.debug("Client job {}: {} of {} Spark jobs finished.", new Object[]{this.req.id, this.completed, this.jobs.size()});
                }
                if (this.sparkJobId != null && (sparkJobInfo = RemoteDriver.this.jc.sc().statusTracker().getJobInfo(this.sparkJobId.intValue())) != null && sparkJobInfo.stageIds() != null && sparkJobInfo.stageIds().length > 0) {
                    AtomicInteger atomicInteger = this.jobEndReceived;
                    synchronized (atomicInteger) {
                        while (this.jobEndReceived.get() < this.jobs.size()) {
                            this.jobEndReceived.wait();
                        }
                    }
                }
                SparkCounters counters = null;
                if (this.sparkCounters != null) {
                    counters = this.sparkCounters.snapshot();
                }
                RemoteDriver.this.protocol.jobFinished(this.req.id, result, null, counters);
            }
            catch (Throwable t) {
                LOG.error("Failed to run job " + this.req.id, t);
                RemoteDriver.this.protocol.jobFinished(this.req.id, null, t, this.sparkCounters != null ? this.sparkCounters.snapshot() : null);
                throw new ExecutionException(t);
            }
            finally {
                RemoteDriver.this.jc.setMonitorCb(null);
                RemoteDriver.this.activeJobs.remove(this.req.id);
                this.releaseCache();
            }
            return null;
        }

        void submit() {
            this.future = RemoteDriver.this.executor.submit(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void jobDone() {
            AtomicInteger atomicInteger = this.jobEndReceived;
            synchronized (atomicInteger) {
                this.jobEndReceived.incrementAndGet();
                this.jobEndReceived.notifyAll();
            }
        }

        void releaseCache() {
            if (this.cachedRDDIds != null) {
                for (Integer cachedRDDId : this.cachedRDDIds) {
                    RemoteDriver.this.jc.sc().sc().unpersistRDD(cachedRDDId.intValue(), false);
                }
            }
        }

        private void monitorJob(JavaFutureAction<?> job, SparkCounters sparkCounters, Set<Integer> cachedRDDIds) {
            this.jobs.add(job);
            if (!RemoteDriver.this.jc.getMonitoredJobs().containsKey(this.req.id)) {
                RemoteDriver.this.jc.getMonitoredJobs().put(this.req.id, new CopyOnWriteArrayList());
            }
            RemoteDriver.this.jc.getMonitoredJobs().get(this.req.id).add(job);
            this.sparkCounters = sparkCounters;
            this.cachedRDDIds = cachedRDDIds;
            this.sparkJobId = (Integer)job.jobIds().get(0);
            RemoteDriver.this.protocol.jobSubmitted(this.req.id, this.sparkJobId);
        }
    }

    private class DriverProtocol
    extends BaseProtocol {
        private DriverProtocol() {
        }

        void sendError(Throwable error) {
            LOG.debug("Send error to Client: {}", (Object)Throwables.getStackTraceAsString(error));
            RemoteDriver.this.clientRpc.call(new BaseProtocol.Error(Throwables.getStackTraceAsString(error)));
        }

        void sendErrorMessage(String cause) {
            LOG.debug("Send error to Client: {}", (Object)cause);
            RemoteDriver.this.clientRpc.call(new BaseProtocol.Error(cause));
        }

        <T extends Serializable> void jobFinished(String jobId, T result, Throwable error, SparkCounters counters) {
            LOG.debug("Send job({}) result to Client.", (Object)jobId);
            RemoteDriver.this.clientRpc.call(new BaseProtocol.JobResult<T>(jobId, result, error, counters));
        }

        void jobStarted(String jobId) {
            RemoteDriver.this.clientRpc.call(new BaseProtocol.JobStarted(jobId));
        }

        void jobSubmitted(String jobId, int sparkJobId) {
            LOG.debug("Send job({}/{}) submitted to Client.", (Object)jobId, (Object)sparkJobId);
            RemoteDriver.this.clientRpc.call(new BaseProtocol.JobSubmitted(jobId, sparkJobId));
        }

        void sendMetrics(String jobId, int sparkJobId, int stageId, long taskId, Metrics metrics) {
            LOG.debug("Send task({}/{}/{}/{}) metric to Client.", new Object[]{jobId, sparkJobId, stageId, taskId});
            RemoteDriver.this.clientRpc.call(new BaseProtocol.JobMetrics(jobId, sparkJobId, stageId, taskId, metrics));
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.CancelJob msg) {
            JobWrapper job = (JobWrapper)RemoteDriver.this.activeJobs.get(msg.id);
            if (job == null || !RemoteDriver.this.cancelJob(job)) {
                LOG.info("Requested to cancel an already finished job.");
            }
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.EndSession msg) {
            LOG.debug("Shutting down due to EndSession request.");
            RemoteDriver.this.shutdown(null);
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.JobRequest msg) {
            LOG.info("Received job request {}", (Object)msg.id);
            JobWrapper wrapper = new JobWrapper(msg);
            RemoteDriver.this.activeJobs.put(msg.id, wrapper);
            RemoteDriver.this.submit(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object handle(ChannelHandlerContext ctx, BaseProtocol.SyncJobRequest msg) throws Exception {
            Object object;
            if (RemoteDriver.this.jc == null) {
                object = RemoteDriver.this.jcLock;
                synchronized (object) {
                    while (RemoteDriver.this.jc == null) {
                        RemoteDriver.this.jcLock.wait();
                        if (RemoteDriver.this.running) continue;
                        throw new IllegalStateException("Remote context is shutting down.");
                    }
                }
            }
            RemoteDriver.this.jc.setMonitorCb(new MonitorCallback(){

                @Override
                public void call(JavaFutureAction<?> future, SparkCounters sparkCounters, Set<Integer> cachedRDDIds) {
                    throw new IllegalStateException("JobContext.monitor() is not available for synchronous jobs.");
                }
            });
            try {
                object = msg.job.call(RemoteDriver.this.jc);
                return object;
            }
            finally {
                RemoteDriver.this.jc.setMonitorCb(null);
            }
        }
    }
}

