/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.SearchService;
import org.apache.linkis.cs.client.service.VariableService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.object.LinkisVariable;
import org.apache.linkis.cs.common.entity.source.CommonContextValue;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVariableService
implements VariableService {
    private static final Logger logger = LoggerFactory.getLogger(CSVariableService.class);
    private SearchService searchService = DefaultSearchService.getInstance();
    private static CSVariableService csVariableService;

    private CSVariableService() {
    }

    @Override
    public List<LinkisVariable> getUpstreamVariables(String contextIDStr, String nodeName) throws CSErrorException {
        List<LinkisVariable> rsList = new ArrayList<LinkisVariable>();
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return rsList;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            if (null != contextID && null != (rsList = this.searchService.searchUpstreamContext(contextID, nodeName, Integer.MAX_VALUE, LinkisVariable.class))) {
                logger.info("contextID: {} and nodeName: {} succeed to getUpstreamVariables size {}", new Object[]{contextID.getContextId(), nodeName, rsList.size()});
            }
            return rsList;
        }
        catch (Throwable e) {
            logger.error("Failed to get variable : " + contextIDStr, e);
            return rsList;
        }
    }

    @Override
    public void putVariable(String contextIDStr, String contextKeyStr, LinkisVariable linkisVariable) throws CSErrorException {
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            ContextKey contextKey = SerializeHelper.deserializeContextKey(contextKeyStr);
            CommonContextValue contextValue = new CommonContextValue();
            contextValue.setValue((Object)linkisVariable);
            contextClient.update(contextID, contextKey, (ContextValue)contextValue);
            logger.info("contextID: {} and contextKeyStr: {} succeed to putVariable {}", new Object[]{contextID.getContextId(), contextKeyStr, linkisVariable.getValue()});
        }
        catch (ErrorException e) {
            logger.error("Deserialize error. e ");
            throw new CSErrorException(70112, "Deserialize error. e : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSVariableService getInstance() {
        if (null != csVariableService) return csVariableService;
        Class<CSVariableService> clazz = CSVariableService.class;
        synchronized (CSVariableService.class) {
            if (null != csVariableService) return csVariableService;
            csVariableService = new CSVariableService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csVariableService;
        }
    }
}

