/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.registry.impl;

import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.registry.impl.ServiceInstanceBase;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezAmInstance
extends ServiceInstanceBase {
    private static final Logger LOG = LoggerFactory.getLogger(TezAmInstance.class);
    private final int pluginPort;
    private Token<JobTokenIdentifier> token;

    TezAmInstance(ServiceRecord srv) throws IOException {
        super(srv, "tez-client");
        Endpoint plugin = srv.getInternalEndpoint("llap-plugin");
        this.pluginPort = plugin != null ? Integer.parseInt(RegistryTypeUtils.getAddressField((Map)((Map)plugin.addresses.get(0)), (String)"port")) : -1;
    }

    public int getPluginPort() {
        return this.pluginPort;
    }

    public String getSessionId() {
        return this.getProperties().get("am.session.id");
    }

    public int getGuaranteedCount() {
        String str = this.getProperties().get("am.guaranteed.count");
        if (!StringUtils.isEmpty(str)) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public String getPluginTokenJobId() {
        return this.getProperties().get("am.plugin.jobid");
    }

    public Token<JobTokenIdentifier> getPluginToken() {
        if (this.token != null) {
            return this.token;
        }
        String tokenString = this.getProperties().get("am.plugin.token");
        if (tokenString == null || tokenString.isEmpty()) {
            return null;
        }
        byte[] tokenBytes = Base64.decodeBase64((String)tokenString);
        Token token = new Token();
        try {
            token.readFields((DataInput)ByteStreams.newDataInput(tokenBytes));
        }
        catch (IOException e) {
            LOG.error("Couldn't read the plugin token from [" + tokenString + "]", (Throwable)e);
            return null;
        }
        this.token = token;
        return token;
    }

    @Override
    public String toString() {
        return "TezAmInstance [" + this.getSessionId() + ", host=" + this.getHost() + ", rpcPort=" + this.getRpcPort() + ", pluginPort=" + this.pluginPort + ", token=" + this.token + "]";
    }
}

