/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.HashSet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class UpdateInputAccessTimeHook {
    private static final String LAST_ACCESS_TIME = "lastAccessTime";

    public static class PreExec
    implements ExecuteWithHookContext {
        @Override
        public void run(HookContext hookContext) throws Exception {
            Hive db;
            HiveConf conf = hookContext.getConf();
            HashSet<ReadEntity> inputs = hookContext.getQueryPlan().getInputs();
            try {
                db = Hive.get(conf);
            }
            catch (HiveException e) {
                Object db2 = null;
                return;
            }
            int lastAccessTime = (int)(System.currentTimeMillis() / 1000L);
            for (ReadEntity re : inputs) {
                Entity.Type typ = re.getType();
                switch (typ) {
                    case TABLE: {
                        String dbName = re.getTable().getDbName();
                        String tblName = re.getTable().getTableName();
                        Table t = db.getTable(dbName, tblName);
                        t.setLastAccessTime(lastAccessTime);
                        db.alterTable(dbName + "." + tblName, t, null);
                        break;
                    }
                    case PARTITION: {
                        String dbName = re.getTable().getDbName();
                        String tblName = re.getTable().getTableName();
                        Partition p = re.getPartition();
                        Table t = db.getTable(dbName, tblName);
                        p = db.getPartition(t, p.getSpec(), false);
                        p.setLastAccessTime(lastAccessTime);
                        db.alterPartition(dbName, tblName, p, null);
                        t.setLastAccessTime(lastAccessTime);
                        db.alterTable(dbName + "." + tblName, t, null);
                        break;
                    }
                }
            }
        }
    }
}

