/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlCastConverter;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.adapter.druid.Granularities;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class TimeExtractionFunction
implements ExtractionFunction {
    private static final ImmutableSet<TimeUnitRange> VALID_TIME_EXTRACT = Sets.immutableEnumSet((Enum)TimeUnitRange.YEAR, (Enum[])new TimeUnitRange[]{TimeUnitRange.MONTH, TimeUnitRange.DAY, TimeUnitRange.WEEK, TimeUnitRange.HOUR, TimeUnitRange.MINUTE, TimeUnitRange.SECOND});
    private static final ImmutableSet<TimeUnitRange> VALID_TIME_FLOOR = Sets.immutableEnumSet((Enum)TimeUnitRange.YEAR, (Enum[])new TimeUnitRange[]{TimeUnitRange.MONTH, TimeUnitRange.DAY, TimeUnitRange.WEEK, TimeUnitRange.HOUR, TimeUnitRange.MINUTE, TimeUnitRange.SECOND});
    public static final String ISO_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private final String format;
    private final Granularity granularity;
    private final String timeZone;
    private final String local;

    public TimeExtractionFunction(String format, Granularity granularity, String timeZone, String local) {
        this.format = format;
        this.granularity = granularity;
        this.timeZone = timeZone;
        this.local = local;
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "timeFormat");
        DruidQuery.writeFieldIf(generator, "format", this.format);
        DruidQuery.writeFieldIf(generator, "granularity", this.granularity);
        DruidQuery.writeFieldIf(generator, "timeZone", this.timeZone);
        DruidQuery.writeFieldIf(generator, "locale", this.local);
        generator.writeEndObject();
    }

    public String getFormat() {
        return this.format;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public static TimeExtractionFunction createDefault(String timeZone) {
        return new TimeExtractionFunction(ISO_TIME_FORMAT, null, timeZone, null);
    }

    public static TimeExtractionFunction createExtractFromGranularity(Granularity granularity, String timeZone) {
        String local = Locale.US.toLanguageTag();
        switch (granularity.getType()) {
            case DAY: {
                return new TimeExtractionFunction("d", null, timeZone, local);
            }
            case MONTH: {
                return new TimeExtractionFunction("M", null, timeZone, local);
            }
            case YEAR: {
                return new TimeExtractionFunction("yyyy", null, timeZone, local);
            }
            case WEEK: {
                return new TimeExtractionFunction("w", null, timeZone, local);
            }
            case HOUR: {
                return new TimeExtractionFunction("H", null, timeZone, local);
            }
            case MINUTE: {
                return new TimeExtractionFunction("m", null, timeZone, local);
            }
            case SECOND: {
                return new TimeExtractionFunction("s", null, timeZone, local);
            }
        }
        throw new IllegalArgumentException("Granularity [" + granularity + "] is not supported");
    }

    public static TimeExtractionFunction createFloorFromGranularity(Granularity granularity, String timeZone) {
        return new TimeExtractionFunction(ISO_TIME_FORMAT, granularity, timeZone, Locale.ROOT.toLanguageTag());
    }

    public static boolean isValidTimeExtract(RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        if (call.getKind() != SqlKind.EXTRACT || call.getOperands().size() != 2) {
            return false;
        }
        RexLiteral flag = (RexLiteral)call.operands.get(0);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        return timeUnit != null && VALID_TIME_EXTRACT.contains((Object)timeUnit);
    }

    public static boolean isValidTimeFloor(RexNode rexNode) {
        if (rexNode.getKind() != SqlKind.FLOOR) {
            return false;
        }
        RexCall call = (RexCall)rexNode;
        if (call.operands.size() != 2) {
            return false;
        }
        RexLiteral flag = (RexLiteral)call.operands.get(1);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        return timeUnit != null && VALID_TIME_FLOOR.contains((Object)timeUnit);
    }

    @Nullable
    public static TimeExtractionFunction translateCastToTimeExtract(RexNode rexNode, TimeZone timeZone) {
        String timeZoneId;
        assert (rexNode.getKind() == SqlKind.CAST);
        RexCall rexCall = (RexCall)rexNode;
        String castFormat = DruidSqlCastConverter.dateTimeFormatString(rexCall.getType().getSqlTypeName());
        String string = timeZoneId = timeZone == null ? null : timeZone.getID();
        if (castFormat == null) {
            return null;
        }
        if (rexCall.getType().getFamily() == SqlTypeFamily.DATE) {
            return new TimeExtractionFunction(castFormat, Granularities.createGranularity(TimeUnitRange.DAY, timeZoneId), timeZoneId, Locale.ENGLISH.toString());
        }
        if (rexCall.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP || rexCall.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return new TimeExtractionFunction(castFormat, null, timeZoneId, Locale.ENGLISH.toString());
        }
        return null;
    }
}

