/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.restful;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.service.ECResourceInfoService;
import org.apache.linkis.manager.am.util.ECResourceInfoUtils;
import org.apache.linkis.manager.am.vo.ECResourceInfoRecordVo;
import org.apache.linkis.manager.common.entity.persistence.ECResourceInfoRecord;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.security.SecurityFilter;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"enginneconn resource info operation"})
@RequestMapping(path={"/linkisManager/ecinfo"}, produces={"application/json"})
@RestController
public class ECResourceInfoRestfulApi {
    @Autowired
    private ECResourceInfoService ecResourceInfoService;
    private static final Logger logger = LoggerFactory.getLogger(ECResourceInfoRestfulApi.class);

    @ApiOperation(value="get", notes="get engineconn info ", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ticketid", required=true, dataType="String", value="ticket id")})
    @RequestMapping(path={"/get"}, method={RequestMethod.GET})
    public Message getECInfo(HttpServletRequest req, @RequestParam(value="ticketid") String ticketid) throws AMErrorException {
        logger.info("ticked: {} get ec info", (Object)ticketid);
        ECResourceInfoRecord ecResourceInfoRecord = this.ecResourceInfoService.getECResourceInfoRecord(ticketid);
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getECInfo ticketid:" + ticketid));
        if (null != ecResourceInfoRecord && (userName.equalsIgnoreCase(ecResourceInfoRecord.getCreateUser()) || Configuration.isAdmin((String)userName))) {
            return Message.ok().data("ecResourceInfoRecord", (Object)ecResourceInfoRecord);
        }
        return Message.error((String)("tickedId not exist:" + ticketid));
    }

    @ApiOperation(value="delete", notes="delete engineconn info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ticketid", required=true, dataType="String", value="ticket id")})
    @RequestMapping(path={"/delete/{ticketid}}"}, method={RequestMethod.DELETE})
    public Message deleteECInfo(HttpServletRequest req, @PathVariable(value="ticketid") String ticketid) throws AMErrorException {
        ECResourceInfoRecord ecResourceInfoRecord = this.ecResourceInfoService.getECResourceInfoRecord(ticketid);
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("deleteECInfo ticketid:" + ticketid));
        if (null != ecResourceInfoRecord && (userName.equalsIgnoreCase(ecResourceInfoRecord.getCreateUser()) || Configuration.isAdmin((String)userName))) {
            this.ecResourceInfoService.deleteECResourceInfoRecord(ecResourceInfoRecord.getId());
            return Message.ok().data("ecResourceInfoRecord", (Object)ecResourceInfoRecord);
        }
        return Message.error((String)("tickedId not exist:" + ticketid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="ecrHistoryList", notes="query engineconn resource history info list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="instance", dataType="String", value="instance"), @ApiImplicitParam(name="creator", dataType="String", value="creator"), @ApiImplicitParam(name="startDate", dataType="String", value="start date"), @ApiImplicitParam(name="endDate", dataType="String", value="end date"), @ApiImplicitParam(name="engineType", dataType="String", value="engine type"), @ApiImplicitParam(name="status", dataType="String", value="engine status"), @ApiImplicitParam(name="pageNow", dataType="String", value="page now"), @ApiImplicitParam(name="pageSize", dataType="String", value="page size")})
    @RequestMapping(path={"/ecrHistoryList"}, method={RequestMethod.GET})
    public Message queryEcrHistory(HttpServletRequest req, @RequestParam(value="instance", required=false) String instance, @RequestParam(value="creator", required=false) String creator, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") @RequestParam(value="startDate", required=false) Date startDate, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") @RequestParam(value="endDate", required=false, defaultValue="#{new java.util.Date()}") Date endDate, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="status", required=false) String status, @RequestParam(value="pageNow", required=false, defaultValue="1") Integer pageNow, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        instance = ECResourceInfoUtils.strCheckAndDef(instance, null);
        String creatorUser = ECResourceInfoUtils.strCheckAndDef(creator, null);
        engineType = ECResourceInfoUtils.strCheckAndDef(engineType, null);
        status = ECResourceInfoUtils.strCheckAndDef(status, null);
        if (null != creatorUser && !ECResourceInfoUtils.checkNameValid(creatorUser)) {
            return Message.error((String)("Invalid creator : " + creatorUser));
        }
        if (null == startDate) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            startDate = calendar.getTime();
        }
        if (Configuration.isJobHistoryAdmin((String)username)) {
            username = null;
            if (StringUtils.isNotBlank((CharSequence)creatorUser)) {
                username = creatorUser;
            }
        }
        ArrayList list = new ArrayList();
        List<ECResourceInfoRecord> queryTasks = null;
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            queryTasks = this.ecResourceInfoService.getECResourceInfoRecordList(instance, endDate, startDate, username, engineType, status);
            queryTasks.forEach(info -> {
                ECResourceInfoRecordVo ecrHistroryListVo = new ECResourceInfoRecordVo();
                BeanUtils.copyProperties((Object)info, (Object)ecrHistroryListVo);
                ecrHistroryListVo.setEngineType(info.getEngineType());
                ecrHistroryListVo.setUsedResource(ECResourceInfoUtils.getStringToMap(info.getUsedResource(), info));
                ecrHistroryListVo.setReleasedResource(ECResourceInfoUtils.getStringToMap(info.getReleasedResource(), info));
                ecrHistroryListVo.setRequestResource(ECResourceInfoUtils.getStringToMap(info.getRequestResource(), info));
                list.add(ecrHistroryListVo);
            });
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(queryTasks);
        long total = pageInfo.getTotal();
        return Message.ok().data("engineList", list).data(JobRequestConstants.TOTAL_PAGE(), (Object)total);
    }

    @ApiOperation(value="ecList", notes="query engineconn info list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="creators", dataType="Array", required=true, value="creators"), @ApiImplicitParam(name="engineTypes", dataType="Array", value="engine type"), @ApiImplicitParam(name="statuss", dataType="Array", value="statuss"), @ApiImplicitParam(name="queueName", dataType="String", value="queueName"), @ApiImplicitParam(name="ecInstances", dataType="Array", value="ecInstances"), @ApiImplicitParam(name="crossCluster", dataType="String", value="crossCluster")})
    @RequestMapping(path={"/ecList"}, method={RequestMethod.POST})
    public Message queryEcList(HttpServletRequest req, @RequestBody JsonNode jsonNode) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"ecList");
        String token = ModuleUserUtils.getToken((HttpServletRequest)req);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            if (!Configuration.isAdminToken((String)token)) {
                logger.warn("Token:{} has no permission to query ecList.", (Object)token);
                return Message.error((String)("Token:" + token + " has no permission to query ecList."));
            }
        } else if (!Configuration.isAdmin((String)username)) {
            logger.warn("User:{} has no permission to query ecList.", (Object)username);
            return Message.error((String)("User:" + username + " has no permission to query ecList."));
        }
        JsonNode creatorsParam = jsonNode.get("creators");
        JsonNode engineTypesParam = jsonNode.get("engineTypes");
        JsonNode statussParam = jsonNode.get("statuss");
        JsonNode queueNameParam = jsonNode.get("queueName");
        JsonNode ecInstancesParam = jsonNode.get("ecInstances");
        JsonNode crossClusterParam = jsonNode.get("crossCluster");
        List<String> creatorUserList = new ArrayList();
        if (creatorsParam != null && !creatorsParam.isNull()) {
            try {
                creatorUserList = (List)JsonUtils.jackson().readValue(creatorsParam.toString(), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)"parameters:creators parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010creators\u3011\u89e3\u6790\u5931\u8d25)");
            }
            for (String creatorUser : creatorUserList) {
                if (null == creatorUser || ECResourceInfoUtils.checkNameValid(creatorUser)) continue;
                return Message.error((String)("Invalid creator: " + creatorUser));
            }
        }
        ArrayList<String> engineTypeList = new ArrayList();
        if (engineTypesParam != null && !engineTypesParam.isNull()) {
            try {
                engineTypeList = (List)JsonUtils.jackson().readValue(engineTypesParam.toString(), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)"parameters:engineTypes parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010engineTypes\u3011\u89e3\u6790\u5931\u8d25)");
            }
        }
        ArrayList<String> statusStrList = new ArrayList();
        if (statussParam != null && !statussParam.isNull()) {
            try {
                statusStrList = (List)JsonUtils.jackson().readValue(statussParam.toString(), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)"parameters:statuss parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010statuss\u3011\u89e3\u6790\u5931\u8d25)");
            }
        }
        String queueName = "";
        if (queueNameParam != null && !queueNameParam.isNull()) {
            try {
                queueName = (String)JsonUtils.jackson().readValue(queueNameParam.toString(), (TypeReference)new TypeReference<String>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)"parameters:queueName parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010queueName\u3011\u89e3\u6790\u5931\u8d25)");
            }
        }
        ArrayList<String> ecInstancesList = new ArrayList();
        if (ecInstancesParam != null && !ecInstancesParam.isNull()) {
            try {
                ecInstancesList = (List)JsonUtils.jackson().readValue(ecInstancesParam.toString(), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)"parameters:instanceName parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010ecInstances\u3011\u89e3\u6790\u5931\u8d25)");
            }
        }
        Boolean isCrossCluster = null;
        if (crossClusterParam != null && !crossClusterParam.isNull()) {
            try {
                isCrossCluster = (Boolean)JsonUtils.jackson().readValue(crossClusterParam.toString(), (TypeReference)new TypeReference<Boolean>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)"parameters:crossCluster parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010crossCluster\u3011\u89e3\u6790\u5931\u8d25)");
            }
        }
        logger.info("request parameters creatorUserList:[{}], engineTypeList:[{}], statusStrList:[{}], queueName:{}, instanceNameList:{}", new Object[]{String.join((CharSequence)",", creatorUserList), String.join((CharSequence)",", engineTypeList), String.join((CharSequence)",", statusStrList), String.join((CharSequence)",", ecInstancesList), queueNameParam});
        List<Map<String, Object>> list = this.ecResourceInfoService.getECResourceInfoList(creatorUserList, engineTypeList, statusStrList, queueName, ecInstancesList, isCrossCluster);
        return Message.ok().data("ecList", list);
    }
}

