/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.label;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.exception.AMErrorCode;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.label.EngineReuseLabelChooser;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MultiUserEngineReuseLabelChooser
implements EngineReuseLabelChooser {
    private static final Logger logger = LoggerFactory.getLogger(MultiUserEngineReuseLabelChooser.class);
    private final String[] multiUserEngine = ((String)AMConfiguration.MULTI_USER_ENGINE_TYPES.getValue()).split(",");
    private final Map<String, String> userMap = this.getMultiUserEngineUserMap();

    private Map<String, String> getMultiUserEngineUserMap() {
        String userJson = (String)AMConfiguration.MULTI_USER_ENGINE_USER.getValue();
        if (StringUtils.isNotBlank((CharSequence)userJson)) {
            Map userMap = (Map)BDPJettyServerHelper.gson().fromJson(userJson, Map.class);
            return userMap;
        }
        throw new AMErrorException(AMErrorCode.AM_CONF_ERROR.getErrorCode(), String.format("Multi-user engine parameter configuration error, please check key %s", AMConfiguration.MULTI_USER_ENGINE_USER.key()));
    }

    @Override
    public List<Label<?>> chooseLabels(List<Label<?>> labelList) {
        ArrayList labels = new ArrayList(labelList);
        Optional<EngineTypeLabel> engineTypeLabelOption = labels.stream().filter(label -> label instanceof EngineTypeLabel).map(label -> (EngineTypeLabel)label).findFirst();
        if (engineTypeLabelOption.isPresent()) {
            EngineTypeLabel engineTypeLabel = engineTypeLabelOption.get();
            Optional<String> maybeString = Stream.of(this.multiUserEngine).filter(engineTypeLabel.getEngineType()::equalsIgnoreCase).findFirst();
            Optional<UserCreatorLabel> userCreatorLabelOption = labels.stream().filter(label -> label instanceof UserCreatorLabel).map(label -> (UserCreatorLabel)label).findFirst();
            if (maybeString.isPresent() && userCreatorLabelOption.isPresent()) {
                String userAdmin = this.userMap.get(engineTypeLabel.getEngineType());
                UserCreatorLabel userCreatorLabel = userCreatorLabelOption.get();
                logger.info(String.format("For multi user engine to reset userCreatorLabel user %s to Admin %s", userCreatorLabel.getUser(), userAdmin));
                userCreatorLabel.setUser(userAdmin);
                return labels;
            }
        }
        return labelList;
    }
}

