/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.operation.progress;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleBinaryOperator;
import java.util.function.ToDoubleFunction;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.governance.common.constant.job.TaskInfoConstants$;
import org.apache.linkis.orchestrator.OrchestratorSession;
import org.apache.linkis.orchestrator.computation.operation.progress.AbstractProgressOperation;
import org.apache.linkis.orchestrator.computation.operation.progress.DefaultProgressOperation$;
import org.apache.linkis.orchestrator.computation.operation.progress.ProgressConstraints$;
import org.apache.linkis.orchestrator.computation.physical.CodeLogicalUnitExecTask;
import org.apache.linkis.orchestrator.computation.utils.TaskTreeUtil;
import org.apache.linkis.orchestrator.listener.task.TaskRunningInfoEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.plans.physical.PhysicalContext;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001u4Aa\u0004\t\u0001?!AA\u0005\u0001B\u0001B\u0003%Q\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0004.\u0001\u0001\u0007I\u0011\u0002\u0018\t\u000fU\u0002\u0001\u0019!C\u0005m!1A\b\u0001Q!\n=BQ!\u0010\u0001\u0005\u0002yBQa\u0010\u0001\u0005B\u0001CQ\u0001\u0014\u0001\u0005B5CQ\u0001\u0017\u0001\u0005\ne;Q!\u001d\t\t\u0002I4Qa\u0004\t\t\u0002MDQ!K\u0006\u0005\u0002]Dq\u0001_\u0006C\u0002\u0013\u0005\u0011\u0010\u0003\u0004}\u0017\u0001\u0006IA\u001f\u0002\u0019\t\u00164\u0017-\u001e7u!J|wM]3tg>\u0003XM]1uS>t'BA\t\u0013\u0003!\u0001(o\\4sKN\u001c(BA\n\u0015\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u0016-\u0005Y1m\\7qkR\fG/[8o\u0015\t9\u0002$\u0001\u0007pe\u000eDWm\u001d;sCR|'O\u0003\u0002\u001a5\u00051A.\u001b8lSNT!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011C\u0001\u0001!!\t\t#%D\u0001\u0011\u0013\t\u0019\u0003CA\rBEN$(/Y2u!J|wM]3tg>\u0003XM]1uS>t\u0017aE8sG\",7\u000f\u001e:bi>\u00148+Z:tS>t\u0007C\u0001\u0014(\u001b\u00051\u0012B\u0001\u0015\u0017\u0005My%o\u00195fgR\u0014\u0018\r^8s'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\u00111\u0006\f\t\u0003C\u0001AQ\u0001\n\u0002A\u0002\u0015\nQ\"[:J]&$\u0018.\u00197ju\u0016$W#A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u000f\t{w\u000e\\3b]\u0006\t\u0012n]%oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u0005]R\u0004C\u0001\u00199\u0013\tI\u0014G\u0001\u0003V]&$\bbB\u001e\u0005\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0014AD5t\u0013:LG/[1mSj,G\rI\u0001\u0005S:LG\u000fF\u00018\u0003\u001d9W\r\u001e(b[\u0016,\u0012!\u0011\t\u0003\u0005&s!aQ$\u0011\u0005\u0011\u000bT\"A#\u000b\u0005\u0019s\u0012A\u0002\u001fs_>$h(\u0003\u0002Ic\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA\u0015'\u0001\u0007p]B\u0013xn\u001a:fgN|e\u000e\u0006\u00028\u001d\")q\n\u0003a\u0001!\u00069rN]5UCN\\'+\u001e8oS:<\u0017J\u001c4p\u000bZ,g\u000e\u001e\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001^1tW*\u0011QKF\u0001\tY&\u001cH/\u001a8fe&\u0011qK\u0015\u0002\u0015)\u0006\u001c8NU;o]&tw-\u00138g_\u00163XM\u001c;\u0002)\u001d,g.\u001a:bi\u0016,\u00050Z2UCN\\\u0017J\u001c4p)\tQ\u0006\u000e\u0005\u0003\\A\u0006\u0013W\"\u0001/\u000b\u0005us\u0016\u0001B;uS2T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b9\n9\u0001*Y:i\u001b\u0006\u0004\bCA2g\u001b\u0005!'BA3_\u0003\u0011a\u0017M\\4\n\u0005\u001d$'AB(cU\u0016\u001cG\u000fC\u0003T\u0013\u0001\u0007\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006A\u0001\u000f[=tS\u000e\fGN\u0003\u0002o-\u0005)\u0001\u000f\\1og&\u0011\u0001o\u001b\u0002\t\u000bb,7\rV1tW\u0006AB)\u001a4bk2$\bK]8he\u0016\u001c8o\u00149fe\u0006$\u0018n\u001c8\u0011\u0005\u0005Z1CA\u0006u!\t\u0001T/\u0003\u0002wc\t1\u0011I\\=SK\u001a$\u0012A]\u0001\u000e!J{uIU#T'~s\u0015)T#\u0016\u0003i\u0004\"aY>\n\u0005)#\u0017A\u0004)S\u001f\u001e\u0013ViU*`\u001d\u0006kU\t\t")
public class DefaultProgressOperation
extends AbstractProgressOperation {
    private final OrchestratorSession orchestratorSession;
    private boolean isInitialized;

    public static String PROGRESS_NAME() {
        return DefaultProgressOperation$.MODULE$.PROGRESS_NAME();
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    private void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    public void init() {
        if (!this.isInitialized()) {
            DefaultProgressOperation defaultProgressOperation = this;
            synchronized (defaultProgressOperation) {
                if (!this.isInitialized()) {
                    this.orchestratorSession.getOrchestratorSessionState().getOrchestratorAsyncListenerBus().addListener((EventListener)this);
                    this.isInitialized_$eq(true);
                }
            }
            return;
        }
    }

    public String getName() {
        block0: {
            if (this.isInitialized()) break block0;
            this.init();
        }
        return DefaultProgressOperation$.MODULE$.PROGRESS_NAME();
    }

    public void onProgressOn(TaskRunningInfoEvent oriTaskRunningInfoEvent) {
        ObjectRef taskRunningInfoEvent = ObjectRef.create(null);
        HashMap<String, Object> execTaskInfo = this.generateExecTaskInfo(oriTaskRunningInfoEvent.execTask());
        if (oriTaskRunningInfoEvent.infoMap() != null) {
            oriTaskRunningInfoEvent.infoMap().putAll(execTaskInfo);
            taskRunningInfoEvent.elem = new TaskRunningInfoEvent(oriTaskRunningInfoEvent.execTask(), oriTaskRunningInfoEvent.progress(), oriTaskRunningInfoEvent.progressInfo(), oriTaskRunningInfoEvent.resourceMap(), oriTaskRunningInfoEvent.infoMap());
        } else {
            taskRunningInfoEvent.elem = new TaskRunningInfoEvent(oriTaskRunningInfoEvent.execTask(), oriTaskRunningInfoEvent.progress(), oriTaskRunningInfoEvent.progressInfo(), oriTaskRunningInfoEvent.resourceMap(), execTaskInfo);
        }
        ExecTask execTask = ((TaskRunningInfoEvent)taskRunningInfoEvent.elem).execTask();
        Option$.MODULE$.apply((Object)execTask).foreach((Function1 & Serializable & scala.Serializable)task -> {
            DefaultProgressOperation.$anonfun$onProgressOn$1(this, execTask, taskRunningInfoEvent, task);
            return BoxedUnit.UNIT;
        });
    }

    private HashMap<String, Object> generateExecTaskInfo(ExecTask task) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (task == null) {
            this.logger().warn("TaskRunningInfoEvent got null execTask.");
            return map;
        }
        map.put(TaskInfoConstants$.MODULE$.EXEC_ID(), task.getId());
        map.put(TaskInfoConstants$.MODULE$.ID_INFO(), task.getIDInfo());
        map.put(TaskInfoConstants$.MODULE$.TASK_CLASSNAME(), task.getClass().getSimpleName());
        map.put(TaskInfoConstants$.MODULE$.TASK_NAME(), task.getName());
        return map;
    }

    public static final /* synthetic */ float $anonfun$onProgressOn$2(ConcurrentHashMap progressMap$1, CodeLogicalUnitExecTask task) {
        return BoxesRunTime.unboxToFloat((Object)progressMap$1.put(task.getId(), BoxesRunTime.boxToFloat((float)0.0f)));
    }

    public static final /* synthetic */ void $anonfun$onProgressOn$1(DefaultProgressOperation $this, ExecTask execTask$1, ObjectRef taskRunningInfoEvent$1, ExecTask task2) {
        TaskRunningInfoEvent taskRunningInfoEvent;
        PhysicalContext physicalContext = task2.getPhysicalContext();
        Option progressInfo = physicalContext.getOption(ProgressConstraints$.MODULE$.PROGRESS_MAP_NAME());
        if (progressInfo.get() != null) {
            ConcurrentHashMap progressMap = (ConcurrentHashMap)progressInfo.get();
            progressMap.put(execTask$1.getId(), BoxesRunTime.boxToFloat((float)((TaskRunningInfoEvent)taskRunningInfoEvent$1.elem).progress()));
            ConcurrentHashMap concurrentHashMap = progressMap;
            synchronized (concurrentHashMap) {
                double progressValueSum = progressMap.reduceValuesToDouble(1L, new ToDoubleFunction<Object>(null){

                    public double applyAsDouble(float t) {
                        return t;
                    }
                }, 0.0, new DoubleBinaryOperator(null){

                    public double applyAsDouble(double left, double right) {
                        return left + right;
                    }
                });
                TaskRunningInfoEvent taskRunningInfoEvent2 = new TaskRunningInfoEvent(execTask$1, (float)progressValueSum / (float)progressMap.size(), ((TaskRunningInfoEvent)taskRunningInfoEvent$1.elem).progressInfo(), ((TaskRunningInfoEvent)taskRunningInfoEvent$1.elem).resourceMap(), ((TaskRunningInfoEvent)taskRunningInfoEvent$1.elem).infoMap());
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var8_7
                taskRunningInfoEvent = taskRunningInfoEvent2;
            }
        } else {
            ConcurrentHashMap progressMap = (ConcurrentHashMap)physicalContext.getOrElsePut(ProgressConstraints$.MODULE$.PROGRESS_MAP_NAME(), new ConcurrentHashMap());
            List<CodeLogicalUnitExecTask> codeExecTasks = TaskTreeUtil.getAllTaskRecursive(physicalContext.getRootTask(), CodeLogicalUnitExecTask.class);
            if (codeExecTasks != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(codeExecTasks).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToFloat((float)DefaultProgressOperation.$anonfun$onProgressOn$2(progressMap, task)));
            }
            progressMap.put(execTask$1.getId(), BoxesRunTime.boxToFloat((float)((TaskRunningInfoEvent)taskRunningInfoEvent$1.elem).progress()));
            taskRunningInfoEvent = (TaskRunningInfoEvent)taskRunningInfoEvent$1.elem;
        }
        TaskRunningInfoEvent event = taskRunningInfoEvent;
        Option$.MODULE$.apply((Object)$this.execTaskToProgressProcessor().get(execTask$1.getPhysicalContext().getRootTask().getId())).foreach((Function1 & Serializable & scala.Serializable)progress -> {
            progress.onProgress(event.progress(), event.progressInfo(), event.resourceMap(), event.infoMap());
            return BoxedUnit.UNIT;
        });
    }

    public DefaultProgressOperation(OrchestratorSession orchestratorSession) {
        this.orchestratorSession = orchestratorSession;
        super(orchestratorSession);
        this.isInitialized = false;
    }
}

